/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JoinColumn
extends Ejb3Column {
    private String referencedColumn;
    private String mappedBy;
    private String mappedByPropertyName;
    private String mappedByTableName;
    private String mappedByEntityName;
    private boolean JPA2ElementCollection;
    private String manyToManyOwnerSideEntityName;
    public static final int NO_REFERENCE = 0;
    public static final int PK_REFERENCE = 1;
    public static final int NON_PK_REFERENCE = 2;

    public void setJPA2ElementCollection(boolean bl) {
        this.JPA2ElementCollection = bl;
    }

    public String getManyToManyOwnerSideEntityName() {
        return this.manyToManyOwnerSideEntityName;
    }

    public void setManyToManyOwnerSideEntityName(String string) {
        this.manyToManyOwnerSideEntityName = string;
    }

    public void setReferencedColumn(String string) {
        this.referencedColumn = string;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String string) {
        this.mappedBy = string;
    }

    private Ejb3JoinColumn() {
        this.setMappedBy("");
    }

    private Ejb3JoinColumn(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, String string4, Map<String, Join> map, PropertyHolder propertyHolder, String string5, String string6, boolean bl5, Mappings mappings) {
        this.setImplicit(bl5);
        this.setSqlType(string);
        this.setLogicalColumnName(string2);
        this.setNullable(bl);
        this.setUnique(bl2);
        this.setInsertable(bl3);
        this.setUpdatable(bl4);
        this.setSecondaryTableName(string4);
        this.setPropertyHolder(propertyHolder);
        this.setJoins(map);
        this.setMappings(mappings);
        this.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string5));
        this.bind();
        this.referencedColumn = string3;
        this.mappedBy = string6;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static Ejb3JoinColumn[] buildJoinColumnsOrFormulas(JoinColumnsOrFormulas joinColumnsOrFormulas, String string, Map<String, Join> map, PropertyHolder propertyHolder, String string2, Mappings mappings) {
        JoinColumnOrFormula[] joinColumnOrFormulaArray = joinColumnsOrFormulas.value();
        Ejb3JoinColumn[] ejb3JoinColumnArray = new Ejb3JoinColumn[joinColumnOrFormulaArray.length];
        for (int i = 0; i < joinColumnOrFormulaArray.length; ++i) {
            JoinColumnOrFormula joinColumnOrFormula = joinColumnOrFormulaArray[i];
            JoinFormula joinFormula = joinColumnOrFormula.formula();
            ejb3JoinColumnArray[i] = joinFormula.value() != null && !joinFormula.value().equals("") ? Ejb3JoinColumn.buildJoinFormula(joinFormula, string, map, propertyHolder, string2, mappings) : Ejb3JoinColumn.buildJoinColumns(new JoinColumn[]{joinColumnOrFormula.column()}, string, map, propertyHolder, string2, mappings)[0];
        }
        return ejb3JoinColumnArray;
    }

    public static Ejb3JoinColumn buildJoinFormula(JoinFormula joinFormula, String string, Map<String, Join> map, PropertyHolder propertyHolder, String string2, Mappings mappings) {
        Ejb3JoinColumn ejb3JoinColumn = new Ejb3JoinColumn();
        ejb3JoinColumn.setFormula(joinFormula.value());
        ejb3JoinColumn.setReferencedColumn(joinFormula.referencedColumnName());
        ejb3JoinColumn.setMappings(mappings);
        ejb3JoinColumn.setPropertyHolder(propertyHolder);
        ejb3JoinColumn.setJoins(map);
        ejb3JoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string2));
        ejb3JoinColumn.bind();
        return ejb3JoinColumn;
    }

    public static Ejb3JoinColumn[] buildJoinColumns(JoinColumn[] joinColumnArray, String string, Map<String, Join> map, PropertyHolder propertyHolder, String string2, Mappings mappings) {
        return Ejb3JoinColumn.buildJoinColumnsWithDefaultColumnSuffix(joinColumnArray, string, map, propertyHolder, string2, "", mappings);
    }

    public static Ejb3JoinColumn[] buildJoinColumnsWithDefaultColumnSuffix(JoinColumn[] joinColumnArray, String string, Map<String, Join> map, PropertyHolder propertyHolder, String string2, String string3, Mappings mappings) {
        JoinColumn[] joinColumnArray2 = propertyHolder.getOverriddenJoinColumn(StringHelper.qualify(propertyHolder.getPath(), string2));
        if (joinColumnArray2 == null) {
            joinColumnArray2 = joinColumnArray;
        }
        if (joinColumnArray2 == null || joinColumnArray2.length == 0) {
            return new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(null, string, map, propertyHolder, string2, string3, mappings)};
        }
        int n = joinColumnArray2.length;
        Ejb3JoinColumn[] ejb3JoinColumnArray = new Ejb3JoinColumn[n];
        for (int i = 0; i < n; ++i) {
            ejb3JoinColumnArray[i] = Ejb3JoinColumn.buildJoinColumn(joinColumnArray2[i], string, map, propertyHolder, string2, string3, mappings);
        }
        return ejb3JoinColumnArray;
    }

    private static Ejb3JoinColumn buildJoinColumn(JoinColumn joinColumn, String string, Map<String, Join> map, PropertyHolder propertyHolder, String string2, String string3, Mappings mappings) {
        if (joinColumn != null) {
            if (BinderHelper.isEmptyAnnotationValue(string)) {
                throw new AnnotationException("Illegal attempt to define a @JoinColumn with a mappedBy association: " + BinderHelper.getRelativePath(propertyHolder, string2));
            }
            Ejb3JoinColumn ejb3JoinColumn = new Ejb3JoinColumn();
            ejb3JoinColumn.setJoinAnnotation(joinColumn, null);
            if (StringHelper.isEmpty(ejb3JoinColumn.getLogicalColumnName()) && !StringHelper.isEmpty(string3)) {
                ejb3JoinColumn.setLogicalColumnName(string2 + string3);
            }
            ejb3JoinColumn.setJoins(map);
            ejb3JoinColumn.setPropertyHolder(propertyHolder);
            ejb3JoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string2));
            ejb3JoinColumn.setImplicit(false);
            ejb3JoinColumn.setMappings(mappings);
            ejb3JoinColumn.bind();
            return ejb3JoinColumn;
        }
        Ejb3JoinColumn ejb3JoinColumn = new Ejb3JoinColumn();
        ejb3JoinColumn.setMappedBy(string);
        ejb3JoinColumn.setJoins(map);
        ejb3JoinColumn.setPropertyHolder(propertyHolder);
        ejb3JoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string2));
        if (!StringHelper.isEmpty(string3)) {
            ejb3JoinColumn.setLogicalColumnName(string2 + string3);
            ejb3JoinColumn.setImplicit(false);
        } else {
            ejb3JoinColumn.setImplicit(true);
        }
        ejb3JoinColumn.setMappings(mappings);
        ejb3JoinColumn.bind();
        return ejb3JoinColumn;
    }

    public void setJoinAnnotation(JoinColumn joinColumn, String string) {
        if (joinColumn == null) {
            this.setImplicit(true);
        } else {
            this.setImplicit(false);
            if (!BinderHelper.isEmptyAnnotationValue(joinColumn.columnDefinition())) {
                this.setSqlType(joinColumn.columnDefinition());
            }
            if (!BinderHelper.isEmptyAnnotationValue(joinColumn.name())) {
                this.setLogicalColumnName(joinColumn.name());
            }
            this.setNullable(joinColumn.nullable());
            this.setUnique(joinColumn.unique());
            this.setInsertable(joinColumn.insertable());
            this.setUpdatable(joinColumn.updatable());
            this.setReferencedColumn(joinColumn.referencedColumnName());
            this.setSecondaryTableName(joinColumn.table());
        }
    }

    public static Ejb3JoinColumn buildJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn, JoinColumn joinColumn, Value value, Map<String, Join> map, PropertyHolder propertyHolder, Mappings mappings) {
        Column column = (Column)value.getColumnIterator().next();
        String string = mappings.getLogicalColumnName(column.getQuotedName(), value.getTable());
        if (primaryKeyJoinColumn != null || joinColumn != null) {
            String string2;
            String string3;
            String string4;
            if (primaryKeyJoinColumn != null) {
                string4 = primaryKeyJoinColumn.name();
                string3 = primaryKeyJoinColumn.columnDefinition();
                string2 = primaryKeyJoinColumn.referencedColumnName();
            } else {
                string4 = joinColumn.name();
                string3 = joinColumn.columnDefinition();
                string2 = joinColumn.referencedColumnName();
            }
            String string5 = "".equals(string3) ? null : mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string3);
            String string6 = "".equals(string4) ? string : string4;
            string6 = mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string6);
            return new Ejb3JoinColumn(string5, string6, false, false, true, true, string2, null, map, propertyHolder, null, null, false, mappings);
        }
        string = mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
        return new Ejb3JoinColumn(null, string, false, false, true, true, null, null, map, propertyHolder, null, null, true, mappings);
    }

    public void setPersistentClass(PersistentClass persistentClass, Map<String, Join> map, Map<XClass, InheritanceState> map2) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass, map, this.getMappings(), map2);
    }

    public static void checkIfJoinColumn(Object object, PropertyHolder propertyHolder, PropertyData propertyData) {
        if (!(object instanceof Ejb3JoinColumn[])) {
            throw new AnnotationException("@Column cannot be used on an association property: " + propertyHolder.getEntityName() + "." + propertyData.getPropertyName());
        }
    }

    public void copyReferencedStructureAndCreateDefaultJoinColumns(PersistentClass persistentClass, Iterator iterator, SimpleValue simpleValue) {
        if (!this.isNameDeferred()) {
            throw new AssertionFailure("Building implicit column but the column is not implicit");
        }
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            this.linkValueUsingDefaultColumnNaming(column, persistentClass, simpleValue);
        }
        this.setMappingColumn(null);
    }

    public void linkValueUsingDefaultColumnNaming(Column column, PersistentClass persistentClass, SimpleValue simpleValue) {
        String string = this.getMappings().getLogicalColumnName(column.getQuotedName(), persistentClass.getTable());
        String string2 = this.buildDefaultColumnName(persistentClass, string);
        this.setLogicalColumnName(string2);
        this.setReferencedColumn(string);
        this.initMappingColumn(string2, null, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn() != null ? this.getMappingColumn().isNullable() : false, column.getSqlType(), this.getMappingColumn() != null ? this.getMappingColumn().isUnique() : false, false);
        this.linkWithValue(simpleValue);
    }

    public void addDefaultJoinColumnName(PersistentClass persistentClass, String string) {
        String string2 = this.buildDefaultColumnName(persistentClass, string);
        this.getMappingColumn().setName(string2);
        this.setLogicalColumnName(string2);
    }

    private String buildDefaultColumnName(PersistentClass persistentClass, String string) {
        String string2;
        String string3;
        boolean bl = this.mappedByTableName != null || this.mappedByPropertyName != null;
        boolean bl2 = this.getPropertyName() != null;
        Boolean bl3 = StringHelper.isQuoted(string);
        String string4 = string3 = bl3 != false ? StringHelper.unquote(string) : string;
        if (bl) {
            String string5 = StringHelper.unquote(this.mappedByTableName);
            String string6 = this.JPA2ElementCollection && this.mappedByEntityName != null ? StringHelper.unqualify(this.mappedByEntityName) : string5;
            string2 = this.getMappings().getNamingStrategy().foreignKeyColumnName(this.mappedByPropertyName, this.mappedByEntityName, string6, string3);
            if (bl3.booleanValue() || StringHelper.isQuoted(this.mappedByTableName)) {
                string2 = StringHelper.quote(string2);
            }
        } else if (bl2) {
            String string7 = this.getMappings().getLogicalTableName(persistentClass.getTable());
            String string8 = StringHelper.unquote(string7);
            string2 = this.getMappings().getNamingStrategy().foreignKeyColumnName(this.getPropertyName(), persistentClass.getEntityName(), string8, string3);
            if (bl3.booleanValue() || StringHelper.isQuoted(string7)) {
                string2 = StringHelper.quote(string2);
            }
        } else {
            String string9 = this.getMappings().getLogicalTableName(persistentClass.getTable());
            String string10 = StringHelper.unquote(string9);
            string2 = this.getMappings().getNamingStrategy().joinKeyColumnName(string3, string10);
            if (bl3.booleanValue() || StringHelper.isQuoted(string9)) {
                string2 = StringHelper.quote(string2);
            }
        }
        return string2;
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue simpleValue) {
        this.initMappingColumn(column.getQuotedName(), null, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique(), false);
        this.linkWithValue(simpleValue);
    }

    @Override
    protected void addColumnBinding(SimpleValue simpleValue) {
        if (StringHelper.isEmpty(this.mappedBy)) {
            String string = StringHelper.unquote(this.getLogicalColumnName());
            String string2 = StringHelper.unquote(this.getReferencedColumn());
            String string3 = this.getMappings().getNamingStrategy().logicalCollectionColumnName(string, this.getPropertyName(), string2);
            if (StringHelper.isQuoted(this.getLogicalColumnName()) || StringHelper.isQuoted(this.getLogicalColumnName())) {
                string3 = StringHelper.quote(string3);
            }
            this.getMappings().addColumnBinding(string3, this.getMappingColumn(), simpleValue.getTable());
        }
    }

    public static int checkReferencedColumnsType(Ejb3JoinColumn[] ejb3JoinColumnArray, PersistentClass persistentClass, Mappings mappings) {
        HashSet<Column> hashSet = new HashSet<Column>();
        Iterator iterator = persistentClass.getKey().getColumnIterator();
        while (iterator.hasNext()) {
            hashSet.add((Column)iterator.next());
        }
        boolean bl = false;
        boolean bl2 = true;
        if (ejb3JoinColumnArray.length == 0) {
            return 0;
        }
        Object object = BinderHelper.findColumnOwner(persistentClass, ejb3JoinColumnArray[0].getReferencedColumn(), mappings);
        if (object == null) {
            try {
                throw new MappingException("Unable to find column with logical name: " + ejb3JoinColumnArray[0].getReferencedColumn() + " in " + persistentClass.getTable() + " and its related " + "supertables and secondary tables");
            }
            catch (MappingException mappingException) {
                throw new RecoverableException(mappingException);
            }
        }
        Table table = object instanceof PersistentClass ? ((PersistentClass)object).getTable() : ((Join)object).getTable();
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            String string;
            String string2 = ejb3JoinColumn.getReferencedColumn();
            if (!StringHelper.isNotEmpty(string2)) continue;
            try {
                string = mappings.getPhysicalColumnName(string2, table);
            }
            catch (MappingException mappingException) {
                throw new MappingException("Unable to find column with logical name: " + string2 + " in " + table.getName());
            }
            bl2 = false;
            Column column = new Column(string);
            boolean bl3 = hashSet.contains(column);
            if (bl3) continue;
            bl = true;
            break;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 0;
        }
        if (hashSet.size() != ejb3JoinColumnArray.length) {
            return 2;
        }
        return 1;
    }

    public void overrideFromReferencedColumnIfNecessary(Column column) {
        if (this.getMappingColumn() != null) {
            if (StringHelper.isEmpty(this.sqlType)) {
                this.sqlType = column.getSqlType();
                this.getMappingColumn().setSqlType(this.sqlType);
            }
            this.getMappingColumn().setLength(column.getLength());
            this.getMappingColumn().setPrecision(column.getPrecision());
            this.getMappingColumn().setScale(column.getScale());
        }
    }

    @Override
    public void redefineColumnName(String string, String string2, boolean bl) {
        if (StringHelper.isNotEmpty(string)) {
            this.getMappingColumn().setName(bl ? this.getMappings().getNamingStrategy().columnName(string) : string);
        }
    }

    public static Ejb3JoinColumn[] buildJoinTableJoinColumns(JoinColumn[] joinColumnArray, Map<String, Join> map, PropertyHolder propertyHolder, String string, String string2, Mappings mappings) {
        Ejb3JoinColumn[] ejb3JoinColumnArray;
        if (joinColumnArray == null) {
            Ejb3JoinColumn ejb3JoinColumn = new Ejb3JoinColumn();
            ejb3JoinColumn.setImplicit(true);
            ejb3JoinColumn.setNullable(false);
            ejb3JoinColumn.setPropertyHolder(propertyHolder);
            ejb3JoinColumn.setJoins(map);
            ejb3JoinColumn.setMappings(mappings);
            ejb3JoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string));
            ejb3JoinColumn.setMappedBy(string2);
            ejb3JoinColumn.bind();
            ejb3JoinColumnArray = new Ejb3JoinColumn[]{ejb3JoinColumn};
        } else {
            ejb3JoinColumnArray = new Ejb3JoinColumn[joinColumnArray.length];
            for (JoinColumn joinColumn : joinColumnArray) {
                Ejb3JoinColumn ejb3JoinColumn = new Ejb3JoinColumn();
                ejb3JoinColumn.setImplicit(true);
                ejb3JoinColumn.setPropertyHolder(propertyHolder);
                ejb3JoinColumn.setJoins(map);
                ejb3JoinColumn.setMappings(mappings);
                ejb3JoinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string));
                ejb3JoinColumn.setMappedBy(string2);
                ejb3JoinColumn.setJoinAnnotation(joinColumn, string);
                ejb3JoinColumn.setNullable(false);
                ejb3JoinColumn.bind();
                ejb3JoinColumnArray[var9_10] = ejb3JoinColumn;
            }
        }
        return ejb3JoinColumnArray;
    }

    public void setMappedBy(String string, String string2, String string3) {
        this.mappedByEntityName = string;
        this.mappedByTableName = string2;
        this.mappedByPropertyName = string3;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ejb3JoinColumn");
        stringBuilder.append("{logicalColumnName='").append(this.getLogicalColumnName()).append('\'');
        stringBuilder.append(", referencedColumn='").append(this.referencedColumn).append('\'');
        stringBuilder.append(", mappedBy='").append(this.mappedBy).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

