/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;

public class Ejb3DiscriminatorColumn
extends Ejb3Column {
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "DTYPE";
    private static final String DEFAULT_DISCRIMINATOR_TYPE = "string";
    private static final int DEFAULT_DISCRIMINATOR_LENGTH = 31;
    private String discriminatorTypeName;

    public Ejb3DiscriminatorColumn() {
        this.setLogicalColumnName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
        this.setNullable(false);
        this.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        this.setLength(31);
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String string) {
        this.discriminatorTypeName = string;
    }

    public static Ejb3DiscriminatorColumn buildDiscriminatorColumn(DiscriminatorType discriminatorType, DiscriminatorColumn discriminatorColumn, DiscriminatorFormula discriminatorFormula, Mappings mappings) {
        Ejb3DiscriminatorColumn ejb3DiscriminatorColumn = new Ejb3DiscriminatorColumn();
        ejb3DiscriminatorColumn.setMappings(mappings);
        ejb3DiscriminatorColumn.setImplicit(true);
        if (discriminatorFormula != null) {
            ejb3DiscriminatorColumn.setImplicit(false);
            ejb3DiscriminatorColumn.setFormula(discriminatorFormula.value());
        } else if (discriminatorColumn != null) {
            ejb3DiscriminatorColumn.setImplicit(false);
            if (!BinderHelper.isEmptyAnnotationValue(discriminatorColumn.columnDefinition())) {
                ejb3DiscriminatorColumn.setSqlType(discriminatorColumn.columnDefinition());
            }
            if (!BinderHelper.isEmptyAnnotationValue(discriminatorColumn.name())) {
                ejb3DiscriminatorColumn.setLogicalColumnName(discriminatorColumn.name());
            }
            ejb3DiscriminatorColumn.setNullable(false);
        }
        if (DiscriminatorType.CHAR.equals((Object)discriminatorType)) {
            ejb3DiscriminatorColumn.setDiscriminatorTypeName("character");
            ejb3DiscriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.INTEGER.equals((Object)discriminatorType)) {
            ejb3DiscriminatorColumn.setDiscriminatorTypeName("integer");
            ejb3DiscriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.STRING.equals((Object)discriminatorType) || discriminatorType == null) {
            if (discriminatorColumn != null) {
                ejb3DiscriminatorColumn.setLength(discriminatorColumn.length());
            }
            ejb3DiscriminatorColumn.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        } else {
            throw new AssertionFailure("Unknown discriminator type: " + (Object)((Object)discriminatorType));
        }
        ejb3DiscriminatorColumn.bind();
        return ejb3DiscriminatorColumn;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ejb3DiscriminatorColumn");
        stringBuilder.append("{logicalColumnName'").append(this.getLogicalColumnName()).append('\'');
        stringBuilder.append(", discriminatorTypeName='").append(this.discriminatorTypeName).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

