/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.ColumnTransformers;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.IndexOrUniqueKeySecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Column {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Ejb3Column.class.getName());
    private Column mappingColumn;
    private boolean insertable = true;
    private boolean updatable = true;
    private String secondaryTableName;
    protected Map<String, Join> joins;
    protected PropertyHolder propertyHolder;
    private Mappings mappings;
    private boolean isImplicit;
    public static final int DEFAULT_COLUMN_LENGTH = 255;
    public String sqlType;
    private int length = 255;
    private int precision;
    private int scale;
    private String logicalColumnName;
    private String propertyName;
    private boolean unique;
    private boolean nullable = true;
    private String formulaString;
    private org.hibernate.mapping.Formula formula;
    private Table table;
    private String readExpression;
    private String writeExpression;

    public void setTable(Table table) {
        this.table = table;
    }

    public String getLogicalColumnName() {
        return this.logicalColumnName;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isFormula() {
        return StringHelper.isNotEmpty(this.formulaString);
    }

    public String getFormulaString() {
        return this.formulaString;
    }

    public String getSecondaryTableName() {
        return this.secondaryTableName;
    }

    public void setFormula(String string) {
        this.formulaString = string;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public void setUpdatable(boolean bl) {
        this.updatable = bl;
    }

    protected Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setImplicit(boolean bl) {
        this.isImplicit = bl;
    }

    public void setSqlType(String string) {
        this.sqlType = string;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setLogicalColumnName(String string) {
        this.logicalColumnName = string;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public boolean isNullable() {
        return this.mappingColumn.isNullable();
    }

    public void bind() {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            LOG.debugf("Binding formula %s", (Object)this.formulaString);
            this.formula = new org.hibernate.mapping.Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            this.initMappingColumn(this.logicalColumnName, this.propertyName, this.length, this.precision, this.scale, this.nullable, this.sqlType, this.unique, true);
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding column: %s", (Object)this.toString());
            }
        }
    }

    protected void initMappingColumn(String string, String string2, int n, int n2, int n3, boolean bl, String string3, boolean bl2, boolean bl3) {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            this.formula = new org.hibernate.mapping.Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            this.mappingColumn = new Column();
            this.redefineColumnName(string, string2, bl3);
            this.mappingColumn.setLength(n);
            if (n2 > 0) {
                this.mappingColumn.setPrecision(n2);
                this.mappingColumn.setScale(n3);
            }
            this.mappingColumn.setNullable(bl);
            this.mappingColumn.setSqlType(string3);
            this.mappingColumn.setUnique(bl2);
            if (this.writeExpression != null && !this.writeExpression.matches("[^?]*\\?[^?]*")) {
                throw new AnnotationException("@WriteExpression must contain exactly one value placeholder ('?') character: property [" + string2 + "] and column [" + this.logicalColumnName + "]");
            }
            if (this.readExpression != null) {
                this.mappingColumn.setCustomRead(this.readExpression);
            }
            if (this.writeExpression != null) {
                this.mappingColumn.setCustomWrite(this.writeExpression);
            }
        }
    }

    public boolean isNameDeferred() {
        return this.mappingColumn == null || StringHelper.isEmpty(this.mappingColumn.getName());
    }

    public void redefineColumnName(String string, String string2, boolean bl) {
        if (bl) {
            if (StringHelper.isEmpty(string)) {
                if (string2 != null) {
                    this.mappingColumn.setName(this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(this.mappings.getNamingStrategy().propertyToColumnName(string2)));
                }
            } else {
                string = this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
                string = this.mappings.getNamingStrategy().columnName(string);
                string = this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
                this.mappingColumn.setName(string);
            }
        } else if (StringHelper.isNotEmpty(string)) {
            this.mappingColumn.setName(this.mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(string));
        }
    }

    public String getName() {
        return this.mappingColumn.getName();
    }

    public Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setNullable(boolean bl) {
        if (this.mappingColumn != null) {
            this.mappingColumn.setNullable(bl);
        } else {
            this.nullable = bl;
        }
    }

    public void setJoins(Map<String, Join> map) {
        this.joins = map;
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    protected void setMappingColumn(Column column) {
        this.mappingColumn = column;
    }

    public void linkWithValue(SimpleValue simpleValue) {
        if (this.formula != null) {
            simpleValue.addFormula(this.formula);
        } else {
            this.getMappingColumn().setValue(simpleValue);
            simpleValue.addColumn(this.getMappingColumn());
            simpleValue.getTable().addColumn(this.getMappingColumn());
            this.addColumnBinding(simpleValue);
            this.table = simpleValue.getTable();
        }
    }

    protected void addColumnBinding(SimpleValue simpleValue) {
        String string = this.mappings.getNamingStrategy().logicalColumnName(this.logicalColumnName, this.propertyName);
        this.mappings.addColumnBinding(string, this.getMappingColumn(), simpleValue.getTable());
    }

    public Table getTable() {
        if (this.table != null) {
            return this.table;
        }
        if (this.isSecondary()) {
            return this.getJoin().getTable();
        }
        return this.propertyHolder.getTable();
    }

    public boolean isSecondary() {
        if (this.propertyHolder == null) {
            throw new AssertionFailure("Should not call getTable() on column wo persistent class defined");
        }
        return StringHelper.isNotEmpty(this.secondaryTableName);
    }

    public Join getJoin() {
        Join join = this.joins.get(this.secondaryTableName);
        if (join == null) {
            throw new AnnotationException("Cannot find the expected secondary table: no " + this.secondaryTableName + " available for " + this.propertyHolder.getClassName());
        }
        return join;
    }

    public void forceNotNull() {
        this.mappingColumn.setNullable(false);
    }

    public void setSecondaryTableName(String string) {
        this.secondaryTableName = "``".equals(string) ? "" : string;
    }

    public static Ejb3Column[] buildColumnFromAnnotation(javax.persistence.Column[] columnArray, Formula formula, Nullability nullability, PropertyHolder propertyHolder, PropertyData propertyData, Map<String, Join> map, Mappings mappings) {
        return Ejb3Column.buildColumnFromAnnotation(columnArray, formula, nullability, propertyHolder, propertyData, null, map, mappings);
    }

    public static Ejb3Column[] buildColumnFromAnnotation(javax.persistence.Column[] columnArray, Formula formula, Nullability nullability, PropertyHolder propertyHolder, PropertyData propertyData, String string, Map<String, Join> map, Mappings mappings) {
        Ejb3Column[] ejb3ColumnArray;
        if (formula != null) {
            Ejb3Column ejb3Column = new Ejb3Column();
            ejb3Column.setFormula(formula.value());
            ejb3Column.setImplicit(false);
            ejb3Column.setMappings(mappings);
            ejb3Column.setPropertyHolder(propertyHolder);
            ejb3Column.bind();
            ejb3ColumnArray = new Ejb3Column[]{ejb3Column};
        } else {
            javax.persistence.Column[] columnArray2 = columnArray;
            javax.persistence.Column[] columnArray3 = propertyHolder.getOverriddenColumn(StringHelper.qualify(propertyHolder.getPath(), propertyData.getPropertyName()));
            if (columnArray3 != null) {
                if (columnArray != null && columnArray3.length != columnArray.length) {
                    throw new AnnotationException("AttributeOverride.column() should override all columns for now");
                }
                columnArray2 = columnArray3.length == 0 ? null : columnArray3;
                LOG.debugf("Column(s) overridden for property %s", (Object)propertyData.getPropertyName());
            }
            if (columnArray2 == null) {
                ejb3ColumnArray = Ejb3Column.buildImplicitColumn(propertyData, string, map, propertyHolder, nullability, mappings);
            } else {
                int n = columnArray2.length;
                ejb3ColumnArray = new Ejb3Column[n];
                for (int i = 0; i < n; ++i) {
                    ObjectNameNormalizer objectNameNormalizer = mappings.getObjectNameNormalizer();
                    javax.persistence.Column column = columnArray2[i];
                    String string2 = column.columnDefinition().equals("") ? null : objectNameNormalizer.normalizeIdentifierQuoting(column.columnDefinition());
                    String string3 = !StringHelper.isEmpty(column.table()) ? objectNameNormalizer.normalizeIdentifierQuoting(mappings.getNamingStrategy().tableName(column.table())) : "";
                    String string4 = objectNameNormalizer.normalizeIdentifierQuoting(column.name());
                    Ejb3Column ejb3Column = new Ejb3Column();
                    ejb3Column.setImplicit(false);
                    ejb3Column.setSqlType(string2);
                    ejb3Column.setLength(column.length());
                    ejb3Column.setPrecision(column.precision());
                    ejb3Column.setScale(column.scale());
                    if (StringHelper.isEmpty(string4) && !StringHelper.isEmpty(string)) {
                        ejb3Column.setLogicalColumnName(propertyData.getPropertyName() + string);
                    } else {
                        ejb3Column.setLogicalColumnName(string4);
                    }
                    ejb3Column.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyData.getPropertyName()));
                    ejb3Column.setNullable(column.nullable());
                    ejb3Column.setUnique(column.unique());
                    ejb3Column.setInsertable(column.insertable());
                    ejb3Column.setUpdatable(column.updatable());
                    ejb3Column.setSecondaryTableName(string3);
                    ejb3Column.setPropertyHolder(propertyHolder);
                    ejb3Column.setJoins(map);
                    ejb3Column.setMappings(mappings);
                    ejb3Column.extractDataFromPropertyData(propertyData);
                    ejb3Column.bind();
                    ejb3ColumnArray[i] = ejb3Column;
                }
            }
        }
        return ejb3ColumnArray;
    }

    private void extractDataFromPropertyData(PropertyData propertyData) {
        XProperty xProperty;
        if (propertyData != null && (xProperty = propertyData.getProperty()) != null) {
            this.processExpression(xProperty.getAnnotation(ColumnTransformer.class));
            ColumnTransformers columnTransformers = xProperty.getAnnotation(ColumnTransformers.class);
            if (columnTransformers != null) {
                for (ColumnTransformer columnTransformer : columnTransformers.value()) {
                    this.processExpression(columnTransformer);
                }
            }
        }
    }

    private void processExpression(ColumnTransformer columnTransformer) {
        String string;
        String string2 = string = this.logicalColumnName != null ? this.logicalColumnName : "";
        if (columnTransformer != null && (StringHelper.isEmpty(columnTransformer.forColumn()) || columnTransformer.forColumn().equals(string))) {
            this.readExpression = columnTransformer.read();
            if (StringHelper.isEmpty(this.readExpression)) {
                this.readExpression = null;
            }
            this.writeExpression = columnTransformer.write();
            if (StringHelper.isEmpty(this.writeExpression)) {
                this.writeExpression = null;
            }
        }
    }

    private static Ejb3Column[] buildImplicitColumn(PropertyData propertyData, String string, Map<String, Join> map, PropertyHolder propertyHolder, Nullability nullability, Mappings mappings) {
        Ejb3Column ejb3Column = new Ejb3Column();
        Ejb3Column[] ejb3ColumnArray = new Ejb3Column[]{ejb3Column};
        if (nullability != Nullability.FORCED_NULL && propertyData.getClassOrElement().isPrimitive() && !propertyData.getProperty().isArray()) {
            ejb3Column.setNullable(false);
        }
        ejb3Column.setLength(255);
        String string2 = propertyData.getPropertyName();
        ejb3Column.setPropertyName(BinderHelper.getRelativePath(propertyHolder, string2));
        ejb3Column.setPropertyHolder(propertyHolder);
        ejb3Column.setJoins(map);
        ejb3Column.setMappings(mappings);
        if (!StringHelper.isEmpty(string)) {
            ejb3Column.setLogicalColumnName(string2 + string);
            ejb3Column.setImplicit(false);
        } else {
            ejb3Column.setImplicit(true);
        }
        ejb3Column.extractDataFromPropertyData(propertyData);
        ejb3Column.bind();
        return ejb3ColumnArray;
    }

    public static void checkPropertyConsistency(Ejb3Column[] ejb3ColumnArray, String string) {
        int n = ejb3ColumnArray.length;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                if (ejb3ColumnArray[i].isFormula() || ejb3ColumnArray[i - 1].isFormula()) continue;
                if (ejb3ColumnArray[i].isInsertable() != ejb3ColumnArray[i - 1].isInsertable()) {
                    throw new AnnotationException("Mixing insertable and non insertable columns in a property is not allowed: " + string);
                }
                if (ejb3ColumnArray[i].isNullable() != ejb3ColumnArray[i - 1].isNullable()) {
                    throw new AnnotationException("Mixing nullable and non nullable columns in a property is not allowed: " + string);
                }
                if (ejb3ColumnArray[i].isUpdatable() != ejb3ColumnArray[i - 1].isUpdatable()) {
                    throw new AnnotationException("Mixing updatable and non updatable columns in a property is not allowed: " + string);
                }
                if (ejb3ColumnArray[i].getTable().equals(ejb3ColumnArray[i - 1].getTable())) continue;
                throw new AnnotationException("Mixing different tables in a property is not allowed: " + string);
            }
        }
    }

    public void addIndex(Index index, boolean bl) {
        if (index == null) {
            return;
        }
        String string = index.name();
        this.addIndex(string, bl);
    }

    void addIndex(String string, boolean bl) {
        IndexOrUniqueKeySecondPass indexOrUniqueKeySecondPass = new IndexOrUniqueKeySecondPass(string, this, this.mappings, false);
        if (bl) {
            indexOrUniqueKeySecondPass.doSecondPass(this.mappings.getClasses());
        } else {
            this.mappings.addSecondPass(indexOrUniqueKeySecondPass);
        }
    }

    void addUniqueKey(String string, boolean bl) {
        IndexOrUniqueKeySecondPass indexOrUniqueKeySecondPass = new IndexOrUniqueKeySecondPass(string, this, this.mappings, true);
        if (bl) {
            indexOrUniqueKeySecondPass.doSecondPass(this.mappings.getClasses());
        } else {
            this.mappings.addSecondPass(indexOrUniqueKeySecondPass);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ejb3Column");
        stringBuilder.append("{table=").append(this.getTable());
        stringBuilder.append(", mappingColumn=").append(this.mappingColumn.getName());
        stringBuilder.append(", insertable=").append(this.insertable);
        stringBuilder.append(", updatable=").append(this.updatable);
        stringBuilder.append(", unique=").append(this.unique);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

