/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.InputStream;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.xml.DTDEntityResolver;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EJB3DTDEntityResolver
extends DTDEntityResolver {
    public static final EntityResolver INSTANCE = new EJB3DTDEntityResolver();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EJB3DTDEntityResolver.class.getName());
    boolean resolved = false;

    public boolean isResolved() {
        return this.resolved;
    }

    public InputSource resolveEntity(String string, String string2) {
        LOG.tracev("Resolving XML entity {0} : {1}", (Object)string, (Object)string2);
        InputSource inputSource = super.resolveEntity(string, string2);
        if (inputSource == null) {
            if (string2 != null) {
                InputStream inputStream;
                InputSource inputSource2;
                if (string2.endsWith("orm_1_0.xsd")) {
                    InputStream inputStream2 = this.getStreamFromClasspath("orm_1_0.xsd");
                    InputSource inputSource3 = this.buildInputSource(string, string2, inputStream2, false);
                    if (inputSource3 != null) {
                        return inputSource3;
                    }
                } else if (string2.endsWith("orm_2_0.xsd")) {
                    InputStream inputStream3 = this.getStreamFromClasspath("orm_2_0.xsd");
                    InputSource inputSource4 = this.buildInputSource(string, string2, inputStream3, false);
                    if (inputSource4 != null) {
                        return inputSource4;
                    }
                } else if (string2.endsWith("persistence_1_0.xsd")) {
                    InputStream inputStream4 = this.getStreamFromClasspath("persistence_1_0.xsd");
                    InputSource inputSource5 = this.buildInputSource(string, string2, inputStream4, true);
                    if (inputSource5 != null) {
                        return inputSource5;
                    }
                } else if (string2.endsWith("persistence_2_0.xsd") && (inputSource2 = this.buildInputSource(string, string2, inputStream = this.getStreamFromClasspath("persistence_2_0.xsd"), true)) != null) {
                    return inputSource2;
                }
            }
        } else {
            this.resolved = true;
            return inputSource;
        }
        return null;
    }

    private InputSource buildInputSource(String string, String string2, InputStream inputStream, boolean bl) {
        if (inputStream == null) {
            LOG.tracev("Unable to locate [{0}] on classpath", (Object)string2);
            return null;
        }
        LOG.tracev("Located [{0}] in classpath", (Object)string2);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        this.resolved = bl;
        return inputSource;
    }

    private InputStream getStreamFromClasspath(String string) {
        LOG.trace("Recognized JPA ORM namespace; attempting to resolve on classpath under org/hibernate/ejb");
        String string2 = "org/hibernate/ejb/" + string;
        InputStream inputStream = this.resolveInHibernateNamespace(string2);
        return inputStream;
    }
}

