/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.DuplicateMappingException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.internal.util.xml.MappingReader;
import org.hibernate.internal.util.xml.Origin;
import org.hibernate.internal.util.xml.OriginImpl;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.internal.util.xml.XmlDocument;
import org.hibernate.internal.util.xml.XmlDocumentImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.spi.TypeContributions;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.internal.JACCConfiguration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.SchemaUpdateScript;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Configuration.class.getName());
    public static final String DEFAULT_CACHE_CONCURRENCY_STRATEGY = "hibernate.cache.default_cache_concurrency_strategy";
    public static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    private static final String SEARCH_STARTUP_CLASS = "org.hibernate.search.event.EventListenerRegister";
    private static final String SEARCH_STARTUP_METHOD = "enableHibernateSearch";
    protected MetadataSourceQueue metadataSourceQueue;
    private transient ReflectionManager reflectionManager;
    protected Map<String, PersistentClass> classes;
    protected Map<String, String> imports;
    protected Map<String, Collection> collections;
    protected Map<String, Table> tables;
    protected List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    protected Map<String, NamedQueryDefinition> namedQueries;
    protected Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    protected Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    protected Map<String, TypeDef> typeDefs;
    protected Map<String, FilterDefinition> filterDefinitions;
    protected Map<String, FetchProfile> fetchProfiles;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    protected List<SecondPass> secondPasses;
    protected List<Mappings.PropertyReference> propertyReferences;
    protected Map<ExtendsQueueEntry, ?> extendsQueue;
    protected Map<String, SQLFunction> sqlFunctions;
    private TypeResolver typeResolver = new TypeResolver();
    private List<TypeContributor> typeContributorRegistrations = new ArrayList<TypeContributor>();
    private EntityTuplizerFactory entityTuplizerFactory;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected NamingStrategy namingStrategy;
    private SessionFactoryObserver sessionFactoryObserver;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private MutableIdentifierGeneratorFactory identifierGeneratorFactory;
    private Map<Class<?>, org.hibernate.mapping.MappedSuperclass> mappedSuperClasses;
    private Map<String, IdGenerator> namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResultSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<UniqueConstraintHolder>> uniqueConstraintHoldersByTable;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Map<String, AnyMetaDef> anyMetaDefs;
    private List<CacheHolder> caches;
    private boolean inSecondPass = false;
    private boolean isDefaultProcessed = false;
    private boolean isValidatorNotPresentLogged;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;
    private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private boolean specjProprietarySyntaxEnabled;
    final ObjectNameNormalizer normalizer = new ObjectNameNormalizerImpl();
    public static final MetadataSourceType[] DEFAULT_ARTEFACT_PROCESSING_ORDER = new MetadataSourceType[]{MetadataSourceType.HBM, MetadataSourceType.CLASS};
    private List<MetadataSourceType> metadataSourcePrecedence;

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    protected void reset() {
        this.metadataSourceQueue = new MetadataSourceQueue();
        this.createReflectionManager();
        this.classes = new HashMap<String, PersistentClass>();
        this.imports = new HashMap<String, String>();
        this.collections = new HashMap<String, Collection>();
        this.tables = new TreeMap<String, Table>();
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        this.typeDefs = new HashMap<String, TypeDef>();
        this.filterDefinitions = new HashMap<String, FilterDefinition>();
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.secondPasses = new ArrayList<SecondPass>();
        this.propertyReferences = new ArrayList<Mappings.PropertyReference>();
        this.extendsQueue = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.sqlFunctions = new HashMap<String, SQLFunction>();
        this.entityTuplizerFactory = new EntityTuplizerFactory();
        this.identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
        this.mappedSuperClasses = new HashMap();
        this.metadataSourcePrecedence = Collections.emptyList();
        this.namedGenerators = new HashMap<String, IdGenerator>();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResultSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.uniqueConstraintHoldersByTable = new HashMap<Table, List<UniqueConstraintHolder>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.caches = new ArrayList<CacheHolder>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.setEntityResolver(new EJB3DTDEntityResolver());
        this.anyMetaDefs = new HashMap<String, AnyMetaDef>();
        this.propertiesAnnotatedWithMapsId = new HashMap<XClass, Map<String, PropertyData>>();
        this.propertiesAnnotatedWithIdAndToOne = new HashMap<XClass, Map<String, PropertyData>>();
        this.specjProprietarySyntaxEnabled = System.getProperty("hibernate.enable_specj_proprietary_syntax") != null;
    }

    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public Iterator<PersistentClass> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator<Table> getTableMappings() {
        return this.tables.values().iterator();
    }

    public Iterator<org.hibernate.mapping.MappedSuperclass> getMappedSuperclassMappings() {
        return this.mappedSuperClasses.values().iterator();
    }

    public PersistentClass getClassMapping(String string) {
        return this.classes.get(string);
    }

    public Collection getCollectionMapping(String string) {
        return this.collections.get(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String string) throws MappingException {
        return this.addFile(new File(string));
    }

    public Configuration addFile(File file) throws MappingException {
        InputSource inputSource;
        LOG.readingMappingsFromFile(file.getPath());
        String string = file.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MappingNotFoundException("file", file.toString());
        }
        this.add(inputSource, "file", string);
        return this;
    }

    private XmlDocument add(InputSource inputSource, String string, String string2) {
        return this.add(inputSource, new OriginImpl(string, string2));
    }

    private XmlDocument add(InputSource inputSource, Origin origin) {
        XmlDocument xmlDocument = MappingReader.INSTANCE.readMappingDocument(this.entityResolver, inputSource, origin);
        this.add(xmlDocument);
        return xmlDocument;
    }

    public void add(XmlDocument xmlDocument) {
        if (this.inSecondPass || !Configuration.isOrmXml(xmlDocument)) {
            this.metadataSourceQueue.add(xmlDocument);
        } else {
            MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
            JPAMetadataProvider jPAMetadataProvider = (JPAMetadataProvider)metadataProvider;
            List<String> list = jPAMetadataProvider.getXMLContext().addDocument(xmlDocument.getDocumentTree());
            for (String string : list) {
                try {
                    this.metadataSourceQueue.add(this.reflectionManager.classForName(string, this.getClass()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to load class defined in XML: " + string, classNotFoundException);
                }
            }
        }
    }

    private static boolean isOrmXml(XmlDocument xmlDocument) {
        return "entity-mappings".equals(xmlDocument.getDocumentTree().getRootElement().getName());
    }

    public Configuration addCacheableFile(File file) throws MappingException {
        InputSource inputSource;
        File file2 = this.determineCachedDomFile(file);
        try {
            return this.addCacheableFileStrictly(file);
        }
        catch (SerializationException serializationException) {
            LOG.unableToDeserializeCache(file2.getPath(), serializationException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.cachedFileNotFound(file2.getPath(), fileNotFoundException);
        }
        String string = file.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MappingNotFoundException("file", file.toString());
        }
        LOG.readingMappingsFromFile(file.getPath());
        XmlDocument xmlDocument = this.add(inputSource, "file", string);
        try {
            LOG.debugf("Writing cache file for: %s to: %s", (Object)file, (Object)file2);
            SerializationHelper.serialize((Serializable)((Object)xmlDocument.getDocumentTree()), new FileOutputStream(file2));
        }
        catch (Exception exception) {
            LOG.unableToWriteCachedFile(file2.getPath(), exception.getMessage());
        }
        return this;
    }

    private File determineCachedDomFile(File file) {
        return new File(file.getAbsolutePath() + ".bin");
    }

    public Configuration addCacheableFileStrictly(File file) throws SerializationException, FileNotFoundException {
        boolean bl;
        File file2 = this.determineCachedDomFile(file);
        boolean bl2 = bl = file.exists() && file2.exists() && file.lastModified() < file2.lastModified();
        if (!bl) {
            throw new FileNotFoundException("Cached file could not be found or could not be used");
        }
        LOG.readingCachedMappings(file2);
        Document document = (Document)SerializationHelper.deserialize(new FileInputStream(file2));
        this.add(new XmlDocumentImpl(document, "file", file.getAbsolutePath()));
        return this;
    }

    public Configuration addCacheableFile(String string) throws MappingException {
        return this.addCacheableFile(new File(string));
    }

    public Configuration addXML(String string) throws MappingException {
        LOG.debugf("Mapping XML:\n%s", (Object)string);
        InputSource inputSource = new InputSource(new StringReader(string));
        this.add(inputSource, "string", "XML String");
        return this;
    }

    public Configuration addURL(URL uRL) throws MappingException {
        String string = uRL.toExternalForm();
        LOG.debugf("Reading mapping document from URL : %s", (Object)string);
        try {
            this.add(uRL.openStream(), "URL", string);
        }
        catch (IOException iOException) {
            throw new InvalidMappingException("Unable to open url stream [" + string + "]", "URL", string, iOException);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument add(InputStream inputStream, String string, String string2) {
        InputSource inputSource = new InputSource(inputStream);
        try {
            XmlDocument xmlDocument = this.add(inputSource, string, string2);
            return xmlDocument;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.trace("Was unable to close input stream");
            }
        }
    }

    public Configuration addDocument(org.w3c.dom.Document document) throws MappingException {
        LOG.debugf("Mapping Document:\n%s", (Object)document);
        Document document2 = this.xmlHelper.createDOMReader().read(document);
        this.add(new XmlDocumentImpl(document2, "unknown", null));
        return this;
    }

    public Configuration addInputStream(InputStream inputStream) throws MappingException {
        this.add(inputStream, "input stream", null);
        return this;
    }

    public Configuration addResource(String string, ClassLoader classLoader) throws MappingException {
        LOG.readingMappingsFromResource(string);
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        this.add(inputStream, "resource", string);
        return this;
    }

    public Configuration addResource(String string) throws MappingException {
        LOG.readingMappingsFromResource(string);
        ClassLoader classLoader = ClassLoaderHelper.getContextClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        this.add(inputStream, "resource", string);
        return this;
    }

    public Configuration addClass(Class clazz) throws MappingException {
        String string = clazz.getName().replace('.', '/') + ".hbm.xml";
        LOG.readingMappingsFromResource(string);
        return this.addResource(string, clazz.getClassLoader());
    }

    public Configuration addAnnotatedClass(Class clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        this.metadataSourceQueue.add(xClass);
        return this;
    }

    public Configuration addPackage(String string) throws MappingException {
        LOG.debugf("Mapping Package %s", (Object)string);
        try {
            AnnotationBinder.bindPackage(string, this.createMappings());
            return this;
        }
        catch (MappingException mappingException) {
            LOG.unableToParseMetadata(string);
            throw mappingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File file) throws MappingException {
        LOG.searchingForMappingDocuments(file.getName());
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), iOException);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                LOG.foundMappingDocument(zipEntry.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(zipEntry));
                }
                catch (Exception exception) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), exception);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                LOG.unableToCloseJar(iOException.getMessage());
            }
        }
    }

    public Configuration addDirectory(File file) throws MappingException {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.addDirectory(file2);
                continue;
            }
            if (!file2.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file2);
        }
        return this;
    }

    public Mappings createMappings() {
        return new MappingsImpl();
    }

    private Iterator<IdentifierGenerator> iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator identifierGenerator;
        TreeMap<Object, IdentifierGenerator> treeMap = new TreeMap<Object, IdentifierGenerator>();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        for (PersistentClass filterable : this.classes.values()) {
            if (filterable.isInherited()) continue;
            identifierGenerator = filterable.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, string, string2, (RootClass)filterable);
            if (identifierGenerator instanceof PersistentIdentifierGenerator) {
                treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
                continue;
            }
            if (!(identifierGenerator instanceof IdentifierGeneratorAggregator)) continue;
            ((IdentifierGeneratorAggregator)((Object)identifierGenerator)).registerPersistentGenerators(treeMap);
        }
        for (Collection collection : this.collections.values()) {
            if (!collection.isIdentified() || !((identifierGenerator = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, string, string2, null)) instanceof PersistentIdentifierGenerator)) continue;
            treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
        }
        return treeMap.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        RelationalModel relationalModel;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> arrayList = new ArrayList<String>(50);
        Iterator<Object> iterator = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (iterator.hasPrevious()) {
            relationalModel = iterator.previous();
            if (!relationalModel.appliesToDialect(dialect)) continue;
            arrayList.add(relationalModel.sqlDropString(dialect, string, string2));
        }
        if (dialect.dropConstraints()) {
            iterator = this.getTableMappings();
            while (iterator.hasNext()) {
                relationalModel = (Table)iterator.next();
                if (!((Table)relationalModel).isPhysicalTable()) continue;
                Iterator iterator2 = ((Table)relationalModel).getForeignKeyIterator();
                while (iterator2.hasNext()) {
                    ForeignKey foreignKey = (ForeignKey)iterator2.next();
                    if (!foreignKey.isPhysicalConstraint()) continue;
                    arrayList.add(foreignKey.sqlDropString(dialect, string, string2));
                }
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            relationalModel = (Table)iterator.next();
            if (!((Table)relationalModel).isPhysicalTable()) continue;
            arrayList.add(((Table)relationalModel).sqlDropString(dialect, string, string2));
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            relationalModel = ((PersistentIdentifierGenerator)iterator.next()).sqlDropStrings(dialect);
            arrayList.addAll(Arrays.asList(relationalModel));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        RelationalModel relationalModel;
        Object object2;
        this.secondPassCompile();
        ArrayList<String> arrayList = new ArrayList<String>(50);
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!object2.isPhysicalTable()) continue;
            arrayList.add(object2.sqlCreateString(dialect, this.mapping, string, string2));
            Iterator object3 = object2.sqlCommentStrings(dialect, string, string2);
            while (object3.hasNext()) {
                arrayList.add((String)object3.next());
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!object2.isPhysicalTable()) continue;
            Iterator iterator2 = object2.getUniqueKeyIterator();
            while (iterator2.hasNext()) {
                relationalModel = (UniqueKey)iterator2.next();
                String string3 = ((UniqueKey)relationalModel).sqlCreateString(dialect, this.mapping, string, string2);
                if (string3 == null) continue;
                arrayList.add(string3);
            }
            Iterator iterator3 = object2.getIndexIterator();
            while (iterator3.hasNext()) {
                relationalModel = (Index)iterator3.next();
                arrayList.add(((Index)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!object2.isPhysicalTable() || !dialect.hasAlterTable()) continue;
            Iterator iterator4 = object2.getForeignKeyIterator();
            while (iterator4.hasNext()) {
                relationalModel = (ForeignKey)iterator4.next();
                if (!((ForeignKey)relationalModel).isPhysicalConstraint()) continue;
                arrayList.add(((Constraint)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object2 = ((PersistentIdentifierGenerator)iterator.next()).sqlCreateStrings(dialect);
            arrayList.addAll(Arrays.asList(object2));
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            arrayList.add(auxiliaryDatabaseObject.sqlCreateString(dialect, this.mapping, string, string2));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    @Deprecated
    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        List<SchemaUpdateScript> list = this.generateSchemaUpdateScriptList(dialect, databaseMetadata);
        return SchemaUpdateScript.toStringArray(list);
    }

    public List<SchemaUpdateScript> generateSchemaUpdateScriptList(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        RelationalModel relationalModel;
        Iterator iterator;
        TableMetadata tableMetadata;
        String[] stringArray;
        Object object;
        Object object2;
        this.secondPassCompile();
        String[] stringArray2 = this.properties.getProperty("hibernate.default_catalog");
        String string = this.properties.getProperty("hibernate.default_schema");
        UniqueConstraintSchemaUpdateStrategy uniqueConstraintSchemaUpdateStrategy = UniqueConstraintSchemaUpdateStrategy.interpret(this.properties.get("hibernate.schema_update.unique_constraint_strategy"));
        ArrayList<SchemaUpdateScript> arrayList = new ArrayList<SchemaUpdateScript>();
        Iterator<Object> iterator2 = this.getTableMappings();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = ((Table)object2).getSchema() == null ? string : ((Table)object2).getSchema();
            Object object3 = stringArray = ((Table)object2).getCatalog() == null ? stringArray2 : ((Table)object2).getCatalog();
            if (!((Table)object2).isPhysicalTable()) continue;
            tableMetadata = databaseMetadata.getTableMetadata(((Table)object2).getName(), (String)object, (String)stringArray, ((Table)object2).isQuoted());
            if (tableMetadata == null) {
                arrayList.add(new SchemaUpdateScript(((Table)object2).sqlCreateString(dialect, this.mapping, (String)stringArray, (String)object), false));
            } else {
                iterator = ((Table)object2).sqlAlterStrings(dialect, this.mapping, tableMetadata, (String)stringArray, (String)object);
                while (iterator.hasNext()) {
                    arrayList.add(new SchemaUpdateScript((String)iterator.next(), false));
                }
            }
            iterator = ((Table)object2).sqlCommentStrings(dialect, (String)stringArray2, string);
            while (iterator.hasNext()) {
                arrayList.add(new SchemaUpdateScript((String)iterator.next(), false));
            }
        }
        iterator2 = this.getTableMappings();
        while (iterator2.hasNext()) {
            Object object4;
            object2 = iterator2.next();
            object = ((Table)object2).getSchema() == null ? string : ((Table)object2).getSchema();
            Object object5 = stringArray = ((Table)object2).getCatalog() == null ? stringArray2 : ((Table)object2).getCatalog();
            if (!((Table)object2).isPhysicalTable()) continue;
            tableMetadata = databaseMetadata.getTableMetadata(((Table)object2).getName(), (String)object, (String)stringArray, ((Table)object2).isQuoted());
            if (!uniqueConstraintSchemaUpdateStrategy.equals((Object)UniqueConstraintSchemaUpdateStrategy.SKIP)) {
                iterator = ((Table)object2).getUniqueKeyIterator();
                while (iterator.hasNext()) {
                    relationalModel = (UniqueKey)iterator.next();
                    if (tableMetadata != null && StringHelper.isNotEmpty(((Constraint)relationalModel).getName()) && (object4 = tableMetadata.getIndexMetadata(((Constraint)relationalModel).getName())) != null) continue;
                    object4 = ((UniqueKey)relationalModel).sqlCreateString(dialect, this.mapping, (String)stringArray, (String)object);
                    if (object4 != null && !((String)object4).isEmpty() && uniqueConstraintSchemaUpdateStrategy.equals((Object)UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY)) {
                        String string2 = ((UniqueKey)relationalModel).sqlDropString(dialect, (String)stringArray, (String)stringArray);
                        arrayList.add(new SchemaUpdateScript(string2, true));
                    }
                    arrayList.add(new SchemaUpdateScript((String)object4, true));
                }
            }
            iterator = ((Table)object2).getIndexIterator();
            while (iterator.hasNext()) {
                relationalModel = (Index)iterator.next();
                if (tableMetadata != null && StringHelper.isNotEmpty(((Index)relationalModel).getName()) && (object4 = tableMetadata.getIndexMetadata(((Index)relationalModel).getName())) != null) continue;
                arrayList.add(new SchemaUpdateScript(((Index)relationalModel).sqlCreateString(dialect, this.mapping, (String)stringArray, (String)object), false));
            }
        }
        iterator2 = this.getTableMappings();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = ((Table)object2).getSchema() == null ? string : ((Table)object2).getSchema();
            Object object6 = stringArray = ((Table)object2).getCatalog() == null ? stringArray2 : ((Table)object2).getCatalog();
            if (!((Table)object2).isPhysicalTable()) continue;
            tableMetadata = databaseMetadata.getTableMetadata(((Table)object2).getName(), (String)object, (String)stringArray, ((Table)object2).isQuoted());
            if (!dialect.hasAlterTable()) continue;
            iterator = ((Table)object2).getForeignKeyIterator();
            while (iterator.hasNext()) {
                boolean bl;
                relationalModel = (ForeignKey)iterator.next();
                if (!((ForeignKey)relationalModel).isPhysicalConstraint() || !(bl = tableMetadata == null || tableMetadata.getForeignKeyMetadata((ForeignKey)relationalModel) == null && (!(dialect instanceof MySQLDialect) || tableMetadata.getIndexMetadata(((Constraint)relationalModel).getName()) == null))) continue;
                arrayList.add(new SchemaUpdateScript(((Constraint)relationalModel).sqlCreateString(dialect, this.mapping, (String)stringArray, (String)object), false));
            }
        }
        iterator2 = this.iterateGenerators(dialect);
        while (iterator2.hasNext()) {
            object2 = (PersistentIdentifierGenerator)iterator2.next();
            object = object2.generatorKey();
            if (databaseMetadata.isSequence(object) || databaseMetadata.isTable(object)) continue;
            stringArray = object2.sqlCreateStrings(dialect);
            arrayList.addAll(SchemaUpdateScript.fromStringArray(stringArray, false));
        }
        return arrayList;
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Object object;
        Object object2;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!((Table)object2).isPhysicalTable()) continue;
            object = databaseMetadata.getTableMetadata(((Table)object2).getName(), ((Table)object2).getSchema() == null ? string2 : ((Table)object2).getSchema(), ((Table)object2).getCatalog() == null ? string : ((Table)object2).getCatalog(), ((Table)object2).isQuoted());
            if (object == null) {
                throw new HibernateException("Missing table: " + ((Table)object2).getName());
            }
            ((Table)object2).validateColumns(dialect, this.mapping, (TableMetadata)object);
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object2 = (PersistentIdentifierGenerator)iterator.next();
            object = object2.generatorKey();
            if (databaseMetadata.isSequence(object) || databaseMetadata.isTable(object)) continue;
            throw new HibernateException("Missing sequence or table: " + object);
        }
    }

    private void validate() throws MappingException {
        Iterator<Filterable> iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().validate(this.mapping);
        }
        iterator = this.collections.values().iterator();
        while (iterator.hasNext()) {
            ((Collection)iterator.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        Object object;
        Object object2;
        LOG.trace("Starting secondPassCompile() processing");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderHelper.getContextClassLoader());
        if (!this.isDefaultProcessed) {
            Map map = this.reflectionManager.getDefaults();
            Object object3 = map.get("delimited-identifier");
            if (object3 != null && object3 == Boolean.TRUE) {
                this.getProperties().put("hibernate.globally_quoted_identifiers", "true");
            }
            if (StringHelper.isNotEmpty((String)(object2 = (String)map.get("schema")))) {
                this.getProperties().put("hibernate.default_schema", object2);
            }
            if (StringHelper.isNotEmpty((String)(object = (String)map.get("catalog")))) {
                this.getProperties().put("hibernate.default_catalog", object);
            }
            AnnotationBinder.bindDefaults(this.createMappings());
            this.isDefaultProcessed = true;
        }
        this.metadataSourceQueue.syncAnnotatedClasses();
        this.metadataSourceQueue.processMetadata(this.determineMetadataSourcePrecedence());
        try {
            this.inSecondPass = true;
            this.processSecondPassesOfType(PkDrivenByDefaultMapsIdSecondPass.class);
            this.processSecondPassesOfType(SetSimpleValueTypeSecondPass.class);
            this.processSecondPassesOfType(CopyIdentifierComponentSecondPass.class);
            this.processFkSecondPassInOrder();
            this.processSecondPassesOfType(CreateKeySecondPass.class);
            this.processSecondPassesOfType(SecondaryTableSecondPass.class);
            this.originalSecondPassCompile();
            this.inSecondPass = false;
        }
        catch (RecoverableException recoverableException) {
            throw (RuntimeException)recoverableException.getCause();
        }
        for (CacheHolder cacheHolder : this.caches) {
            if (cacheHolder.isClass) {
                this.applyCacheConcurrencyStrategy(cacheHolder);
                continue;
            }
            this.applyCollectionCacheConcurrencyStrategy(cacheHolder);
        }
        this.caches.clear();
        for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.uniqueConstraintHoldersByTable.entrySet()) {
            object2 = entry.getKey();
            object = entry.getValue();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                UniqueConstraintHolder uniqueConstraintHolder = (UniqueConstraintHolder)iterator.next();
                this.buildUniqueKeyFromColumnNames((Table)object2, uniqueConstraintHolder.getName(), uniqueConstraintHolder.getColumns());
            }
        }
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private void processSecondPassesOfType(Class<? extends SecondPass> clazz) {
        Iterator<SecondPass> iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            if (!clazz.isInstance(secondPass)) continue;
            secondPass.doSecondPass(this.classes);
            iterator.remove();
        }
    }

    private void processFkSecondPassInOrder() {
        Object object2;
        LOG.debug("Processing fk mappings (*ToOne and JoinedSubclass)");
        List<FkSecondPass> list = this.getFKSecondPassesOnly();
        if (list.size() == 0) {
            return;
        }
        HashMap<String, Set<FkSecondPass>> hashMap = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>(list.size());
        for (FkSecondPass object22 : list) {
            if (object22.isInPrimaryKey()) {
                object2 = object22.getReferencedEntityName();
                PersistentClass persistentClass = this.getClassMapping((String)object2);
                String string = this.quotedTableName(persistentClass.getTable());
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new HashSet());
                }
                ((Set)hashMap.get(string)).add(object22);
                continue;
            }
            arrayList.add(object22);
        }
        ArrayList arrayList2 = new ArrayList(list.size());
        for (Object object2 : hashMap.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(arrayList2, hashMap, (String)object2, (String)object2);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object2 = (FkSecondPass)iterator.next();
            object2.doSecondPass(this.classes);
        }
        this.processEndOfQueue(arrayList);
    }

    private List<FkSecondPass> getFKSecondPassesOnly() {
        Iterator<SecondPass> iterator = this.secondPasses.iterator();
        ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>(this.secondPasses.size());
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            if (!(secondPass instanceof FkSecondPass)) continue;
            arrayList.add((FkSecondPass)secondPass);
            iterator.remove();
        }
        return arrayList;
    }

    private void buildRecursiveOrderedFkSecondPasses(List<FkSecondPass> list, Map<String, Set<FkSecondPass>> map, String string, String string2) {
        Set<FkSecondPass> set = map.get(string2);
        if (set == null || set.size() == 0) {
            return;
        }
        for (FkSecondPass fkSecondPass : set) {
            String string3 = this.quotedTableName(fkSecondPass.getValue().getTable());
            if (string3.compareTo(string) == 0) {
                StringBuilder stringBuilder = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                throw new AnnotationException(stringBuilder.toString());
            }
            this.buildRecursiveOrderedFkSecondPasses(list, map, string, string3);
            if (list.contains(fkSecondPass)) continue;
            list.add(0, fkSecondPass);
        }
    }

    private String quotedTableName(Table table) {
        return Table.qualify(table.getCatalog(), table.getQuotedSchema(), table.getQuotedName());
    }

    private void processEndOfQueue(List<FkSecondPass> list) {
        boolean bl = false;
        RuntimeException runtimeException = null;
        while (!bl) {
            ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>();
            for (FkSecondPass fkSecondPass : list) {
                try {
                    fkSecondPass.doSecondPass(this.classes);
                }
                catch (RecoverableException recoverableException) {
                    arrayList.add(fkSecondPass);
                    if (runtimeException != null) continue;
                    runtimeException = (RuntimeException)recoverableException.getCause();
                }
            }
            bl = arrayList.size() == 0 || arrayList.size() == list.size();
            list = arrayList;
        }
        if (list.size() > 0) {
            throw runtimeException;
        }
    }

    private void buildUniqueKeyFromColumnNames(Table table, String string, String[] stringArray) {
        Object object;
        int n = stringArray.length;
        Column[] columnArray = new Column[n];
        HashSet<Column> hashSet = new HashSet<Column>();
        HashSet<Column> hashSet2 = new HashSet<Column>();
        for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            try {
                String string2 = this.createMappings().getPhysicalColumnName((String)object, table);
                columnArray[i] = new Column(string2);
                hashSet.add(columnArray[i]);
                continue;
            }
            catch (MappingException mappingException) {
                hashSet2.add(new Column((String)object));
            }
        }
        if (StringHelper.isEmpty(string)) {
            string = Constraint.generateName("UK_", table, columnArray);
        }
        string = this.normalizer.normalizeIdentifierQuoting(string);
        UniqueKey uniqueKey = table.getOrCreateUniqueKey(string);
        for (Column column : columnArray) {
            if (!table.containsColumn(column)) continue;
            uniqueKey.addColumn(column);
            hashSet.remove(column);
        }
        if (hashSet.size() > 0 || hashSet2.size() > 0) {
            object = new StringBuilder("Unable to create unique key constraint (");
            for (String string3 : stringArray) {
                ((StringBuilder)object).append(string3).append(", ");
            }
            ((StringBuilder)object).setLength(((StringBuilder)object).length() - 2);
            ((StringBuilder)object).append(") on table ").append(table.getName()).append(": database column ");
            for (Column column : hashSet) {
                ((StringBuilder)object).append("'").append(column.getName()).append("', ");
            }
            for (Column column : hashSet2) {
                ((StringBuilder)object).append("'").append(column.getName()).append("', ");
            }
            ((StringBuilder)object).setLength(((StringBuilder)object).length() - 2);
            ((StringBuilder)object).append(" not found. Make sure that you use the correct column name which depends on the naming strategy in use (it may not be the same as the property name in the entity, especially for relational types)");
            throw new AnnotationException(((StringBuilder)object).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void originalSecondPassCompile() throws MappingException {
        Serializable serializable;
        Serializable serializable2;
        LOG.debug("Processing extends queue");
        this.processExtendsQueue();
        LOG.debug("Processing collection mappings");
        Iterator<Serializable> iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass serializable32 = iterator.next();
            if (serializable32 instanceof QuerySecondPass) continue;
            serializable32.doSecondPass(this.classes);
            iterator.remove();
        }
        LOG.debug("Processing native query and ResultSetMapping mappings");
        iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            secondPass.doSecondPass(this.classes);
            iterator.remove();
        }
        LOG.debug("Processing association property references");
        for (Mappings.PropertyReference propertyReference : this.propertyReferences) {
            serializable2 = this.getClassMapping(propertyReference.referencedClass);
            if (serializable2 == null) {
                throw new MappingException("property-ref to unmapped class: " + propertyReference.referencedClass);
            }
            serializable = serializable2.getReferencedProperty(propertyReference.propertyName);
            if (!propertyReference.unique) continue;
            ((SimpleValue)((Property)serializable).getValue()).setAlternateUniqueKey(true);
        }
        LOG.debug("Creating tables' unique integer identifiers");
        LOG.debug("Processing foreign key constraints");
        iterator = this.getTableMappings();
        boolean bl = false;
        serializable2 = new HashSet();
        while (iterator.hasNext()) {
            void var2_8;
            serializable = (Table)iterator.next();
            ((Table)serializable).setUniqueInteger((int)(++var2_8));
            this.secondPassCompileForeignKeys((Table)serializable, (Set<ForeignKey>)((Object)serializable2));
        }
    }

    private int processExtendsQueue() {
        LOG.debug("Processing extends queue");
        int n = 0;
        ExtendsQueueEntry extendsQueueEntry = this.findPossibleExtends();
        while (extendsQueueEntry != null) {
            this.metadataSourceQueue.processHbmXml(extendsQueueEntry.getMetadataXml(), extendsQueueEntry.getEntityNames());
            extendsQueueEntry = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
            StringBuilder stringBuilder = new StringBuilder("Following super classes referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry extendsQueueEntry2 = iterator.next();
                stringBuilder.append(extendsQueueEntry2.getExplicitName());
                if (extendsQueueEntry2.getMappingPackage() != null) {
                    stringBuilder.append("[").append(extendsQueueEntry2.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            throw new MappingException(stringBuilder.toString());
        }
        return n;
    }

    protected ExtendsQueueEntry findPossibleExtends() {
        Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
        while (iterator.hasNext()) {
            ExtendsQueueEntry extendsQueueEntry = iterator.next();
            boolean bl = this.getClassMapping(extendsQueueEntry.getExplicitName()) != null || this.getClassMapping(HbmBinder.getClassName(extendsQueueEntry.getExplicitName(), extendsQueueEntry.getMappingPackage())) != null;
            if (!bl) continue;
            iterator.remove();
            return extendsQueueEntry;
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set<ForeignKey> set) throws MappingException {
        table.createForeignKeys();
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            if (set.contains(foreignKey)) continue;
            set.add(foreignKey);
            String string = foreignKey.getReferencedEntityName();
            if (string == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " does not specify the referenced entity");
            }
            LOG.debugf("Resolving reference to class: %s", (Object)string);
            PersistentClass persistentClass = this.classes.get(string);
            if (persistentClass == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " refers to an unmapped class: " + string);
            }
            if (persistentClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(persistentClass.getSuperclass().getTable(), set);
            }
            foreignKey.setReferencedTable(persistentClass.getTable());
            foreignKey.alignColumns();
        }
    }

    public Map<String, NamedQueryDefinition> getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory(ServiceRegistry serviceRegistry) throws HibernateException {
        LOG.debugf("Preparing to build session factory with filters : %s", (Object)this.filterDefinitions);
        this.buildTypeRegistrations(serviceRegistry);
        this.secondPassCompile();
        if (!this.metadataSourceQueue.isEmpty()) {
            LOG.incompleteMappingMetadataCacheProcessing();
        }
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        Settings settings = this.buildSettings(properties, serviceRegistry);
        return new SessionFactoryImpl(this, this.mapping, serviceRegistry, settings, this.sessionFactoryObserver);
    }

    private void buildTypeRegistrations(ServiceRegistry serviceRegistry) {
        TypeContributions typeContributions = new TypeContributions(){

            public void contributeType(BasicType basicType) {
                Configuration.this.typeResolver.registerTypeOverride(basicType);
            }

            public void contributeType(UserType userType, String[] stringArray) {
                Configuration.this.typeResolver.registerTypeOverride(userType, stringArray);
            }

            public void contributeType(CompositeUserType compositeUserType, String[] stringArray) {
                Configuration.this.typeResolver.registerTypeOverride(compositeUserType, stringArray);
            }
        };
        Dialect dialect = serviceRegistry.getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, serviceRegistry);
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        for (TypeContributor typeContributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            typeContributor.contribute(typeContributions, serviceRegistry);
        }
        for (TypeContributor typeContributor : this.typeContributorRegistrations) {
            typeContributor.contribute(typeContributions, serviceRegistry);
        }
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        Environment.verifyProperties(this.properties);
        ConfigurationHelper.resolvePlaceHolders(this.properties);
        final ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(this.properties).buildServiceRegistry();
        this.setSessionFactoryObserver(new SessionFactoryObserver(){

            public void sessionFactoryCreated(SessionFactory sessionFactory) {
            }

            public void sessionFactoryClosed(SessionFactory sessionFactory) {
                ((StandardServiceRegistryImpl)serviceRegistry).destroy();
            }
        });
        return this.buildSessionFactory(serviceRegistry);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        return this;
    }

    private void addProperties(Element element) {
        Iterator iterator = element.elementIterator("property");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.attributeValue("name");
            String string2 = element2.getText().trim();
            LOG.debugf("%s=%s", (Object)string, (Object)string2);
            this.properties.setProperty(string, string2);
            if (string.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + string, string2);
        }
        Environment.verifyProperties(this.properties);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String string) throws HibernateException {
        LOG.configuringFromResource(string);
        InputStream inputStream = this.getConfigurationInputStream(string);
        return this.doConfigure(inputStream, string);
    }

    protected InputStream getConfigurationInputStream(String string) throws HibernateException {
        LOG.configurationResource(string);
        return ConfigHelper.getResourceAsStream(string);
    }

    public Configuration configure(URL uRL) throws HibernateException {
        LOG.configuringFromUrl(uRL);
        try {
            return this.doConfigure(uRL.openStream(), uRL.toString());
        }
        catch (IOException iOException) {
            throw new HibernateException("could not configure from URL: " + uRL, iOException);
        }
    }

    public Configuration configure(File file) throws HibernateException {
        LOG.configuringFromFile(file.getName());
        try {
            return this.doConfigure(new FileInputStream(file), file.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HibernateException("could not find file: " + file, fileNotFoundException);
        }
    }

    protected Configuration doConfigure(InputStream inputStream, String string) throws HibernateException {
        try {
            ErrorLogger errorLogger = new ErrorLogger(string);
            Document document = this.xmlHelper.createSAXReader(errorLogger, this.entityResolver).read(new InputSource(inputStream));
            if (errorLogger.hasErrors()) {
                throw new MappingException("invalid configuration", errorLogger.getErrors().get(0));
            }
            this.doConfigure(document);
        }
        catch (DocumentException documentException) {
            throw new HibernateException("Could not parse configuration: " + string, documentException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.unableToCloseInputStreamForResource(string, iOException);
            }
        }
        return this;
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        LOG.configuringFromXmlDocument();
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(Document document) throws HibernateException {
        Element element = document.getRootElement().element("session-factory");
        String string = element.attributeValue("name");
        if (string != null) {
            this.properties.setProperty("hibernate.session_factory_name", string);
        }
        this.addProperties(element);
        this.parseSessionFactory(element, string);
        Element element2 = document.getRootElement().element("security");
        if (element2 != null) {
            this.parseSecurity(element2);
        }
        LOG.configuredSessionFactory(string);
        LOG.debugf("Properties: %s", (Object)this.properties);
        return this;
    }

    private void parseSessionFactory(Element element, String string) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            String string2;
            Attribute attribute;
            String string3;
            Element element2 = (Element)iterator.next();
            String string4 = element2.getName();
            if ("mapping".equals(string4)) {
                this.parseMappingElement(element2, string);
                continue;
            }
            if ("class-cache".equals(string4)) {
                string3 = element2.attributeValue("class");
                attribute = element2.attribute("region");
                string2 = attribute == null ? string3 : attribute.getValue();
                boolean bl = !"non-lazy".equals(element2.attributeValue("include"));
                this.setCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2, bl);
                continue;
            }
            if (!"collection-cache".equals(string4)) continue;
            string3 = element2.attributeValue("collection");
            attribute = element2.attribute("region");
            string2 = attribute == null ? string3 : attribute.getValue();
            this.setCollectionCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2);
        }
    }

    private void parseMappingElement(Element element, String string) {
        Attribute attribute = element.attribute("resource");
        Attribute attribute2 = element.attribute("file");
        Attribute attribute3 = element.attribute("jar");
        Attribute attribute4 = element.attribute("package");
        Attribute attribute5 = element.attribute("class");
        if (attribute != null) {
            String string2 = attribute.getValue();
            LOG.debugf("Session-factory config [%s] named resource [%s] for mapping", (Object)string, (Object)string2);
            this.addResource(string2);
        } else if (attribute2 != null) {
            String string3 = attribute2.getValue();
            LOG.debugf("Session-factory config [%s] named file [%s] for mapping", (Object)string, (Object)string3);
            this.addFile(string3);
        } else if (attribute3 != null) {
            String string4 = attribute3.getValue();
            LOG.debugf("Session-factory config [%s] named jar file [%s] for mapping", (Object)string, (Object)string4);
            this.addJar(new File(string4));
        } else if (attribute4 != null) {
            String string5 = attribute4.getValue();
            LOG.debugf("Session-factory config [%s] named package [%s] for mapping", (Object)string, (Object)string5);
            this.addPackage(string5);
        } else if (attribute5 != null) {
            String string6 = attribute5.getValue();
            LOG.debugf("Session-factory config [%s] named class [%s] for mapping", (Object)string, (Object)string6);
            try {
                this.addAnnotatedClass(ReflectHelper.classForName(string6));
            }
            catch (Exception exception) {
                throw new MappingException("Unable to load class [ " + string6 + "] declared in Hibernate configuration <mapping/> entry", exception);
            }
        } else {
            throw new MappingException("<mapping> element in configuration specifies no known attributes");
        }
    }

    private void parseSecurity(Element element) {
        String string = element.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", string);
        LOG.jaccContextId(string);
        JACCConfiguration jACCConfiguration = new JACCConfiguration(string);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string2 = element2.getName();
            if (!"grant".equals(string2)) continue;
            jACCConfiguration.addPermission(element2.attributeValue("role"), element2.attributeValue("entity-name"), element2.attributeValue("actions"));
        }
    }

    RootClass getRootClassMapping(String string) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(string);
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String string, String string2) {
        this.setCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public Configuration setCacheConcurrencyStrategy(String string, String string2, String string3) {
        this.setCacheConcurrencyStrategy(string, string2, string3, true);
        return this;
    }

    public void setCacheConcurrencyStrategy(String string, String string2, String string3, boolean bl) throws MappingException {
        this.caches.add(new CacheHolder(string, string2, string3, true, bl));
    }

    private void applyCacheConcurrencyStrategy(CacheHolder cacheHolder) {
        RootClass rootClass = this.getRootClassMapping(cacheHolder.role);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + cacheHolder.role);
        }
        rootClass.setCacheConcurrencyStrategy(cacheHolder.usage);
        rootClass.setCacheRegionName(cacheHolder.region);
        rootClass.setLazyPropertiesCacheable(cacheHolder.cacheLazy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String string, String string2) {
        this.setCollectionCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String string, String string2, String string3) {
        this.caches.add(new CacheHolder(string, string2, string3, false, false));
    }

    private void applyCollectionCacheConcurrencyStrategy(CacheHolder cacheHolder) {
        Collection collection = this.getCollectionMapping(cacheHolder.role);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + cacheHolder.role);
        }
        collection.setCacheConcurrencyStrategy(cacheHolder.usage);
        collection.setCacheRegionName(cacheHolder.region);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public Settings buildSettings(ServiceRegistry serviceRegistry) {
        Properties properties = (Properties)this.properties.clone();
        ConfigurationHelper.resolvePlaceHolders(properties);
        return this.buildSettingsInternal(properties, serviceRegistry);
    }

    public Settings buildSettings(Properties properties, ServiceRegistry serviceRegistry) throws HibernateException {
        return this.buildSettingsInternal(properties, serviceRegistry);
    }

    private Settings buildSettingsInternal(Properties properties, ServiceRegistry serviceRegistry) {
        Settings settings = this.settingsFactory.buildSettings(properties, serviceRegistry);
        settings.setEntityTuplizerFactory(this.getEntityTuplizerFactory());
        return settings;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return Configuration.this.identifierGeneratorFactory;
            }

            public Type getIdentifierType(String string) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                return persistentClass.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String string) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                if (!persistentClass.hasIdentifierProperty()) {
                    return null;
                }
                return persistentClass.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String string, String string2) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                Property property = persistentClass.getReferencedProperty(string2);
                if (property == null) {
                    throw new MappingException("property not known: " + string + '.' + string2);
                }
                return property.getType();
            }
        };
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MetadataProvider metadataProvider = (MetadataProvider)objectInputStream.readObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
        this.createReflectionManager(metadataProvider);
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
        objectOutputStream.writeObject(metadataProvider);
        objectOutputStream.defaultWriteObject();
    }

    private void createReflectionManager() {
        this.createReflectionManager(new JPAMetadataProvider());
    }

    private void createReflectionManager(MetadataProvider metadataProvider) {
        this.reflectionManager = new JavaReflectionManager();
        ((MetadataProviderInjector)((Object)this.reflectionManager)).setMetadataProvider(metadataProvider);
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
    }

    public Iterator iterateFetchProfiles() {
        return this.fetchProfiles.values().iterator();
    }

    public void addFetchProfile(FetchProfile fetchProfile) {
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String string, SQLFunction sQLFunction) {
        this.sqlFunctions.put(string.toLowerCase(), sQLFunction);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void registerTypeOverride(BasicType basicType) {
        this.getTypeResolver().registerTypeOverride(basicType);
    }

    public void registerTypeOverride(UserType userType, String[] stringArray) {
        this.getTypeResolver().registerTypeOverride(userType, stringArray);
    }

    public void registerTypeOverride(CompositeUserType compositeUserType, String[] stringArray) {
        this.getTypeResolver().registerTypeOverride(compositeUserType, stringArray);
    }

    public void registerTypeContributor(TypeContributor typeContributor) {
        this.typeContributorRegistrations.add(typeContributor);
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    public void setCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
    }

    private List<MetadataSourceType> determineMetadataSourcePrecedence() {
        if (this.metadataSourcePrecedence.isEmpty() && StringHelper.isNotEmpty(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER))) {
            this.metadataSourcePrecedence = this.parsePrecedence(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER));
        }
        if (this.metadataSourcePrecedence.isEmpty()) {
            this.metadataSourcePrecedence = Arrays.asList(DEFAULT_ARTEFACT_PROCESSING_ORDER);
        }
        this.metadataSourcePrecedence = Collections.unmodifiableList(this.metadataSourcePrecedence);
        return this.metadataSourcePrecedence;
    }

    public void setPrecedence(String string) {
        this.metadataSourcePrecedence = this.parsePrecedence(string);
    }

    private List<MetadataSourceType> parsePrecedence(String string) {
        if (StringHelper.isEmpty(string)) {
            return Collections.emptyList();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",; ", false);
        ArrayList<MetadataSourceType> arrayList = new ArrayList<MetadataSourceType>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(MetadataSourceType.parsePrecedence((String)stringTokenizer.nextElement()));
        }
        return arrayList;
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String string, String string2, String string3, boolean bl, boolean bl2) {
            this.role = string;
            this.usage = string2;
            this.region = string3;
            this.isClass = bl;
            this.cacheLazy = bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetadataSourceQueue
    implements Serializable {
        private LinkedHashMap<XmlDocument, Set<String>> hbmMetadataToEntityNamesMap = new LinkedHashMap();
        private Map<String, XmlDocument> hbmMetadataByEntityNameXRef = new HashMap<String, XmlDocument>();
        private transient List<XClass> annotatedClasses = new ArrayList<XClass>();
        private transient Map<String, XClass> annotatedClassesByEntityNameMap = new HashMap<String, XClass>();

        protected MetadataSourceQueue() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.annotatedClassesByEntityNameMap = new HashMap<String, XClass>();
            List list = (List)objectInputStream.readObject();
            this.annotatedClasses = new ArrayList<XClass>(list.size());
            for (Class clazz : list) {
                this.annotatedClasses.add(Configuration.this.reflectionManager.toXClass(clazz));
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            ArrayList<Class> arrayList = new ArrayList<Class>(this.annotatedClasses.size());
            for (XClass xClass : this.annotatedClasses) {
                arrayList.add(Configuration.this.reflectionManager.toClass(xClass));
            }
            objectOutputStream.writeObject(arrayList);
        }

        public void add(XmlDocument xmlDocument) {
            Document document = xmlDocument.getDocumentTree();
            Element element = document.getRootElement();
            Attribute attribute = element.attribute("package");
            String string = attribute != null ? attribute.getValue() : "";
            HashSet<String> hashSet = new HashSet<String>();
            this.findClassNames(string, element, hashSet);
            for (String string2 : hashSet) {
                this.hbmMetadataByEntityNameXRef.put(string2, xmlDocument);
            }
            this.hbmMetadataToEntityNamesMap.put(xmlDocument, hashSet);
        }

        private void findClassNames(String string, Element element, Set<String> set) {
            Iterator[] iteratorArray = new Iterator[]{element.elementIterator("class"), element.elementIterator("subclass"), element.elementIterator("joined-subclass"), element.elementIterator("union-subclass")};
            JoinedIterator joinedIterator = new JoinedIterator(iteratorArray);
            while (joinedIterator.hasNext()) {
                Element element2 = (Element)joinedIterator.next();
                String string2 = element2.attributeValue("entity-name");
                if (string2 == null) {
                    string2 = this.getClassName(element2.attribute("name"), string);
                }
                set.add(string2);
                this.findClassNames(string, element2, set);
            }
        }

        private String getClassName(Attribute attribute, String string) {
            if (attribute == null) {
                return null;
            }
            String string2 = attribute.getValue();
            if (string2 == null) {
                return null;
            }
            if (string2.indexOf(46) < 0 && string != null) {
                return string + '.' + string2;
            }
            return string2;
        }

        public void add(XClass xClass) {
            this.annotatedClasses.add(xClass);
        }

        protected void syncAnnotatedClasses() {
            Iterator<XClass> iterator = this.annotatedClasses.iterator();
            while (iterator.hasNext()) {
                XClass xClass = iterator.next();
                if (xClass.isAnnotationPresent(Entity.class)) {
                    this.annotatedClassesByEntityNameMap.put(xClass.getName(), xClass);
                    continue;
                }
                if (xClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                iterator.remove();
            }
        }

        protected void processMetadata(List<MetadataSourceType> list) {
            this.syncAnnotatedClasses();
            for (MetadataSourceType metadataSourceType : list) {
                if (MetadataSourceType.HBM.equals((Object)metadataSourceType)) {
                    this.processHbmXmlQueue();
                    continue;
                }
                if (!MetadataSourceType.CLASS.equals((Object)metadataSourceType)) continue;
                this.processAnnotatedClassesQueue();
            }
        }

        private void processHbmXmlQueue() {
            LOG.debug("Processing hbm.xml files");
            for (Map.Entry<XmlDocument, Set<String>> entry : this.hbmMetadataToEntityNamesMap.entrySet()) {
                this.processHbmXml(entry.getKey(), entry.getValue());
            }
            this.hbmMetadataToEntityNamesMap.clear();
            this.hbmMetadataByEntityNameXRef.clear();
        }

        private void processHbmXml(XmlDocument xmlDocument, Set<String> set) {
            try {
                HbmBinder.bindRoot(xmlDocument, Configuration.this.createMappings(), Collections.EMPTY_MAP, set);
            }
            catch (MappingException mappingException) {
                throw new InvalidMappingException(xmlDocument.getOrigin().getType(), xmlDocument.getOrigin().getName(), (Throwable)mappingException);
            }
            for (String string : set) {
                if (!this.annotatedClassesByEntityNameMap.containsKey(string)) continue;
                this.annotatedClasses.remove(this.annotatedClassesByEntityNameMap.get(string));
                this.annotatedClassesByEntityNameMap.remove(string);
            }
        }

        private void processAnnotatedClassesQueue() {
            LOG.debug("Process annotated classes");
            List<XClass> list = this.orderAndFillHierarchy(this.annotatedClasses);
            Mappings mappings = Configuration.this.createMappings();
            Map<XClass, InheritanceState> map = AnnotationBinder.buildInheritanceStates(list, mappings);
            for (XClass xClass : list) {
                AnnotationBinder.bindClass(xClass, map, mappings);
                String string = xClass.getName();
                if (!this.hbmMetadataByEntityNameXRef.containsKey(string)) continue;
                this.hbmMetadataToEntityNamesMap.remove(this.hbmMetadataByEntityNameXRef.get(string));
                this.hbmMetadataByEntityNameXRef.remove(string);
            }
            this.annotatedClasses.clear();
            this.annotatedClassesByEntityNameMap.clear();
        }

        private List<XClass> orderAndFillHierarchy(List<XClass> list) {
            ArrayList<XClass> arrayList = new ArrayList<XClass>(list);
            this.insertMappedSuperclasses(list, arrayList);
            ArrayList<XClass> arrayList2 = new ArrayList<XClass>(arrayList);
            ArrayList<XClass> arrayList3 = new ArrayList<XClass>(arrayList.size());
            while (arrayList2.size() > 0) {
                XClass xClass = (XClass)arrayList2.get(0);
                this.orderHierarchy(arrayList2, arrayList3, arrayList, xClass);
            }
            return arrayList3;
        }

        private void insertMappedSuperclasses(List<XClass> list, List<XClass> list2) {
            for (XClass xClass : list) {
                for (XClass xClass2 = xClass.getSuperclass(); xClass2 != null && !Configuration.this.reflectionManager.equals(xClass2, Object.class) && !list2.contains(xClass2); xClass2 = xClass2.getSuperclass()) {
                    if (!xClass2.isAnnotationPresent(Entity.class) && !xClass2.isAnnotationPresent(MappedSuperclass.class)) continue;
                    list2.add(xClass2);
                }
            }
        }

        private void orderHierarchy(List<XClass> list, List<XClass> list2, List<XClass> list3, XClass xClass) {
            if (xClass == null || Configuration.this.reflectionManager.equals(xClass, Object.class)) {
                return;
            }
            this.orderHierarchy(list, list2, list3, xClass.getSuperclass());
            if (list3.contains(xClass)) {
                if (!list2.contains(xClass)) {
                    list2.add(xClass);
                }
                list.remove(xClass);
            }
        }

        public boolean isEmpty() {
            return this.hbmMetadataToEntityNamesMap.isEmpty() && this.annotatedClasses.isEmpty();
        }
    }

    final class ObjectNameNormalizerImpl
    extends ObjectNameNormalizer
    implements Serializable {
        ObjectNameNormalizerImpl() {
        }

        public boolean isUseQuotedIdentifiersGlobally() {
            String string = (String)Configuration.this.properties.get("hibernate.globally_quoted_identifiers");
            return string != null && Boolean.valueOf(string) != false;
        }

        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingsImpl
    implements ExtendedMappings,
    Serializable {
        private String schemaName;
        private String catalogName;
        private String defaultPackage;
        private boolean autoImport;
        private boolean defaultLazy;
        private String defaultCascade;
        private String defaultAccess;
        private Boolean useNewGeneratorMappings;
        private Boolean useNationalizedCharacterData;
        private Boolean forceDiscriminatorInSelectsByDefault;

        protected MappingsImpl() {
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        @Override
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public void setCatalogName(String string) {
            this.catalogName = string;
        }

        @Override
        public String getDefaultPackage() {
            return this.defaultPackage;
        }

        @Override
        public void setDefaultPackage(String string) {
            this.defaultPackage = string;
        }

        @Override
        public boolean isAutoImport() {
            return this.autoImport;
        }

        @Override
        public void setAutoImport(boolean bl) {
            this.autoImport = bl;
        }

        @Override
        public boolean isDefaultLazy() {
            return this.defaultLazy;
        }

        @Override
        public void setDefaultLazy(boolean bl) {
            this.defaultLazy = bl;
        }

        @Override
        public String getDefaultCascade() {
            return this.defaultCascade;
        }

        @Override
        public void setDefaultCascade(String string) {
            this.defaultCascade = string;
        }

        @Override
        public String getDefaultAccess() {
            return this.defaultAccess;
        }

        @Override
        public void setDefaultAccess(String string) {
            this.defaultAccess = string;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }

        @Override
        public void setNamingStrategy(NamingStrategy namingStrategy) {
            Configuration.this.namingStrategy = namingStrategy;
        }

        @Override
        public TypeResolver getTypeResolver() {
            return Configuration.this.typeResolver;
        }

        @Override
        public Iterator<PersistentClass> iterateClasses() {
            return Configuration.this.classes.values().iterator();
        }

        @Override
        public PersistentClass getClass(String string) {
            return Configuration.this.classes.get(string);
        }

        @Override
        public PersistentClass locatePersistentClassByEntityName(String string) {
            String string2;
            PersistentClass persistentClass = Configuration.this.classes.get(string);
            if (persistentClass == null && StringHelper.isNotEmpty(string2 = Configuration.this.imports.get(string))) {
                persistentClass = Configuration.this.classes.get(string2);
            }
            return persistentClass;
        }

        @Override
        public void addClass(PersistentClass persistentClass) throws DuplicateMappingException {
            PersistentClass persistentClass2 = Configuration.this.classes.put(persistentClass.getEntityName(), persistentClass);
            if (persistentClass2 != null) {
                throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
            }
        }

        @Override
        public void addImport(String string, String string2) throws DuplicateMappingException {
            String string3 = Configuration.this.imports.put(string2, string);
            if (string3 != null) {
                if (string3.equals(string)) {
                    LOG.duplicateImport(string, string2);
                } else {
                    throw new DuplicateMappingException("duplicate import: " + string2 + " refers to both " + string + " and " + string3 + " (try using auto-import=\"false\")", "import", string2);
                }
            }
        }

        @Override
        public Collection getCollection(String string) {
            return Configuration.this.collections.get(string);
        }

        @Override
        public Iterator<Collection> iterateCollections() {
            return Configuration.this.collections.values().iterator();
        }

        @Override
        public void addCollection(Collection collection) throws DuplicateMappingException {
            Collection collection2 = Configuration.this.collections.put(collection.getRole(), collection);
            if (collection2 != null) {
                throw new DuplicateMappingException("collection role", collection.getRole());
            }
        }

        @Override
        public Table getTable(String string, String string2, String string3) {
            String string4 = Table.qualify(string2, string, string3);
            return Configuration.this.tables.get(string4);
        }

        @Override
        public Iterator<Table> iterateTables() {
            return Configuration.this.tables.values().iterator();
        }

        @Override
        public Table addTable(String string, String string2, String string3, String string4, boolean bl) {
            string3 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string3);
            string = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
            string2 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string2);
            String string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
            Table table = Configuration.this.tables.get(string5);
            if (table == null) {
                table = new Table();
                table.setAbstract(bl);
                table.setName(string3);
                table.setSchema(string);
                table.setCatalog(string2);
                table.setSubselect(string4);
                Configuration.this.tables.put(string5, table);
            } else if (!bl) {
                table.setAbstract(false);
            }
            return table;
        }

        @Override
        public Table addDenormalizedTable(String string, String string2, String string3, boolean bl, String string4, Table table) throws DuplicateMappingException {
            String string5;
            string3 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string3);
            string = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
            string2 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string2);
            String string6 = string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
            if (Configuration.this.tables.containsKey(string5)) {
                throw new DuplicateMappingException("table", string3);
            }
            DenormalizedTable denormalizedTable = new DenormalizedTable(table);
            denormalizedTable.setAbstract(bl);
            denormalizedTable.setName(string3);
            denormalizedTable.setSchema(string);
            denormalizedTable.setCatalog(string2);
            denormalizedTable.setSubselect(string4);
            Configuration.this.tables.put(string5, denormalizedTable);
            return denormalizedTable;
        }

        @Override
        public NamedQueryDefinition getQuery(String string) {
            return Configuration.this.namedQueries.get(string);
        }

        @Override
        public void addQuery(String string, NamedQueryDefinition namedQueryDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedQueryNames.contains(string)) {
                this.applyQuery(string, namedQueryDefinition);
            }
        }

        private void applyQuery(String string, NamedQueryDefinition namedQueryDefinition) {
            this.checkQueryName(string);
            Configuration.this.namedQueries.put(string.intern(), namedQueryDefinition);
        }

        private void checkQueryName(String string) throws DuplicateMappingException {
            if (Configuration.this.namedQueries.containsKey(string) || Configuration.this.namedSqlQueries.containsKey(string)) {
                throw new DuplicateMappingException("query", string);
            }
        }

        @Override
        public void addDefaultQuery(String string, NamedQueryDefinition namedQueryDefinition) {
            this.applyQuery(string, namedQueryDefinition);
            Configuration.this.defaultNamedQueryNames.add(string);
        }

        @Override
        public NamedSQLQueryDefinition getSQLQuery(String string) {
            return Configuration.this.namedSqlQueries.get(string);
        }

        @Override
        public void addSQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedNativeQueryNames.contains(string)) {
                this.applySQLQuery(string, namedSQLQueryDefinition);
            }
        }

        private void applySQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) throws DuplicateMappingException {
            this.checkQueryName(string);
            Configuration.this.namedSqlQueries.put(string.intern(), namedSQLQueryDefinition);
        }

        @Override
        public void addDefaultSQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) {
            this.applySQLQuery(string, namedSQLQueryDefinition);
            Configuration.this.defaultNamedNativeQueryNames.add(string);
        }

        @Override
        public ResultSetMappingDefinition getResultSetMapping(String string) {
            return Configuration.this.sqlResultSetMappings.get(string);
        }

        @Override
        public void addResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(resultSetMappingDefinition.getName())) {
                this.applyResultSetMapping(resultSetMappingDefinition);
            }
        }

        public void applyResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) throws DuplicateMappingException {
            ResultSetMappingDefinition resultSetMappingDefinition2 = Configuration.this.sqlResultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
            if (resultSetMappingDefinition2 != null) {
                throw new DuplicateMappingException("resultSet", resultSetMappingDefinition.getName());
            }
        }

        @Override
        public void addDefaultResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) {
            String string = resultSetMappingDefinition.getName();
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(string) && this.getResultSetMapping(string) != null) {
                this.removeResultSetMapping(string);
            }
            this.applyResultSetMapping(resultSetMappingDefinition);
            Configuration.this.defaultSqlResultSetMappingNames.add(string);
        }

        protected void removeResultSetMapping(String string) {
            Configuration.this.sqlResultSetMappings.remove(string);
        }

        @Override
        public TypeDef getTypeDef(String string) {
            return Configuration.this.typeDefs.get(string);
        }

        @Override
        public void addTypeDef(String string, String string2, Properties properties) {
            TypeDef typeDef = new TypeDef(string2, properties);
            Configuration.this.typeDefs.put(string, typeDef);
            LOG.debugf("Added %s with class %s", (Object)string, (Object)string2);
        }

        @Override
        public Map getFilterDefinitions() {
            return Configuration.this.filterDefinitions;
        }

        @Override
        public FilterDefinition getFilterDefinition(String string) {
            return Configuration.this.filterDefinitions.get(string);
        }

        @Override
        public void addFilterDefinition(FilterDefinition filterDefinition) {
            Configuration.this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
        }

        @Override
        public FetchProfile findOrCreateFetchProfile(String string, MetadataSource metadataSource) {
            FetchProfile fetchProfile = Configuration.this.fetchProfiles.get(string);
            if (fetchProfile == null) {
                fetchProfile = new FetchProfile(string, metadataSource);
                Configuration.this.fetchProfiles.put(string, fetchProfile);
            }
            return fetchProfile;
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjects() {
            return this.iterateAuxiliaryDatabaseObjects();
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjects() {
            return Configuration.this.auxiliaryDatabaseObjects.iterator();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjectsInReverse() {
            return this.iterateAuxiliaryDatabaseObjectsInReverse();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjectsInReverse() {
            return Configuration.this.auxiliaryDatabaseObjects.listIterator(Configuration.this.auxiliaryDatabaseObjects.size());
        }

        @Override
        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            Configuration.this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
        }

        @Override
        public String getLogicalTableName(Table table) throws MappingException {
            return this.getLogicalTableName(table.getQuotedSchema(), table.getQuotedCatalog(), table.getQuotedName());
        }

        private String getLogicalTableName(String string, String string2, String string3) throws MappingException {
            String string4 = this.buildTableNameKey(string, string2, string3);
            TableDescription tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string4);
            if (tableDescription == null) {
                throw new MappingException("Unable to find physical table: " + string3);
            }
            return tableDescription.logicalName;
        }

        @Override
        public void addTableBinding(String string, String string2, String string3, String string4, Table table) throws DuplicateMappingException {
            TableDescription tableDescription;
            String string5 = this.buildTableNameKey(string, string2, string4);
            TableDescription tableDescription2 = Configuration.this.tableNameBinding.put(string5, tableDescription = new TableDescription(string3, table));
            if (tableDescription2 != null && !tableDescription2.logicalName.equals(string3)) {
                throw new DuplicateMappingException("Same physical table name [" + string4 + "] references several logical table names: [" + tableDescription2.logicalName + "], [" + string3 + ']', "table", string4);
            }
        }

        private String buildTableNameKey(String string, String string2, String string3) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(".");
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(".");
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }

        @Override
        public void addColumnBinding(String string, Column column, Table table) throws DuplicateMappingException {
            TableColumnNameBinding tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table);
            if (tableColumnNameBinding == null) {
                tableColumnNameBinding = new TableColumnNameBinding(table.getName());
                Configuration.this.columnNameBindingPerTable.put(table, tableColumnNameBinding);
            }
            tableColumnNameBinding.addBinding(string, column);
        }

        @Override
        public String getPhysicalColumnName(String string, Table table) throws MappingException {
            string = string.toLowerCase();
            String string2 = null;
            Table table2 = table;
            do {
                String string3;
                TableDescription tableDescription;
                TableColumnNameBinding tableColumnNameBinding;
                if ((tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table2)) != null) {
                    string2 = (String)tableColumnNameBinding.logicalToPhysical.get(string);
                }
                table2 = (tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getQuotedSchema(), table2.getQuotedCatalog(), table2.getQuotedName()))) != null ? tableDescription.denormalizedSupertable : null;
            } while (string2 == null && table2 != null);
            if (string2 == null) {
                throw new MappingException("Unable to find column with logical name " + string + " in table " + table.getName());
            }
            return string2;
        }

        @Override
        public String getLogicalColumnName(String string, Table table) throws MappingException {
            String string2 = null;
            Table table2 = table;
            TableDescription tableDescription = null;
            do {
                String string3;
                TableColumnNameBinding tableColumnNameBinding;
                if ((tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table2)) != null) {
                    string2 = (String)tableColumnNameBinding.physicalToLogical.get(string);
                }
                table2 = (tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getQuotedSchema(), table2.getQuotedCatalog(), table2.getQuotedName()))) != null ? tableDescription.denormalizedSupertable : null;
            } while (string2 == null && table2 != null && tableDescription != null);
            if (string2 == null) {
                throw new MappingException("Unable to find logical column name from physical name " + string + " in table " + table.getName());
            }
            return string2;
        }

        @Override
        public void addSecondPass(SecondPass secondPass) {
            this.addSecondPass(secondPass, false);
        }

        @Override
        public void addSecondPass(SecondPass secondPass, boolean bl) {
            if (bl) {
                Configuration.this.secondPasses.add(0, secondPass);
            } else {
                Configuration.this.secondPasses.add(secondPass);
            }
        }

        @Override
        public void addPropertyReference(String string, String string2) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(string, string2, false));
        }

        @Override
        public void addUniquePropertyReference(String string, String string2) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(string, string2, true));
        }

        @Override
        public void addToExtendsQueue(ExtendsQueueEntry extendsQueueEntry) {
            Configuration.this.extendsQueue.put(extendsQueueEntry, null);
        }

        @Override
        public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return Configuration.this.identifierGeneratorFactory;
        }

        @Override
        public void addMappedSuperclass(Class clazz, org.hibernate.mapping.MappedSuperclass mappedSuperclass) {
            Configuration.this.mappedSuperClasses.put(clazz, mappedSuperclass);
        }

        @Override
        public org.hibernate.mapping.MappedSuperclass getMappedSuperclass(Class clazz) {
            return (org.hibernate.mapping.MappedSuperclass)Configuration.this.mappedSuperClasses.get(clazz);
        }

        @Override
        public ObjectNameNormalizer getObjectNameNormalizer() {
            return Configuration.this.normalizer;
        }

        @Override
        public Properties getConfigurationProperties() {
            return Configuration.this.properties;
        }

        @Override
        public void addDefaultGenerator(IdGenerator idGenerator) {
            this.addGenerator(idGenerator);
            Configuration.this.defaultNamedGenerators.add(idGenerator.getName());
        }

        @Override
        public boolean isInSecondPass() {
            return Configuration.this.inSecondPass;
        }

        @Override
        public PropertyData getPropertyAnnotatedWithMapsId(XClass xClass, String string) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            return map == null ? null : (PropertyData)map.get(string);
        }

        @Override
        public void addPropertyAnnotatedWithMapsId(XClass xClass, PropertyData propertyData) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(xClass, hashMap);
            }
            hashMap.put(propertyData.getProperty().getAnnotation(MapsId.class).value(), propertyData);
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return Configuration.this.specjProprietarySyntaxEnabled;
        }

        @Override
        public void addPropertyAnnotatedWithMapsIdSpecj(XClass xClass, PropertyData propertyData, String string) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(xClass, hashMap);
            }
            hashMap.put(string, propertyData);
        }

        @Override
        public PropertyData getPropertyAnnotatedWithIdAndToOne(XClass xClass, String string) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(xClass);
            return map == null ? null : (PropertyData)map.get(string);
        }

        @Override
        public void addToOneAndIdProperty(XClass xClass, PropertyData propertyData) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithIdAndToOne.put(xClass, hashMap);
            }
            hashMap.put(propertyData.getPropertyName(), propertyData);
        }

        @Override
        public boolean useNewGeneratorMappings() {
            if (this.useNewGeneratorMappings == null) {
                String string = this.getConfigurationProperties().getProperty(Configuration.USE_NEW_ID_GENERATOR_MAPPINGS);
                this.useNewGeneratorMappings = Boolean.valueOf(string);
            }
            return this.useNewGeneratorMappings;
        }

        @Override
        public boolean useNationalizedCharacterData() {
            if (this.useNationalizedCharacterData == null) {
                String string = this.getConfigurationProperties().getProperty("hibernate.use_nationalized_character_data");
                this.useNationalizedCharacterData = Boolean.valueOf(string);
            }
            return this.useNationalizedCharacterData;
        }

        @Override
        public boolean forceDiscriminatorInSelectsByDefault() {
            if (this.forceDiscriminatorInSelectsByDefault == null) {
                String string = this.getConfigurationProperties().getProperty("hibernate.discriminator.force_in_select");
                this.forceDiscriminatorInSelectsByDefault = Boolean.valueOf(string);
            }
            return this.forceDiscriminatorInSelectsByDefault;
        }

        @Override
        public IdGenerator getGenerator(String string) {
            return this.getGenerator(string, null);
        }

        @Override
        public IdGenerator getGenerator(String string, Map<String, IdGenerator> map) {
            IdGenerator idGenerator;
            if (map != null && (idGenerator = map.get(string)) != null) {
                return idGenerator;
            }
            return (IdGenerator)Configuration.this.namedGenerators.get(string);
        }

        @Override
        public void addGenerator(IdGenerator idGenerator) {
            IdGenerator idGenerator2;
            if (!Configuration.this.defaultNamedGenerators.contains(idGenerator.getName()) && (idGenerator2 = Configuration.this.namedGenerators.put(idGenerator.getName(), idGenerator)) != null) {
                LOG.duplicateGeneratorName(idGenerator2.getName());
            }
        }

        @Override
        public void addGeneratorTable(String string, Properties properties) {
            Properties properties2 = Configuration.this.generatorTables.put(string, properties);
            if (properties2 != null) {
                LOG.duplicateGeneratorTable(string);
            }
        }

        @Override
        public Properties getGeneratorTableProperties(String string, Map<String, Properties> map) {
            Properties properties;
            if (map != null && (properties = map.get(string)) != null) {
                return properties;
            }
            return (Properties)Configuration.this.generatorTables.get(string);
        }

        @Override
        public Map<String, Join> getJoins(String string) {
            return (Map)Configuration.this.joins.get(string);
        }

        @Override
        public void addJoins(PersistentClass persistentClass, Map<String, Join> map) {
            Map<String, Join> map2 = Configuration.this.joins.put(persistentClass.getEntityName(), map);
            if (map2 != null) {
                LOG.duplicateJoins(persistentClass.getEntityName());
            }
        }

        @Override
        public AnnotatedClassType getClassType(XClass xClass) {
            AnnotatedClassType annotatedClassType = (AnnotatedClassType)((Object)Configuration.this.classTypes.get(xClass.getName()));
            if (annotatedClassType == null) {
                return this.addClassType(xClass);
            }
            return annotatedClassType;
        }

        @Override
        public AnnotatedClassType addClassType(XClass xClass) {
            AnnotatedClassType annotatedClassType = xClass.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (xClass.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (xClass.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
            Configuration.this.classTypes.put(xClass.getName(), annotatedClassType);
            return annotatedClassType;
        }

        @Override
        public Map<Table, List<String[]>> getTableUniqueConstraints() {
            HashMap<Table, List<String[]>> hashMap = new HashMap<Table, List<String[]>>(CollectionHelper.determineProperSizing(this.getUniqueConstraintHoldersByTable()), 0.75f);
            for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.getUniqueConstraintHoldersByTable().entrySet()) {
                ArrayList<String[]> arrayList = new ArrayList<String[]>(CollectionHelper.determineProperSizing(entry.getValue().size()));
                hashMap.put(entry.getKey(), arrayList);
                for (UniqueConstraintHolder uniqueConstraintHolder : entry.getValue()) {
                    arrayList.add(uniqueConstraintHolder.getColumns());
                }
            }
            return hashMap;
        }

        @Override
        public Map<Table, List<UniqueConstraintHolder>> getUniqueConstraintHoldersByTable() {
            return Configuration.this.uniqueConstraintHoldersByTable;
        }

        @Override
        public void addUniqueConstraints(Table table, List list) {
            ArrayList<UniqueConstraintHolder> arrayList = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing(list.size()));
            int n = this.determineCurrentNumberOfUniqueConstraintHolders(table);
            for (String[] stringArray : list) {
                String string = "key" + n++;
                arrayList.add(new UniqueConstraintHolder().setName(string).setColumns(stringArray));
            }
            this.addUniqueConstraintHolders(table, arrayList);
        }

        private int determineCurrentNumberOfUniqueConstraintHolders(Table table) {
            List<UniqueConstraintHolder> list = this.getUniqueConstraintHoldersByTable().get(table);
            return list == null ? 0 : list.size();
        }

        @Override
        public void addUniqueConstraintHolders(Table table, List<UniqueConstraintHolder> list) {
            List<UniqueConstraintHolder> list2 = this.getUniqueConstraintHoldersByTable().get(table);
            if (list2 == null) {
                list2 = new ArrayList<UniqueConstraintHolder>();
                this.getUniqueConstraintHoldersByTable().put(table, list2);
            }
            list2.addAll(list);
        }

        @Override
        public void addMappedBy(String string, String string2, String string3) {
            Configuration.this.mappedByResolver.put(string + "." + string2, string3);
        }

        @Override
        public String getFromMappedBy(String string, String string2) {
            return (String)Configuration.this.mappedByResolver.get(string + "." + string2);
        }

        @Override
        public void addPropertyReferencedAssociation(String string, String string2, String string3) {
            Configuration.this.propertyRefResolver.put(string + "." + string2, string3);
        }

        @Override
        public String getPropertyReferencedAssociation(String string, String string2) {
            return (String)Configuration.this.propertyRefResolver.get(string + "." + string2);
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return Configuration.this.reflectionManager;
        }

        @Override
        public Map getClasses() {
            return Configuration.this.classes;
        }

        @Override
        public void addAnyMetaDef(AnyMetaDef anyMetaDef) throws AnnotationException {
            if (Configuration.this.anyMetaDefs.containsKey(anyMetaDef.name())) {
                throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + anyMetaDef.name());
            }
            Configuration.this.anyMetaDefs.put(anyMetaDef.name(), anyMetaDef);
        }

        @Override
        public AnyMetaDef getAnyMetaDef(String string) {
            return (AnyMetaDef)Configuration.this.anyMetaDefs.get(string);
        }

        private class TableColumnNameBinding
        implements Serializable {
            private final String tableName;
            private Map logicalToPhysical = new HashMap();
            private Map physicalToLogical = new HashMap();

            private TableColumnNameBinding(String string) {
                this.tableName = string;
            }

            public void addBinding(String string, Column column) {
                this.bindLogicalToPhysical(string, column);
                this.bindPhysicalToLogical(string, column);
            }

            private void bindLogicalToPhysical(String string, Column column) throws DuplicateMappingException {
                String string2;
                String string3 = string.toLowerCase();
                String string4 = this.logicalToPhysical.put(string3, string2 = column.getQuotedName());
                if (string4 != null) {
                    boolean bl;
                    boolean bl2 = bl = column.isQuoted() ? string4.equals(string2) : string4.equalsIgnoreCase(string2);
                    if (!bl) {
                        throw new DuplicateMappingException(" Table [" + this.tableName + "] contains logical column name [" + string + "] referenced by multiple physical column names: [" + string4 + "], [" + string2 + "]", "column-binding", this.tableName + "." + string);
                    }
                }
            }

            private void bindPhysicalToLogical(String string, Column column) throws DuplicateMappingException {
                String string2 = column.getQuotedName();
                String string3 = this.physicalToLogical.put(string2, string);
                if (string3 != null && !string3.equals(string)) {
                    throw new DuplicateMappingException(" Table [" + this.tableName + "] contains phyical column name [" + string2 + "] represented by different logical column names: [" + string3 + "], [" + string + "]", "column-binding", this.tableName + "." + string2);
                }
            }
        }

        private class TableDescription
        implements Serializable {
            final String logicalName;
            final Table denormalizedSupertable;

            TableDescription(String string, Table table) {
                this.logicalName = string;
                this.denormalizedSupertable = table;
            }
        }
    }
}

