/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AbstractPropertyHolder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

public class ComponentPropertyHolder
extends AbstractPropertyHolder {
    private Component component;
    private boolean isOrWithinEmbeddedId;

    public String getEntityName() {
        return this.component.getComponentClassName();
    }

    public void addProperty(Property property, Ejb3Column[] ejb3ColumnArray, XClass xClass) {
        Table table;
        if (ejb3ColumnArray != null && !(table = ejb3ColumnArray[0].getTable()).equals(this.component.getTable())) {
            if (this.component.getPropertySpan() == 0) {
                this.component.setTable(table);
            } else {
                throw new AnnotationException("A component cannot hold properties split into 2 different tables: " + this.getPath());
            }
        }
        this.addProperty(property, xClass);
    }

    public Join addJoin(JoinTable joinTable, boolean bl) {
        return this.parent.addJoin(joinTable, bl);
    }

    public ComponentPropertyHolder(Component component, String string, PropertyData propertyData, PropertyHolder propertyHolder, Mappings mappings) {
        super(string, propertyHolder, propertyData.getPropertyClass(), mappings);
        XProperty xProperty = propertyData.getProperty();
        this.setCurrentProperty(xProperty);
        this.component = component;
        this.isOrWithinEmbeddedId = propertyHolder.isOrWithinEmbeddedId() || xProperty != null && (xProperty.isAnnotationPresent(Id.class) || xProperty.isAnnotationPresent(EmbeddedId.class));
    }

    public String getClassName() {
        return this.component.getComponentClassName();
    }

    public String getEntityOwnerClassName() {
        return this.component.getOwner().getClassName();
    }

    public Table getTable() {
        return this.component.getTable();
    }

    public void addProperty(Property property, XClass xClass) {
        this.component.addProperty(property);
    }

    public KeyValue getIdentifier() {
        return this.component.getOwner().getIdentifier();
    }

    public boolean isOrWithinEmbeddedId() {
        return this.isOrWithinEmbeddedId;
    }

    public PersistentClass getPersistentClass() {
        return this.component.getOwner();
    }

    public boolean isComponent() {
        return true;
    }

    public boolean isEntity() {
        return false;
    }

    public void setParentProperty(String string) {
        this.component.setParentProperty(string);
    }

    public Column[] getOverriddenColumn(String string) {
        String string2;
        Column[] columnArray = super.getOverriddenColumn(string);
        if (columnArray == null && (string2 = this.extractUserPropertyName("id", string)) != null) {
            columnArray = super.getOverriddenColumn(string2);
        }
        if (columnArray == null && (string2 = this.extractUserPropertyName("_identifierMapper", string)) != null) {
            columnArray = super.getOverriddenColumn(string2);
        }
        return columnArray;
    }

    private String extractUserPropertyName(String string, String string2) {
        String string3 = null;
        String string4 = this.component.getOwner().getClassName();
        if (string2.startsWith(string4) && string2.length() > string4.length() + 2 + string.length() && string2.substring(string4.length() + 1, string4.length() + 1 + string.length()).equals(string)) {
            string3 = string4 + string2.substring(string4.length() + 1 + string.length());
        }
        return string3;
    }

    public JoinColumn[] getOverriddenJoinColumn(String string) {
        return super.getOverriddenJoinColumn(string);
    }
}

