/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.internal.util.StringHelper;

class ColumnsBuilder {
    private PropertyHolder propertyHolder;
    private Nullability nullability;
    private XProperty property;
    private PropertyData inferredData;
    private EntityBinder entityBinder;
    private Mappings mappings;
    private Ejb3Column[] columns;
    private Ejb3JoinColumn[] joinColumns;

    public ColumnsBuilder(PropertyHolder propertyHolder, Nullability nullability, XProperty xProperty, PropertyData propertyData, EntityBinder entityBinder, Mappings mappings) {
        this.propertyHolder = propertyHolder;
        this.nullability = nullability;
        this.property = xProperty;
        this.inferredData = propertyData;
        this.entityBinder = entityBinder;
        this.mappings = mappings;
    }

    public Ejb3Column[] getColumns() {
        return this.columns;
    }

    public Ejb3JoinColumn[] getJoinColumns() {
        return this.joinColumns;
    }

    public ColumnsBuilder extractMetadata() {
        Object object;
        Annotation annotation;
        this.columns = null;
        this.joinColumns = this.buildExplicitJoinColumns(this.property, this.inferredData);
        if (this.property.isAnnotationPresent(Column.class) || this.property.isAnnotationPresent(Formula.class)) {
            annotation = this.property.getAnnotation(Column.class);
            object = this.property.getAnnotation(Formula.class);
            this.columns = Ejb3Column.buildColumnFromAnnotation(new Column[]{annotation}, (Formula)object, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.mappings);
        } else if (this.property.isAnnotationPresent(Columns.class)) {
            annotation = this.property.getAnnotation(Columns.class);
            this.columns = Ejb3Column.buildColumnFromAnnotation(annotation.columns(), null, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.mappings);
        }
        if (this.joinColumns == null && (this.property.isAnnotationPresent(ManyToOne.class) || this.property.isAnnotationPresent(OneToOne.class))) {
            this.joinColumns = this.buildDefaultJoinColumnsForXToOne(this.property, this.inferredData);
        } else if (this.joinColumns == null && (this.property.isAnnotationPresent(OneToMany.class) || this.property.isAnnotationPresent(ElementCollection.class))) {
            annotation = this.property.getAnnotation(OneToMany.class);
            object = annotation != null ? annotation.mappedBy() : "";
            this.joinColumns = Ejb3JoinColumn.buildJoinColumns(null, (String)object, this.entityBinder.getSecondaryTables(), this.propertyHolder, this.inferredData.getPropertyName(), this.mappings);
        } else if (this.joinColumns == null && this.property.isAnnotationPresent(Any.class)) {
            throw new AnnotationException("@Any requires an explicit @JoinColumn(s): " + BinderHelper.getPath(this.propertyHolder, this.inferredData));
        }
        if (this.columns == null && !this.property.isAnnotationPresent(ManyToMany.class)) {
            this.columns = Ejb3Column.buildColumnFromAnnotation(null, null, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.mappings);
        }
        if (this.nullability == Nullability.FORCED_NOT_NULL) {
            for (Annotation annotation2 : this.columns) {
                ((Ejb3Column)((Object)annotation2)).forceNotNull();
            }
        }
        return this;
    }

    Ejb3JoinColumn[] buildDefaultJoinColumnsForXToOne(XProperty xProperty, PropertyData propertyData) {
        Ejb3JoinColumn[] ejb3JoinColumnArray;
        JoinTable joinTable = this.propertyHolder.getJoinTable(xProperty);
        if (joinTable != null) {
            ejb3JoinColumnArray = Ejb3JoinColumn.buildJoinColumns(joinTable.inverseJoinColumns(), null, this.entityBinder.getSecondaryTables(), this.propertyHolder, propertyData.getPropertyName(), this.mappings);
            if (StringHelper.isEmpty(joinTable.name())) {
                throw new AnnotationException("JoinTable.name() on a @ToOne association has to be explicit: " + BinderHelper.getPath(this.propertyHolder, propertyData));
            }
        } else {
            OneToOne oneToOne = xProperty.getAnnotation(OneToOne.class);
            String string = oneToOne != null ? oneToOne.mappedBy() : null;
            ejb3JoinColumnArray = Ejb3JoinColumn.buildJoinColumns(null, string, this.entityBinder.getSecondaryTables(), this.propertyHolder, propertyData.getPropertyName(), this.mappings);
        }
        return ejb3JoinColumnArray;
    }

    Ejb3JoinColumn[] buildExplicitJoinColumns(XProperty xProperty, PropertyData propertyData) {
        Annotation annotation;
        int n;
        Ejb3JoinColumn[] ejb3JoinColumnArray = null;
        JoinColumn[] joinColumnArray = null;
        if (xProperty.isAnnotationPresent(JoinColumn.class)) {
            joinColumnArray = new JoinColumn[]{xProperty.getAnnotation(JoinColumn.class)};
        } else if (xProperty.isAnnotationPresent(JoinColumns.class) && (n = (joinColumnArray = (annotation = xProperty.getAnnotation(JoinColumns.class)).value()).length) == 0) {
            throw new AnnotationException("Cannot bind an empty @JoinColumns");
        }
        if (joinColumnArray != null) {
            ejb3JoinColumnArray = Ejb3JoinColumn.buildJoinColumns(joinColumnArray, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, propertyData.getPropertyName(), this.mappings);
        } else if (xProperty.isAnnotationPresent(JoinColumnsOrFormulas.class)) {
            annotation = xProperty.getAnnotation(JoinColumnsOrFormulas.class);
            ejb3JoinColumnArray = Ejb3JoinColumn.buildJoinColumnsOrFormulas((JoinColumnsOrFormulas)annotation, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, propertyData.getPropertyName(), this.mappings);
        } else if (xProperty.isAnnotationPresent(JoinFormula.class)) {
            annotation = xProperty.getAnnotation(JoinFormula.class);
            ejb3JoinColumnArray = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinFormula((JoinFormula)annotation, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, propertyData.getPropertyName(), this.mappings)};
        }
        return ejb3JoinColumnArray;
    }

    Ejb3Column[] overrideColumnFromMapperOrMapsIdProperty(boolean bl) {
        Ejb3Column[] ejb3ColumnArray = this.columns;
        PropertyData propertyData = BinderHelper.getPropertyOverriddenByMapperOrMapsId(bl, this.propertyHolder, this.property.getName(), this.mappings);
        if (propertyData != null) {
            ejb3ColumnArray = this.buildExcplicitOrDefaultJoinColumn(propertyData);
        }
        return ejb3ColumnArray;
    }

    Ejb3Column[] buildExcplicitOrDefaultJoinColumn(PropertyData propertyData) {
        Ejb3Column[] ejb3ColumnArray = this.buildExplicitJoinColumns(propertyData.getProperty(), propertyData);
        if (ejb3ColumnArray == null) {
            ejb3ColumnArray = this.buildDefaultJoinColumnsForXToOne(propertyData.getProperty(), propertyData);
        }
        return ejb3ColumnArray;
    }
}

