/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.JoinTable;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.AbstractPropertyHolder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyHolder
extends AbstractPropertyHolder {
    private PersistentClass persistentClass;
    private Map<String, Join> joins;
    private transient Map<String, Join> joinsPerRealTableName;
    private EntityBinder entityBinder;
    private final Map<XClass, InheritanceState> inheritanceStatePerClass;

    public ClassPropertyHolder(PersistentClass persistentClass, XClass xClass, Map<String, Join> map, Mappings mappings, Map<XClass, InheritanceState> map2) {
        super(persistentClass.getEntityName(), null, xClass, mappings);
        this.persistentClass = persistentClass;
        this.joins = map;
        this.inheritanceStatePerClass = map2;
    }

    public ClassPropertyHolder(PersistentClass persistentClass, XClass xClass, EntityBinder entityBinder, Mappings mappings, Map<XClass, InheritanceState> map) {
        this(persistentClass, xClass, entityBinder.getSecondaryTables(), mappings, map);
        this.entityBinder = entityBinder;
    }

    @Override
    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public void addProperty(Property property, Ejb3Column[] ejb3ColumnArray, XClass xClass) {
        if (ejb3ColumnArray != null && ejb3ColumnArray[0].isSecondary()) {
            Join join = ejb3ColumnArray[0].getJoin();
            this.addPropertyToJoin(property, xClass, join);
        } else {
            this.addProperty(property, xClass);
        }
    }

    @Override
    public void addProperty(Property property, XClass xClass) {
        if (property.getValue() instanceof Component) {
            String string = property.getValue().getTable().getName();
            if (this.getJoinsPerRealTableName().containsKey(string)) {
                Join join = this.getJoinsPerRealTableName().get(string);
                this.addPropertyToJoin(property, xClass, join);
            } else {
                this.addPropertyToPersistentClass(property, xClass);
            }
        } else {
            this.addPropertyToPersistentClass(property, xClass);
        }
    }

    @Override
    public Join addJoin(JoinTable joinTable, boolean bl) {
        Join join = this.entityBinder.addJoin(joinTable, this, bl);
        this.joins = this.entityBinder.getSecondaryTables();
        return join;
    }

    private void addPropertyToPersistentClass(Property property, XClass xClass) {
        if (xClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(xClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + xClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                this.persistentClass.addMappedsuperclassProperty(property);
                this.addPropertyToMappedSuperclass(property, xClass);
            } else {
                this.persistentClass.addProperty(property);
            }
        } else {
            this.persistentClass.addProperty(property);
        }
    }

    private void addPropertyToMappedSuperclass(Property property, XClass xClass) {
        Mappings mappings = this.getMappings();
        Class clazz = mappings.getReflectionManager().toClass(xClass);
        MappedSuperclass mappedSuperclass = mappings.getMappedSuperclass(clazz);
        mappedSuperclass.addDeclaredProperty(property);
    }

    private void addPropertyToJoin(Property property, XClass xClass, Join join) {
        if (xClass != null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(xClass);
            if (inheritanceState == null) {
                throw new AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + xClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                join.addMappedsuperclassProperty(property);
                this.addPropertyToMappedSuperclass(property, xClass);
            } else {
                join.addProperty(property);
            }
        } else {
            join.addProperty(property);
        }
    }

    private Map<String, Join> getJoinsPerRealTableName() {
        if (this.joinsPerRealTableName == null) {
            this.joinsPerRealTableName = new HashMap<String, Join>(this.joins.size());
            for (Join join : this.joins.values()) {
                this.joinsPerRealTableName.put(join.getTable().getName(), join);
            }
        }
        return this.joinsPerRealTableName;
    }

    @Override
    public String getClassName() {
        return this.persistentClass.getClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.getClassName();
    }

    @Override
    public Table getTable() {
        return this.persistentClass.getTable();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.persistentClass.getIdentifier();
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return false;
    }
}

