/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SharedCacheMode;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.FetchProfiles;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Source;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Tuplizer;
import org.hibernate.annotations.Tuplizers;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.ColumnsBuilder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.JoinedSubclassFkSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.OneToOneSecondPass;
import org.hibernate.cfg.PropertyContainer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.ToOneBinder;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.VerifyFetchProfileReferenceSecondPass;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.MapKeyColumnDelegator;
import org.hibernate.cfg.annotations.MapKeyJoinColumnDelegator;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AnnotationBinder.class.getName());
    private static CacheConcurrencyStrategy DEFAULT_CACHE_CONCURRENCY_STRATEGY;

    private AnnotationBinder() {
    }

    public static void bindDefaults(Mappings mappings) {
        IdGenerator idGenerator;
        Map map = mappings.getReflectionManager().getDefaults();
        List list = (List)map.get(SequenceGenerator.class);
        if (list != null) {
            for (Annotation annotation : list) {
                idGenerator = AnnotationBinder.buildIdGenerator(annotation, mappings);
                if (idGenerator == null) continue;
                mappings.addDefaultGenerator(idGenerator);
            }
        }
        if ((list = (List)map.get(javax.persistence.TableGenerator.class)) != null) {
            for (Annotation annotation : list) {
                idGenerator = AnnotationBinder.buildIdGenerator(annotation, mappings);
                if (idGenerator == null) continue;
                mappings.addDefaultGenerator(idGenerator);
            }
        }
        if ((list = (List)map.get(NamedQuery.class)) != null) {
            for (Annotation annotation : list) {
                QueryBinder.bindQuery((NamedQuery)annotation, mappings, true);
            }
        }
        if ((list = (List)map.get(NamedNativeQuery.class)) != null) {
            for (Annotation annotation : list) {
                QueryBinder.bindNativeQuery((NamedNativeQuery)annotation, mappings, true);
            }
        }
        if ((list = (List)map.get(SqlResultSetMapping.class)) != null) {
            for (Annotation annotation : list) {
                QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)annotation, mappings, true);
            }
        }
    }

    public static void bindPackage(String string, Mappings mappings) {
        IdGenerator idGenerator;
        Annotation annotation;
        XPackage xPackage;
        try {
            xPackage = mappings.getReflectionManager().packageForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.packageNotFound(string);
            return;
        }
        if (xPackage.isAnnotationPresent(SequenceGenerator.class)) {
            annotation = xPackage.getAnnotation(SequenceGenerator.class);
            idGenerator = AnnotationBinder.buildIdGenerator(annotation, mappings);
            mappings.addGenerator(idGenerator);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", (Object)idGenerator.getName());
            }
        }
        if (xPackage.isAnnotationPresent(javax.persistence.TableGenerator.class)) {
            annotation = xPackage.getAnnotation(javax.persistence.TableGenerator.class);
            idGenerator = AnnotationBinder.buildIdGenerator(annotation, mappings);
            mappings.addGenerator(idGenerator);
        }
        AnnotationBinder.bindGenericGenerators(xPackage, mappings);
        AnnotationBinder.bindQueries(xPackage, mappings);
        AnnotationBinder.bindFilterDefs(xPackage, mappings);
        AnnotationBinder.bindTypeDefs(xPackage, mappings);
        AnnotationBinder.bindFetchProfiles(xPackage, mappings);
        BinderHelper.bindAnyMetaDefs(xPackage, mappings);
    }

    private static void bindGenericGenerators(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        GenericGenerator genericGenerator = xAnnotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators genericGenerators = xAnnotatedElement.getAnnotation(GenericGenerators.class);
        if (genericGenerator != null) {
            AnnotationBinder.bindGenericGenerator(genericGenerator, mappings);
        }
        if (genericGenerators != null) {
            for (GenericGenerator genericGenerator2 : genericGenerators.value()) {
                AnnotationBinder.bindGenericGenerator(genericGenerator2, mappings);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator genericGenerator, Mappings mappings) {
        IdGenerator idGenerator = AnnotationBinder.buildIdGenerator(genericGenerator, mappings);
        mappings.addGenerator(idGenerator);
    }

    private static void bindQueries(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        Annotation annotation = xAnnotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)annotation, mappings, false);
        annotation = xAnnotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (annotation != null) {
            for (SqlResultSetMapping sqlResultSetMapping : annotation.value()) {
                QueryBinder.bindSqlResultsetMapping(sqlResultSetMapping, mappings, false);
            }
        }
        annotation = xAnnotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)annotation, mappings, false);
        annotation = xAnnotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)annotation, mappings);
        annotation = xAnnotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)annotation, mappings, false);
        annotation = xAnnotatedElement.getAnnotation(org.hibernate.annotations.NamedQueries.class);
        QueryBinder.bindQueries((org.hibernate.annotations.NamedQueries)annotation, mappings);
        annotation = xAnnotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)annotation, mappings, false);
        annotation = xAnnotatedElement.getAnnotation(org.hibernate.annotations.NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((org.hibernate.annotations.NamedNativeQuery)annotation, mappings);
        annotation = xAnnotatedElement.getAnnotation(javax.persistence.NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((javax.persistence.NamedNativeQueries)annotation, mappings, false);
        annotation = xAnnotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)annotation, mappings);
    }

    private static IdGenerator buildIdGenerator(Annotation annotation, Mappings mappings) {
        IdGenerator idGenerator = new IdGenerator();
        if (mappings.getSchemaName() != null) {
            idGenerator.addParam("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            idGenerator.addParam("catalog", mappings.getCatalogName());
        }
        boolean bl = mappings.useNewGeneratorMappings();
        if (annotation == null) {
            idGenerator = null;
        } else if (annotation instanceof javax.persistence.TableGenerator) {
            javax.persistence.TableGenerator tableGenerator = (javax.persistence.TableGenerator)annotation;
            idGenerator.setName(tableGenerator.name());
            if (bl) {
                idGenerator.setIdentifierGeneratorStrategy(TableGenerator.class.getName());
                idGenerator.addParam("prefer_entity_table_as_segment_value", "true");
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.catalog())) {
                    idGenerator.addParam("catalog", tableGenerator.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.schema())) {
                    idGenerator.addParam("schema", tableGenerator.schema());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.table())) {
                    idGenerator.addParam("table_name", tableGenerator.table());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.pkColumnName())) {
                    idGenerator.addParam("segment_column_name", tableGenerator.pkColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.pkColumnValue())) {
                    idGenerator.addParam("segment_value", tableGenerator.pkColumnValue());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.valueColumnName())) {
                    idGenerator.addParam("value_column_name", tableGenerator.valueColumnName());
                }
                idGenerator.addParam("increment_size", String.valueOf(tableGenerator.allocationSize()));
                idGenerator.addParam("initial_value", String.valueOf(tableGenerator.initialValue() + 1));
                if (tableGenerator.uniqueConstraints() != null && tableGenerator.uniqueConstraints().length > 0) {
                    LOG.warn(tableGenerator.name());
                }
            } else {
                idGenerator.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.table())) {
                    idGenerator.addParam("table", tableGenerator.table());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.catalog())) {
                    idGenerator.addParam("catalog", tableGenerator.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.schema())) {
                    idGenerator.addParam("schema", tableGenerator.schema());
                }
                if (tableGenerator.uniqueConstraints() != null && tableGenerator.uniqueConstraints().length > 0) {
                    LOG.ignoringTableGeneratorConstraints(tableGenerator.name());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.pkColumnName())) {
                    idGenerator.addParam("primary_key_column", tableGenerator.pkColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.valueColumnName())) {
                    idGenerator.addParam("value_column", tableGenerator.valueColumnName());
                }
                if (!BinderHelper.isEmptyAnnotationValue(tableGenerator.pkColumnValue())) {
                    idGenerator.addParam("primary_key_value", tableGenerator.pkColumnValue());
                }
                idGenerator.addParam("max_lo", String.valueOf(tableGenerator.allocationSize() - 1));
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", (Object)idGenerator.getName());
            }
        } else if (annotation instanceof SequenceGenerator) {
            SequenceGenerator sequenceGenerator = (SequenceGenerator)annotation;
            idGenerator.setName(sequenceGenerator.name());
            if (bl) {
                idGenerator.setIdentifierGeneratorStrategy(SequenceStyleGenerator.class.getName());
                if (!BinderHelper.isEmptyAnnotationValue(sequenceGenerator.catalog())) {
                    idGenerator.addParam("catalog", sequenceGenerator.catalog());
                }
                if (!BinderHelper.isEmptyAnnotationValue(sequenceGenerator.schema())) {
                    idGenerator.addParam("schema", sequenceGenerator.schema());
                }
                if (!BinderHelper.isEmptyAnnotationValue(sequenceGenerator.sequenceName())) {
                    idGenerator.addParam("sequence_name", sequenceGenerator.sequenceName());
                }
                idGenerator.addParam("increment_size", String.valueOf(sequenceGenerator.allocationSize()));
                idGenerator.addParam("initial_value", String.valueOf(sequenceGenerator.initialValue()));
            } else {
                idGenerator.setIdentifierGeneratorStrategy("seqhilo");
                if (!BinderHelper.isEmptyAnnotationValue(sequenceGenerator.sequenceName())) {
                    idGenerator.addParam("sequence", sequenceGenerator.sequenceName());
                }
                if (sequenceGenerator.initialValue() != 1) {
                    LOG.unsupportedInitialValue("hibernate.id.new_generator_mappings");
                }
                idGenerator.addParam("max_lo", String.valueOf(sequenceGenerator.allocationSize() - 1));
                if (LOG.isTraceEnabled()) {
                    LOG.tracev("Add sequence generator with name: {0}", (Object)idGenerator.getName());
                }
            }
        } else if (annotation instanceof GenericGenerator) {
            Parameter[] parameterArray;
            GenericGenerator genericGenerator = (GenericGenerator)annotation;
            idGenerator.setName(genericGenerator.name());
            idGenerator.setIdentifierGeneratorStrategy(genericGenerator.strategy());
            for (Parameter parameter : parameterArray = genericGenerator.parameters()) {
                idGenerator.addParam(parameter.name(), parameter.value());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", (Object)idGenerator.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + annotation);
        }
        return idGenerator;
    }

    public static void bindClass(XClass xClass, Map<XClass, InheritanceState> map, Mappings mappings) throws MappingException {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Object object2;
        Object object3;
        Ejb3JoinColumn[] ejb3JoinColumnArray;
        if (xClass.isAnnotationPresent(Entity.class) && xClass.isAnnotationPresent(MappedSuperclass.class)) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass: " + xClass.getName());
        }
        InheritanceState inheritanceState = map.get(xClass);
        AnnotatedClassType annotatedClassType = mappings.getClassType(xClass);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)annotatedClassType)) {
            AnnotationBinder.bindQueries(xClass, mappings);
            AnnotationBinder.bindTypeDefs(xClass, mappings);
            AnnotationBinder.bindFilterDefs(xClass, mappings);
        }
        if (!AnnotationBinder.isEntityClassType(xClass, annotatedClassType)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", (Object)xClass.getName());
        }
        PersistentClass persistentClass = AnnotationBinder.getSuperEntity(xClass, map, mappings, inheritanceState);
        PersistentClass persistentClass2 = AnnotationBinder.makePersistentClass(inheritanceState, persistentClass);
        Entity entity = xClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity entity2 = xClass.getAnnotation(org.hibernate.annotations.Entity.class);
        EntityBinder entityBinder = new EntityBinder(entity, entity2, xClass, persistentClass2, mappings);
        entityBinder.setInheritanceState(inheritanceState);
        AnnotationBinder.bindQueries(xClass, mappings);
        AnnotationBinder.bindFilterDefs(xClass, mappings);
        AnnotationBinder.bindTypeDefs(xClass, mappings);
        AnnotationBinder.bindFetchProfiles(xClass, mappings);
        BinderHelper.bindAnyMetaDefs(xClass, mappings);
        String string = "";
        String string2 = "";
        String string3 = "";
        ArrayList<UniqueConstraintHolder> arrayList = new ArrayList();
        if (xClass.isAnnotationPresent(Table.class)) {
            ejb3JoinColumnArray = xClass.getAnnotation(Table.class);
            string2 = ejb3JoinColumnArray.name();
            string = ejb3JoinColumnArray.schema();
            string3 = ejb3JoinColumnArray.catalog();
            arrayList = TableBinder.buildUniqueConstraintHolders(ejb3JoinColumnArray.uniqueConstraints());
        }
        ejb3JoinColumnArray = AnnotationBinder.makeInheritanceJoinColumns(xClass, mappings, inheritanceState, persistentClass);
        Ejb3DiscriminatorColumn ejb3DiscriminatorColumn = null;
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            ejb3DiscriminatorColumn = AnnotationBinder.processDiscriminatorProperties(xClass, mappings, inheritanceState, entityBinder);
        }
        entityBinder.setProxy(xClass.getAnnotation(Proxy.class));
        entityBinder.setBatchSize(xClass.getAnnotation(BatchSize.class));
        entityBinder.setWhere(xClass.getAnnotation(Where.class));
        entityBinder.setCache(AnnotationBinder.determineCacheSettings(xClass, mappings));
        entityBinder.setNaturalIdCache(xClass, xClass.getAnnotation(NaturalIdCache.class));
        AnnotationBinder.bindFilters(xClass, entityBinder, mappings);
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            object3 = xClass.getAnnotation(Check.class);
            object2 = object3 == null ? null : object3.constraints();
            entityBinder.bindTable(string, string3, string2, arrayList, (String)object2, inheritanceState.hasDenormalizedTable() ? persistentClass.getTable() : null);
        } else if (xClass.isAnnotationPresent(Table.class)) {
            LOG.invalidTableAnnotation(xClass.getName());
        }
        object3 = PropertyHolderBuilder.buildPropertyHolder(xClass, persistentClass2, entityBinder, mappings, map);
        object2 = xClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secondaryTables = xClass.getAnnotation(SecondaryTables.class);
        entityBinder.firstLevelSecondaryTablesBinding((SecondaryTable)object2, secondaryTables);
        OnDelete onDelete = xClass.getAnnotation(OnDelete.class);
        boolean bl = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.getType()) && inheritanceState.hasParents()) {
            bl = true;
            serializable2 = (JoinedSubclass)persistentClass2;
            object = new DependantValue(mappings, ((JoinedSubclass)serializable2).getTable(), ((Subclass)serializable2).getIdentifier());
            ((JoinedSubclass)serializable2).setKey((KeyValue)object);
            ForeignKey foreignKey = xClass.getAnnotation(ForeignKey.class);
            if (foreignKey != null && !BinderHelper.isEmptyAnnotationValue(foreignKey.name())) {
                ((SimpleValue)object).setForeignKeyName(foreignKey.name());
            }
            if (onDelete != null) {
                ((SimpleValue)object).setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDelete.action()));
            } else {
                ((SimpleValue)object).setCascadeDeleteEnabled(false);
            }
            serializable = new JoinedSubclassFkSecondPass((JoinedSubclass)serializable2, ejb3JoinColumnArray, (SimpleValue)object, mappings);
            mappings.addSecondPass((SecondPass)serializable);
            mappings.addSecondPass(new CreateKeySecondPass((JoinedSubclass)serializable2));
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            if (!(inheritanceState.hasParents() || !inheritanceState.hasSiblings() && ejb3DiscriminatorColumn.isImplicit())) {
                AnnotationBinder.bindDiscriminatorToPersistentClass((RootClass)persistentClass2, ejb3DiscriminatorColumn, entityBinder.getSecondaryTables(), (PropertyHolder)object3, mappings);
                entityBinder.bindDiscriminatorValue();
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType())) {
            // empty if block
        }
        if (onDelete != null && !bl) {
            LOG.invalidOnDeleteAnnotation(object3.getEntityName());
        }
        serializable2 = AnnotationBinder.buildLocalGenerators(xClass, mappings);
        object = inheritanceState.getElementsToProcess();
        inheritanceState.postProcess(persistentClass2, entityBinder);
        boolean bl2 = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
        serializable = new HashSet<String>();
        boolean bl3 = AnnotationBinder.mapAsIdClass(map, inheritanceState, persistentClass2, entityBinder, (PropertyHolder)object3, (InheritanceState.ElementsToProcess)object, serializable, mappings);
        if (!bl3) {
            entityBinder.setWrapIdsInEmbeddedComponents(((InheritanceState.ElementsToProcess)object).getIdPropertyCount() > 1);
        }
        AnnotationBinder.processIdPropertiesIfNotAlready(map, mappings, persistentClass2, entityBinder, (PropertyHolder)object3, (HashMap<String, IdGenerator>)serializable2, (InheritanceState.ElementsToProcess)object, bl2, serializable);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)persistentClass2;
            mappings.addSecondPass(new CreateKeySecondPass(rootClass));
        } else {
            persistentClass.addSubclass((Subclass)persistentClass2);
        }
        mappings.addClass(persistentClass2);
        mappings.addSecondPass(new SecondaryTableSecondPass(entityBinder, (PropertyHolder)object3, xClass));
        entityBinder.processComplementaryTableDefinitions(xClass.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.processComplementaryTableDefinitions(xClass.getAnnotation(Tables.class));
    }

    private static Ejb3DiscriminatorColumn processDiscriminatorProperties(XClass xClass, Mappings mappings, InheritanceState inheritanceState, EntityBinder entityBinder) {
        Ejb3DiscriminatorColumn ejb3DiscriminatorColumn = null;
        DiscriminatorColumn discriminatorColumn = xClass.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorType discriminatorType = discriminatorColumn != null ? discriminatorColumn.discriminatorType() : DiscriminatorType.STRING;
        DiscriminatorFormula discriminatorFormula = xClass.getAnnotation(DiscriminatorFormula.class);
        if (!inheritanceState.hasParents()) {
            ejb3DiscriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discriminatorColumn, discriminatorFormula, mappings);
        }
        if (discriminatorColumn != null && inheritanceState.hasParents()) {
            LOG.invalidDiscriminatorAnnotation(xClass.getName());
        }
        String string = xClass.isAnnotationPresent(DiscriminatorValue.class) ? xClass.getAnnotation(DiscriminatorValue.class).value() : null;
        entityBinder.setDiscriminatorValue(string);
        DiscriminatorOptions discriminatorOptions = xClass.getAnnotation(DiscriminatorOptions.class);
        if (discriminatorOptions != null) {
            entityBinder.setForceDiscriminator(discriminatorOptions.force());
            entityBinder.setInsertableDiscriminator(discriminatorOptions.insert());
        }
        return ejb3DiscriminatorColumn;
    }

    private static void processIdPropertiesIfNotAlready(Map<XClass, InheritanceState> map, Mappings mappings, PersistentClass persistentClass, EntityBinder entityBinder, PropertyHolder propertyHolder, HashMap<String, IdGenerator> hashMap, InheritanceState.ElementsToProcess elementsToProcess, boolean bl, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(set);
        for (PropertyData object : elementsToProcess.getElements()) {
            String string = object.getPropertyName();
            if (!set.contains(string)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, bl ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, object, hashMap, entityBinder, false, false, false, mappings, map);
                continue;
            }
            hashSet.remove(string);
        }
        if (hashSet.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : hashSet) {
                stringBuilder.append(string).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + stringBuilder.substring(0, stringBuilder.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
    }

    private static boolean mapAsIdClass(Map<XClass, InheritanceState> map, InheritanceState inheritanceState, PersistentClass persistentClass, EntityBinder entityBinder, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> set, Mappings mappings) {
        XClass xClass = inheritanceState.getClassWithIdClass(false);
        if (xClass != null) {
            AccessType accessType;
            PropertyPreloadedData propertyPreloadedData;
            PropertyPreloadedData propertyPreloadedData2;
            IdClass idClass = xClass.getAnnotation(IdClass.class);
            XClass xClass2 = mappings.getReflectionManager().toXClass(idClass.value());
            boolean bl = AnnotationBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, xClass2, propertyPreloadedData2 = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", xClass2), propertyPreloadedData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", xClass), accessType = entityBinder.getPropertyAccessor(xClass2), map, mappings);
            if (bl) {
                return false;
            }
            boolean bl2 = true;
            String string = "assigned";
            String string2 = "";
            boolean bl3 = entityBinder.isIgnoreIdAnnotations();
            entityBinder.setIgnoreIdAnnotations(true);
            propertyHolder.setInIdClass(true);
            AnnotationBinder.bindIdClass(string, string2, propertyPreloadedData2, propertyPreloadedData, null, propertyHolder, bl2, accessType, entityBinder, true, false, mappings, map);
            propertyHolder.setInIdClass(null);
            propertyPreloadedData2 = new PropertyPreloadedData(accessType, "_identifierMapper", xClass2);
            Component component = AnnotationBinder.fillComponent(propertyHolder, propertyPreloadedData2, propertyPreloadedData, accessType, false, entityBinder, true, true, false, mappings, map);
            entityBinder.setIgnoreIdAnnotations(bl3);
            persistentClass.setIdentifierMapper(component);
            org.hibernate.mapping.MappedSuperclass mappedSuperclass = BinderHelper.getMappedSuperclassOrNull(propertyPreloadedData2.getDeclaringClass(), map, mappings);
            if (mappedSuperclass != null) {
                mappedSuperclass.setDeclaredIdentifierMapper(component);
            } else {
                persistentClass.setDeclaredIdentifierMapper(component);
            }
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(component);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator iterator = component.getPropertyIterator();
            while (iterator.hasNext()) {
                set.add(((Property)iterator.next()).getName());
            }
            return true;
        }
        return false;
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, XClass xClass, PropertyData propertyData, PropertyData propertyData2, AccessType accessType, Map<XClass, InheritanceState> map, Mappings mappings) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData propertyData3 = AnnotationBinder.getUniqueIdPropertyFromBaseClass(propertyData, propertyData2, accessType, mappings);
            InheritanceState inheritanceState = map.get(propertyData3.getClassOrElement());
            if (inheritanceState == null) {
                return false;
            }
            XClass xClass2 = inheritanceState.getClassWithIdClass(true);
            if (xClass2 == null) {
                XProperty xProperty = propertyData3.getProperty();
                return xProperty.isAnnotationPresent(ManyToOne.class) || xProperty.isAnnotationPresent(OneToOne.class);
            }
            XClass xClass3 = mappings.getReflectionManager().toXClass(xClass2.getAnnotation(IdClass.class).value());
            return xClass3.equals(xClass);
        }
        return false;
    }

    private static Cache determineCacheSettings(XClass xClass, Mappings mappings) {
        Cache cache = xClass.getAnnotation(Cache.class);
        if (cache != null) {
            return cache;
        }
        Cacheable cacheable = xClass.getAnnotation(Cacheable.class);
        SharedCacheMode sharedCacheMode = AnnotationBinder.determineSharedCacheMode(mappings);
        switch (sharedCacheMode) {
            case ALL: {
                cache = AnnotationBinder.buildCacheMock(xClass.getName(), mappings);
                break;
            }
            case ENABLE_SELECTIVE: {
                if (cacheable == null || !cacheable.value()) break;
                cache = AnnotationBinder.buildCacheMock(xClass.getName(), mappings);
                break;
            }
            case DISABLE_SELECTIVE: {
                if (cacheable != null && !cacheable.value()) break;
                cache = AnnotationBinder.buildCacheMock(xClass.getName(), mappings);
                break;
            }
        }
        return cache;
    }

    private static SharedCacheMode determineSharedCacheMode(Mappings mappings) {
        SharedCacheMode sharedCacheMode;
        Object object = mappings.getConfigurationProperties().get("javax.persistence.sharedCache.mode");
        if (object == null) {
            LOG.debug("No value specified for 'javax.persistence.sharedCache.mode'; using UNSPECIFIED");
            sharedCacheMode = SharedCacheMode.UNSPECIFIED;
        } else if (SharedCacheMode.class.isInstance(object)) {
            sharedCacheMode = (SharedCacheMode)((Object)object);
        } else {
            try {
                sharedCacheMode = SharedCacheMode.valueOf(object.toString());
            }
            catch (Exception exception) {
                LOG.debugf("Unable to resolve given mode name [%s]; using UNSPECIFIED : %s", object, (Object)exception);
                sharedCacheMode = SharedCacheMode.UNSPECIFIED;
            }
        }
        return sharedCacheMode;
    }

    private static Cache buildCacheMock(String string, Mappings mappings) {
        return new LocalCacheAnnotationImpl(string, AnnotationBinder.determineCacheConcurrencyStrategy(mappings));
    }

    static void prepareDefaultCacheConcurrencyStrategy(Properties properties) {
        if (DEFAULT_CACHE_CONCURRENCY_STRATEGY != null) {
            LOG.trace("Default cache concurrency strategy already defined");
            return;
        }
        if (!properties.containsKey("hibernate.cache.default_cache_concurrency_strategy")) {
            LOG.trace("Given properties did not contain any default cache concurrency strategy setting");
            return;
        }
        String string = properties.getProperty("hibernate.cache.default_cache_concurrency_strategy");
        LOG.tracev("Discovered default cache concurrency strategy via config [{0}]", (Object)string);
        CacheConcurrencyStrategy cacheConcurrencyStrategy = CacheConcurrencyStrategy.parse(string);
        if (cacheConcurrencyStrategy == null) {
            LOG.trace("Discovered default cache concurrency strategy specified nothing");
            return;
        }
        LOG.debugf("Setting default cache concurrency strategy via config [%s]", (Object)cacheConcurrencyStrategy.name());
        DEFAULT_CACHE_CONCURRENCY_STRATEGY = cacheConcurrencyStrategy;
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(Mappings mappings) {
        if (DEFAULT_CACHE_CONCURRENCY_STRATEGY == null) {
            RegionFactory regionFactory = SettingsFactory.createRegionFactory(mappings.getConfigurationProperties(), true);
            DEFAULT_CACHE_CONCURRENCY_STRATEGY = CacheConcurrencyStrategy.fromAccessType(regionFactory.getDefaultAccessType());
        }
        return DEFAULT_CACHE_CONCURRENCY_STRATEGY;
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass persistentClass) {
        PersistentClass persistentClass2;
        if (!inheritanceState.hasParents()) {
            persistentClass2 = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            persistentClass2 = new SingleTableSubclass(persistentClass);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.getType())) {
            persistentClass2 = new JoinedSubclass(persistentClass);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType())) {
            persistentClass2 = new UnionSubclass(persistentClass);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + (Object)((Object)inheritanceState.getType()));
        }
        return persistentClass2;
    }

    private static Ejb3JoinColumn[] makeInheritanceJoinColumns(XClass xClass, Mappings mappings, InheritanceState inheritanceState, PersistentClass persistentClass) {
        boolean bl;
        Ejb3JoinColumn[] ejb3JoinColumnArray = null;
        boolean bl2 = bl = inheritanceState.hasParents() && InheritanceType.JOINED.equals((Object)inheritanceState.getType());
        if (bl) {
            boolean bl3;
            PrimaryKeyJoinColumns primaryKeyJoinColumns = xClass.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl4 = bl3 = primaryKeyJoinColumns != null && primaryKeyJoinColumns.value().length != 0;
            if (bl3) {
                int n = primaryKeyJoinColumns.value().length;
                ejb3JoinColumnArray = new Ejb3JoinColumn[n];
                for (int i = 0; i < n; ++i) {
                    PrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.value()[i];
                    ejb3JoinColumnArray[i] = Ejb3JoinColumn.buildJoinColumn(primaryKeyJoinColumn, null, persistentClass.getIdentifier(), null, null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn primaryKeyJoinColumn = xClass.getAnnotation(PrimaryKeyJoinColumn.class);
                ejb3JoinColumnArray = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(primaryKeyJoinColumn, null, persistentClass.getIdentifier(), null, null, mappings)};
            }
            LOG.trace("Subclass joined column(s) created");
        } else if (xClass.isAnnotationPresent(PrimaryKeyJoinColumns.class) || xClass.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            LOG.invalidPrimaryKeyJoinColumnAnnotation();
        }
        return ejb3JoinColumnArray;
    }

    private static PersistentClass getSuperEntity(XClass xClass, Map<XClass, InheritanceState> map, Mappings mappings, InheritanceState inheritanceState) {
        PersistentClass persistentClass;
        InheritanceState inheritanceState2 = InheritanceState.getInheritanceStateOfSuperEntity(xClass, map);
        PersistentClass persistentClass2 = persistentClass = inheritanceState2 != null ? mappings.getClass(inheritanceState2.getClazz().getName()) : null;
        if (persistentClass == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be binded after it's mother class: " + inheritanceState2.getClazz().getName());
        }
        return persistentClass;
    }

    private static boolean isEntityClassType(XClass xClass, AnnotatedClassType annotatedClassType) {
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)annotatedClassType) || AnnotatedClassType.NONE.equals((Object)annotatedClassType) || AnnotatedClassType.EMBEDDABLE.equals((Object)annotatedClassType)) {
            if (AnnotatedClassType.NONE.equals((Object)annotatedClassType) && xClass.isAnnotationPresent(org.hibernate.annotations.Entity.class)) {
                LOG.missingEntityAnnotation(xClass.getName());
            }
            return false;
        }
        if (!annotatedClassType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + xClass.getName());
        }
        return true;
    }

    private static void bindFilters(XClass xClass, EntityBinder entityBinder, Mappings mappings) {
        AnnotationBinder.bindFilters(xClass, entityBinder);
        for (XClass xClass2 = xClass.getSuperclass(); xClass2 != null; xClass2 = xClass2.getSuperclass()) {
            AnnotatedClassType annotatedClassType = mappings.getClassType(xClass2);
            if (!AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)annotatedClassType)) continue;
            AnnotationBinder.bindFilters(xClass2, entityBinder);
        }
    }

    private static void bindFilters(XAnnotatedElement xAnnotatedElement, EntityBinder entityBinder) {
        Object object;
        Filters filters = xAnnotatedElement.getAnnotation(Filters.class);
        if (filters != null) {
            object = filters.value();
            int n = ((Filter[])object).length;
            for (int i = 0; i < n; ++i) {
                Filter filter = object[i];
                entityBinder.addFilter(filter);
            }
        }
        if ((object = xAnnotatedElement.getAnnotation(Filter.class)) != null) {
            entityBinder.addFilter((Filter)object);
        }
    }

    private static void bindFilterDefs(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        FilterDef filterDef = xAnnotatedElement.getAnnotation(FilterDef.class);
        FilterDefs filterDefs = xAnnotatedElement.getAnnotation(FilterDefs.class);
        if (filterDef != null) {
            AnnotationBinder.bindFilterDef(filterDef, mappings);
        }
        if (filterDefs != null) {
            for (FilterDef filterDef2 : filterDefs.value()) {
                AnnotationBinder.bindFilterDef(filterDef2, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef filterDef, Mappings mappings) {
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        for (ParamDef paramDef : filterDef.parameters()) {
            hashMap.put(paramDef.name(), mappings.getTypeResolver().heuristicType(paramDef.type()));
        }
        FilterDefinition filterDefinition = new FilterDefinition(filterDef.name(), filterDef.defaultCondition(), hashMap);
        LOG.debugf("Binding filter definition: %s", (Object)filterDefinition.getFilterName());
        mappings.addFilterDefinition(filterDefinition);
    }

    private static void bindTypeDefs(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        TypeDef typeDef = xAnnotatedElement.getAnnotation(TypeDef.class);
        TypeDefs typeDefs = xAnnotatedElement.getAnnotation(TypeDefs.class);
        if (typeDef != null) {
            AnnotationBinder.bindTypeDef(typeDef, mappings);
        }
        if (typeDefs != null) {
            for (TypeDef typeDef2 : typeDefs.value()) {
                AnnotationBinder.bindTypeDef(typeDef2, mappings);
            }
        }
    }

    private static void bindFetchProfiles(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        FetchProfile fetchProfile = xAnnotatedElement.getAnnotation(FetchProfile.class);
        FetchProfiles fetchProfiles = xAnnotatedElement.getAnnotation(FetchProfiles.class);
        if (fetchProfile != null) {
            AnnotationBinder.bindFetchProfile(fetchProfile, mappings);
        }
        if (fetchProfiles != null) {
            for (FetchProfile fetchProfile2 : fetchProfiles.value()) {
                AnnotationBinder.bindFetchProfile(fetchProfile2, mappings);
            }
        }
    }

    private static void bindFetchProfile(FetchProfile fetchProfile, Mappings mappings) {
        for (FetchProfile.FetchOverride fetchOverride : fetchProfile.fetchOverrides()) {
            org.hibernate.annotations.FetchMode fetchMode = fetchOverride.mode();
            if (!fetchMode.equals((Object)org.hibernate.annotations.FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            VerifyFetchProfileReferenceSecondPass verifyFetchProfileReferenceSecondPass = new VerifyFetchProfileReferenceSecondPass(fetchProfile.name(), fetchOverride, mappings);
            mappings.addSecondPass(verifyFetchProfileReferenceSecondPass);
        }
    }

    private static void bindTypeDef(TypeDef typeDef, Mappings mappings) {
        Properties properties = new Properties();
        for (Parameter parameter : typeDef.parameters()) {
            properties.setProperty(parameter.name(), parameter.value());
        }
        if (BinderHelper.isEmptyAnnotationValue(typeDef.name()) && typeDef.defaultForType().equals(Void.TYPE)) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + typeDef.typeClass().getName());
        }
        if (!BinderHelper.isEmptyAnnotationValue(typeDef.name())) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding type definition: %s", (Object)typeDef.name());
            }
            mappings.addTypeDef(typeDef.name(), typeDef.typeClass().getName(), properties);
        }
        if (!typeDef.defaultForType().equals(Void.TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding type definition: %s", (Object)typeDef.defaultForType().getName());
            }
            mappings.addTypeDef(typeDef.defaultForType().getName(), typeDef.typeClass().getName(), properties);
        }
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn ejb3DiscriminatorColumn, Map<String, Join> map, PropertyHolder propertyHolder, Mappings mappings) {
        if (rootClass.getDiscriminator() == null) {
            if (ejb3DiscriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            ejb3DiscriminatorColumn.setJoins(map);
            ejb3DiscriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue simpleValue = new SimpleValue(mappings, rootClass.getTable());
            rootClass.setDiscriminator(simpleValue);
            ejb3DiscriminatorColumn.linkWithValue(simpleValue);
            simpleValue.setTypeName(ejb3DiscriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Setting discriminator for entity {0}", (Object)rootClass.getEntityName());
            }
        }
    }

    static int addElementsOfClass(List<PropertyData> list, AccessType accessType, PropertyContainer propertyContainer, Mappings mappings) {
        int n = 0;
        AccessType accessType2 = accessType;
        if (propertyContainer.hasExplicitAccessStrategy()) {
            accessType2 = propertyContainer.getExplicitAccessStrategy();
        }
        Collection<XProperty> collection = propertyContainer.getProperties(accessType2);
        for (XProperty xProperty : collection) {
            int n2 = AnnotationBinder.addProperty(propertyContainer, xProperty, list, accessType2.getType(), mappings);
            n += n2;
        }
        return n;
    }

    private static int addProperty(PropertyContainer propertyContainer, XProperty xProperty, List<PropertyData> list, String string, Mappings mappings) {
        XClass xClass = propertyContainer.getDeclaringClass();
        XClass xClass2 = propertyContainer.getEntityAtStake();
        int n = 0;
        PropertyInferredData propertyInferredData = new PropertyInferredData(xClass, xProperty, string, mappings.getReflectionManager());
        XProperty xProperty2 = propertyInferredData.getProperty();
        if (xProperty2.isAnnotationPresent(Id.class) || xProperty2.isAnnotationPresent(EmbeddedId.class)) {
            list.add(0, propertyInferredData);
            if (mappings.isSpecjProprietarySyntaxEnabled() && xProperty2.isAnnotationPresent(Id.class) && xProperty2.isAnnotationPresent(javax.persistence.Column.class)) {
                String string2 = xProperty2.getAnnotation(javax.persistence.Column.class).name();
                for (XProperty xProperty3 : xClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                    if (xProperty3.isAnnotationPresent(MapsId.class)) continue;
                    boolean bl = false;
                    JoinColumns joinColumns = xProperty3.getAnnotation(JoinColumns.class);
                    if (xProperty3.isAnnotationPresent(JoinColumn.class) && xProperty3.getAnnotation(JoinColumn.class).name().equals(string2)) {
                        bl = true;
                    } else if (xProperty3.isAnnotationPresent(JoinColumns.class)) {
                        for (JoinColumn joinColumn : joinColumns.value()) {
                            if (!string2.equals(joinColumn.name())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    PropertyInferredData propertyInferredData2 = new PropertyInferredData(xClass, xProperty3, string, mappings.getReflectionManager());
                    mappings.addPropertyAnnotatedWithMapsIdSpecj(xClass2, propertyInferredData2, xProperty2.toString());
                }
            }
            if (xProperty2.isAnnotationPresent(ManyToOne.class) || xProperty2.isAnnotationPresent(OneToOne.class)) {
                mappings.addToOneAndIdProperty(xClass2, propertyInferredData);
            }
            ++n;
        } else {
            list.add(propertyInferredData);
        }
        if (xProperty2.isAnnotationPresent(MapsId.class)) {
            mappings.addPropertyAnnotatedWithMapsId(xClass2, propertyInferredData);
        }
        return n;
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData propertyData, HashMap<String, IdGenerator> hashMap, EntityBinder entityBinder, boolean bl, boolean bl2, boolean bl3, Mappings mappings, Map<XClass, InheritanceState> map) throws MappingException {
        block77: {
            NaturalId naturalId;
            Object object;
            XProperty xProperty;
            boolean bl4 = LOG.isTraceEnabled();
            if (bl4) {
                LOG.tracev("Processing annotations of {0}.{1}", (Object)propertyHolder.getEntityName(), (Object)propertyData.getPropertyName());
            }
            if ((xProperty = propertyData.getProperty()).isAnnotationPresent(Parent.class)) {
                if (!propertyHolder.isComponent()) {
                    throw new AnnotationException("@Parent cannot be applied outside an embeddable object: " + BinderHelper.getPath(propertyHolder, propertyData));
                }
                propertyHolder.setParentProperty(xProperty.getName());
                return;
            }
            ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, xProperty, propertyData, entityBinder, mappings).extractMetadata();
            Ejb3Column[] ejb3ColumnArray = columnsBuilder.getColumns();
            Ejb3JoinColumn[] ejb3JoinColumnArray = columnsBuilder.getJoinColumns();
            XClass xClass = propertyData.getClassOrElement();
            PropertyBinder propertyBinder = new PropertyBinder();
            propertyBinder.setName(propertyData.getPropertyName());
            propertyBinder.setReturnedClassName(propertyData.getTypeName());
            propertyBinder.setAccessType(propertyData.getDefaultAccess());
            propertyBinder.setHolder(propertyHolder);
            propertyBinder.setProperty(xProperty);
            propertyBinder.setReturnedClass(propertyData.getPropertyClass());
            propertyBinder.setMappings(mappings);
            if (bl) {
                propertyBinder.setInsertable(false);
                propertyBinder.setUpdatable(false);
            }
            propertyBinder.setDeclaringClass(propertyData.getDeclaringClass());
            propertyBinder.setEntityBinder(entityBinder);
            propertyBinder.setInheritanceStatePerClass(map);
            boolean bl5 = !entityBinder.isIgnoreIdAnnotations() && (xProperty.isAnnotationPresent(Id.class) || xProperty.isAnnotationPresent(EmbeddedId.class));
            propertyBinder.setId(bl5);
            if (xProperty.isAnnotationPresent(Version.class)) {
                if (bl) {
                    throw new AnnotationException("@IdClass class should not have @Version property");
                }
                if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                    throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
                }
                if (!propertyHolder.isEntity()) {
                    throw new AnnotationException("Unable to define @Version on an embedded class: " + propertyHolder.getEntityName());
                }
                if (bl4) {
                    LOG.tracev("{0} is a version property", (Object)propertyData.getPropertyName());
                }
                object = (RootClass)propertyHolder.getPersistentClass();
                propertyBinder.setColumns(ejb3ColumnArray);
                Property property = propertyBinder.makePropertyValueAndBind();
                AnnotationBinder.setVersionInformation(xProperty, propertyBinder);
                ((RootClass)object).setVersion(property);
                org.hibernate.mapping.MappedSuperclass mappedSuperclass = BinderHelper.getMappedSuperclassOrNull(propertyData.getDeclaringClass(), map, mappings);
                if (mappedSuperclass != null) {
                    mappedSuperclass.setDeclaredVersion(property);
                } else {
                    ((RootClass)object).setDeclaredVersion(property);
                }
                SimpleValue simpleValue = (SimpleValue)property.getValue();
                simpleValue.setNullValue("undefined");
                ((PersistentClass)object).setOptimisticLockMode(0);
                if (bl4) {
                    LOG.tracev("Version name: {0}, unsavedValue: {1}", (Object)((RootClass)object).getVersion().getName(), (Object)((SimpleValue)((RootClass)object).getVersion().getValue()).getNullValue());
                }
            } else {
                boolean bl6;
                boolean bl7 = bl6 = xProperty.isAnnotationPresent(MapsId.class) || xProperty.isAnnotationPresent(Id.class);
                if (xProperty.isAnnotationPresent(ManyToOne.class)) {
                    ManyToOne manyToOne = xProperty.getAnnotation(ManyToOne.class);
                    if (xProperty.isAnnotationPresent(javax.persistence.Column.class) || xProperty.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @ManyToOne property: " + BinderHelper.getPath(propertyHolder, propertyData));
                    }
                    Cascade cascade = xProperty.getAnnotation(Cascade.class);
                    NotFound notFound = xProperty.getAnnotation(NotFound.class);
                    int n = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE) ? 1 : 0;
                    OnDelete object2 = xProperty.getAnnotation(OnDelete.class);
                    boolean bl8 = object2 != null && OnDeleteAction.CASCADE.equals((Object)object2.action());
                    JoinTable joinTable = propertyHolder.getJoinTable(xProperty);
                    if (joinTable != null) {
                        Join join = propertyHolder.addJoin(joinTable, false);
                        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                            ejb3JoinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    boolean bl9 = !manyToOne.optional() || bl6;
                    AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(manyToOne.cascade(), cascade, false, bl6), ejb3JoinColumnArray, !bl9, n != 0, bl8, ToOneBinder.getTargetEntity(propertyData, mappings), propertyHolder, propertyData, false, bl, bl3, propertyBinder, mappings);
                } else if (xProperty.isAnnotationPresent(OneToOne.class)) {
                    OneToOne oneToOne = xProperty.getAnnotation(OneToOne.class);
                    if (xProperty.isAnnotationPresent(javax.persistence.Column.class) || xProperty.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @OneToOne property: " + BinderHelper.getPath(propertyHolder, propertyData));
                    }
                    boolean bl10 = xProperty.isAnnotationPresent(PrimaryKeyJoinColumn.class) || xProperty.isAnnotationPresent(PrimaryKeyJoinColumns.class);
                    Cascade cascade = xProperty.getAnnotation(Cascade.class);
                    NotFound notFound = xProperty.getAnnotation(NotFound.class);
                    boolean bl11 = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                    OnDelete onDelete = xProperty.getAnnotation(OnDelete.class);
                    boolean bl12 = onDelete != null && OnDeleteAction.CASCADE.equals((Object)onDelete.action());
                    JoinTable joinTable = propertyHolder.getJoinTable(xProperty);
                    if (joinTable != null) {
                        Join join = propertyHolder.addJoin(joinTable, false);
                        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                            ejb3JoinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    boolean bl13 = !oneToOne.optional() || bl6;
                    AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(oneToOne.cascade(), cascade, oneToOne.orphanRemoval(), bl6), ejb3JoinColumnArray, !bl13, AnnotationBinder.getFetchMode(oneToOne.fetch()), bl11, bl12, ToOneBinder.getTargetEntity(propertyData, mappings), propertyHolder, propertyData, oneToOne.mappedBy(), bl10, bl, bl3, propertyBinder, mappings);
                } else if (xProperty.isAnnotationPresent(Any.class)) {
                    if (xProperty.isAnnotationPresent(javax.persistence.Column.class) || xProperty.isAnnotationPresent(Columns.class)) {
                        throw new AnnotationException("@Column(s) not allowed on a @Any property: " + BinderHelper.getPath(propertyHolder, propertyData));
                    }
                    Cascade cascade = xProperty.getAnnotation(Cascade.class);
                    OnDelete onDelete = xProperty.getAnnotation(OnDelete.class);
                    boolean bl14 = onDelete != null && OnDeleteAction.CASCADE.equals((Object)onDelete.action());
                    JoinTable joinTable = propertyHolder.getJoinTable(xProperty);
                    if (joinTable != null) {
                        Join join = propertyHolder.addJoin(joinTable, false);
                        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                            ejb3JoinColumn.setSecondaryTableName(join.getTable().getName());
                        }
                    }
                    AnnotationBinder.bindAny(AnnotationBinder.getCascadeStrategy(null, cascade, false, bl6), ejb3JoinColumnArray, bl14, nullability, propertyHolder, propertyData, entityBinder, bl, mappings);
                } else if (xProperty.isAnnotationPresent(OneToMany.class) || xProperty.isAnnotationPresent(ManyToMany.class) || xProperty.isAnnotationPresent(ElementCollection.class) || xProperty.isAnnotationPresent(ManyToAny.class)) {
                    Ejb3Column[] ejb3ColumnArray2;
                    Object object2;
                    Object object3;
                    PropertyData propertyData2;
                    OneToMany oneToMany = xProperty.getAnnotation(OneToMany.class);
                    ManyToMany manyToMany = xProperty.getAnnotation(ManyToMany.class);
                    ElementCollection elementCollection = xProperty.getAnnotation(ElementCollection.class);
                    IndexColumn indexColumn = xProperty.isAnnotationPresent(OrderColumn.class) ? IndexColumn.buildColumnFromAnnotation(xProperty.getAnnotation(OrderColumn.class), propertyHolder, propertyData, entityBinder.getSecondaryTables(), mappings) : IndexColumn.buildColumnFromAnnotation(xProperty.getAnnotation(org.hibernate.annotations.IndexColumn.class), propertyHolder, propertyData, mappings);
                    CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), xProperty, !indexColumn.isImplicit(), xProperty.isAnnotationPresent(MapKeyType.class), mappings);
                    collectionBinder.setIndexColumn(indexColumn);
                    collectionBinder.setMapKey(xProperty.getAnnotation(MapKey.class));
                    collectionBinder.setPropertyName(propertyData.getPropertyName());
                    BatchSize batchSize = xProperty.getAnnotation(BatchSize.class);
                    collectionBinder.setBatchSize(batchSize);
                    OrderBy orderBy = xProperty.getAnnotation(OrderBy.class);
                    org.hibernate.annotations.OrderBy orderBy2 = xProperty.getAnnotation(org.hibernate.annotations.OrderBy.class);
                    collectionBinder.setEjb3OrderBy(orderBy);
                    collectionBinder.setSqlOrderBy(orderBy2);
                    Sort sort = xProperty.getAnnotation(Sort.class);
                    collectionBinder.setSort(sort);
                    Cache cache = xProperty.getAnnotation(Cache.class);
                    collectionBinder.setCache(cache);
                    collectionBinder.setPropertyHolder(propertyHolder);
                    Cascade cascade = xProperty.getAnnotation(Cascade.class);
                    NotFound notFound = xProperty.getAnnotation(NotFound.class);
                    boolean bl14 = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                    collectionBinder.setIgnoreNotFound(bl14);
                    collectionBinder.setCollectionType(propertyData.getProperty().getElementClass());
                    collectionBinder.setMappings(mappings);
                    collectionBinder.setAccessType(propertyData.getDefaultAccess());
                    boolean bl15 = xProperty.isAnnotationPresent(ElementCollection.class);
                    PropertyData propertyData3 = propertyData2 = bl15 ? propertyData : new WrappedInferredData(propertyData, "element");
                    if (xProperty.isAnnotationPresent(javax.persistence.Column.class) || xProperty.isAnnotationPresent(Formula.class)) {
                        object3 = xProperty.getAnnotation(javax.persistence.Column.class);
                        object2 = xProperty.getAnnotation(Formula.class);
                        ejb3ColumnArray2 = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{object3}, (Formula)object2, nullability, propertyHolder, propertyData2, entityBinder.getSecondaryTables(), mappings);
                    } else if (xProperty.isAnnotationPresent(Columns.class)) {
                        object3 = xProperty.getAnnotation(Columns.class);
                        ejb3ColumnArray2 = Ejb3Column.buildColumnFromAnnotation(object3.columns(), null, nullability, propertyHolder, propertyData2, entityBinder.getSecondaryTables(), mappings);
                    } else {
                        ejb3ColumnArray2 = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, propertyData2, entityBinder.getSecondaryTables(), mappings);
                    }
                    object3 = null;
                    object2 = null;
                    if (xProperty.isAnnotationPresent(MapKeyColumn.class)) {
                        object2 = Boolean.TRUE;
                        object3 = new javax.persistence.Column[]{new MapKeyColumnDelegator(xProperty.getAnnotation(MapKeyColumn.class))};
                    }
                    if (object2 == null) {
                        object2 = Boolean.TRUE;
                    }
                    object3 = object3 != null && ((Annotation)object3).length > 0 ? object3 : null;
                    Object object4 = new WrappedInferredData(propertyData, "mapkey");
                    Ejb3Column[] ejb3ColumnArray3 = Ejb3Column.buildColumnFromAnnotation((javax.persistence.Column[])object3, null, Nullability.FORCED_NOT_NULL, propertyHolder, (PropertyData)(((Boolean)object2).booleanValue() ? propertyData : object4), ((Boolean)object2).booleanValue() ? "_KEY" : null, entityBinder.getSecondaryTables(), mappings);
                    collectionBinder.setMapKeyColumns(ejb3ColumnArray3);
                    object3 = null;
                    object2 = null;
                    if (xProperty.isAnnotationPresent(MapKeyJoinColumns.class)) {
                        object2 = Boolean.TRUE;
                        object4 = xProperty.getAnnotation(MapKeyJoinColumns.class).value();
                        object3 = new JoinColumn[((MapKeyJoinColumn[])object4).length];
                        int n = 0;
                        for (Object object5 : object4) {
                            object3[n] = new MapKeyJoinColumnDelegator((MapKeyJoinColumn)object5);
                            ++n;
                        }
                        if (xProperty.isAnnotationPresent(MapKeyJoinColumn.class)) {
                            throw new AnnotationException("@MapKeyJoinColumn and @MapKeyJoinColumns used on the same property: " + BinderHelper.getPath(propertyHolder, propertyData));
                        }
                    } else if (xProperty.isAnnotationPresent(MapKeyJoinColumn.class)) {
                        object2 = Boolean.TRUE;
                        object3 = new JoinColumn[]{new MapKeyJoinColumnDelegator(xProperty.getAnnotation(MapKeyJoinColumn.class))};
                    }
                    if (object2 == null) {
                        object2 = Boolean.TRUE;
                    }
                    object4 = new WrappedInferredData(propertyData, "mapkey");
                    Ejb3JoinColumn[] ejb3JoinColumnArray2 = Ejb3JoinColumn.buildJoinColumnsWithDefaultColumnSuffix((JoinColumn[])object3, null, entityBinder.getSecondaryTables(), propertyHolder, ((Boolean)object2).booleanValue() ? propertyData.getPropertyName() : object4.getPropertyName(), ((Boolean)object2).booleanValue() ? "_KEY" : null, mappings);
                    collectionBinder.setMapKeyManyToManyColumns(ejb3JoinColumnArray2);
                    collectionBinder.setEmbedded(xProperty.isAnnotationPresent(Embedded.class));
                    collectionBinder.setElementColumns(ejb3ColumnArray2);
                    collectionBinder.setProperty(xProperty);
                    if (oneToMany != null && manyToMany != null) {
                        throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + propertyData.getPropertyName());
                    }
                    object3 = null;
                    if (oneToMany != null) {
                        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                            if (!ejb3JoinColumn.isSecondary()) continue;
                            throw new NotYetImplementedException("Collections having FK in secondary table");
                        }
                        collectionBinder.setFkJoinColumns(ejb3JoinColumnArray);
                        object3 = oneToMany.mappedBy();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(oneToMany.targetEntity()));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToMany.cascade(), cascade, oneToMany.orphanRemoval(), false));
                        collectionBinder.setOneToMany(true);
                    } else if (elementCollection != null) {
                        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                            if (!ejb3JoinColumn.isSecondary()) continue;
                            throw new NotYetImplementedException("Collections having FK in secondary table");
                        }
                        collectionBinder.setFkJoinColumns(ejb3JoinColumnArray);
                        object3 = "";
                        object2 = elementCollection.targetClass();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(object2));
                        collectionBinder.setOneToMany(true);
                    } else if (manyToMany != null) {
                        object3 = manyToMany.mappedBy();
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(manyToMany.targetEntity()));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToMany.cascade(), cascade, false, false));
                        collectionBinder.setOneToMany(false);
                    } else if (xProperty.isAnnotationPresent(ManyToAny.class)) {
                        object3 = "";
                        collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(Void.TYPE));
                        collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(null, cascade, false, false));
                        collectionBinder.setOneToMany(false);
                    }
                    collectionBinder.setMappedBy((String)object3);
                    AnnotationBinder.bindJoinedTableAssociation(xProperty, mappings, entityBinder, collectionBinder, propertyHolder, propertyData, (String)object3);
                    object2 = xProperty.getAnnotation(OnDelete.class);
                    boolean bl16 = object2 != null && OnDeleteAction.CASCADE.equals((Object)object2.action());
                    collectionBinder.setCascadeDeleteEnabled(bl16);
                    if (bl) {
                        collectionBinder.setInsertable(false);
                        collectionBinder.setUpdatable(false);
                    }
                    if (xProperty.isAnnotationPresent(CollectionId.class)) {
                        HashMap hashMap2 = (HashMap)hashMap.clone();
                        hashMap2.putAll(AnnotationBinder.buildLocalGenerators(xProperty, mappings));
                        collectionBinder.setLocalGenerators(hashMap2);
                    }
                    collectionBinder.setInheritanceStatePerClass(map);
                    collectionBinder.setDeclaringClass(propertyData.getDeclaringClass());
                    collectionBinder.bind();
                } else if (!bl5 || !entityBinder.isIgnoreIdAnnotations()) {
                    Object object9;
                    Object object10;
                    boolean bl18 = false;
                    boolean bl19 = false;
                    if ((bl5 || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) && (object10 = BinderHelper.getPropertyOverriddenByMapperOrMapsId(bl5, propertyHolder, xProperty.getName(), mappings)) != null) {
                        bl19 = true;
                        object9 = map.get(object10.getClassOrElement());
                        if (object9 != null) {
                            bl18 = bl18 || ((InheritanceState)object9).hasIdClassOrEmbeddedId() != false;
                        }
                        ejb3ColumnArray = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(bl5);
                    }
                    boolean bl17 = bl18 = bl18 || xProperty.isAnnotationPresent(Embedded.class) || xProperty.isAnnotationPresent(EmbeddedId.class) || xClass.isAnnotationPresent(Embeddable.class);
                    if (bl18) {
                        object10 = null;
                        if (bl19) {
                            object9 = BinderHelper.getPropertyOverriddenByMapperOrMapsId(bl5, propertyHolder, xProperty.getName(), mappings);
                            object10 = object9.getClassOrElementName();
                        }
                        object9 = entityBinder.getPropertyAccessor(xProperty);
                        propertyBinder = AnnotationBinder.bindComponent(propertyData, propertyHolder, (AccessType)((Object)object9), entityBinder, bl, mappings, bl2, bl5, map, (String)object10, bl19 ? (Ejb3JoinColumn[])ejb3ColumnArray : null);
                    } else {
                        boolean bl21 = true;
                        boolean bl22 = false;
                        if (xProperty.isAnnotationPresent(Basic.class)) {
                            Basic object8 = xProperty.getAnnotation(Basic.class);
                            bl21 = object8.optional();
                            boolean bl20 = bl22 = object8.fetch() == FetchType.LAZY;
                        }
                        if (bl5 || !bl21 && nullability != Nullability.FORCED_NULL) {
                            for (Ejb3Column ejb3Column : ejb3ColumnArray) {
                                ejb3Column.forceNotNull();
                            }
                        }
                        propertyBinder.setLazy(bl22);
                        propertyBinder.setColumns(ejb3ColumnArray);
                        if (bl19) {
                            PropertyData propertyData4 = BinderHelper.getPropertyOverriddenByMapperOrMapsId(bl5, propertyHolder, xProperty.getName(), mappings);
                            propertyBinder.setReferencedEntityName(propertyData4.getClassOrElementName());
                        }
                        propertyBinder.makePropertyValueAndBind();
                    }
                    if (bl19) {
                        PropertyData propertyData4 = BinderHelper.getPropertyOverriddenByMapperOrMapsId(bl5, propertyHolder, xProperty.getName(), mappings);
                        HashMap hashMap3 = (HashMap)hashMap.clone();
                        IdGenerator idGenerator = new IdGenerator();
                        idGenerator.setIdentifierGeneratorStrategy("assigned");
                        idGenerator.setName("Hibernate-local--foreign generator");
                        idGenerator.setIdentifierGeneratorStrategy("foreign");
                        idGenerator.addParam("property", propertyData4.getPropertyName());
                        hashMap3.put(idGenerator.getName(), idGenerator);
                        BinderHelper.makeIdGenerator((SimpleValue)propertyBinder.getValue(), idGenerator.getIdentifierGeneratorStrategy(), idGenerator.getName(), mappings, hashMap3);
                    }
                    if (bl5) {
                        SimpleValue simpleValue = (SimpleValue)propertyBinder.getValue();
                        if (!bl19) {
                            AnnotationBinder.processId(propertyHolder, propertyData, simpleValue, hashMap, bl, mappings);
                        }
                    }
                }
            }
            object = xProperty.getAnnotation(Index.class);
            if (object != null) {
                if (ejb3JoinColumnArray != null) {
                    for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                        ejb3JoinColumn.addIndex((Index)object, bl3);
                    }
                } else if (ejb3ColumnArray != null) {
                    for (Ejb3Column ejb3Column : ejb3ColumnArray) {
                        ejb3Column.addIndex((Index)object, bl3);
                    }
                }
            }
            if ((naturalId = xProperty.getAnnotation(NaturalId.class)) == null) break block77;
            if (ejb3JoinColumnArray != null) {
                for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                    String string = "UK_" + Constraint.hashedName(ejb3JoinColumn.getTable().getName() + "_NaturalID");
                    ejb3JoinColumn.addUniqueKey(string, bl3);
                }
            } else {
                for (Ejb3Column ejb3Column : ejb3ColumnArray) {
                    String string = "UK_" + Constraint.hashedName(ejb3Column.getTable().getName() + "_NaturalID");
                    ejb3Column.addUniqueKey(string, bl3);
                }
            }
        }
    }

    private static void setVersionInformation(XProperty xProperty, PropertyBinder propertyBinder) {
        propertyBinder.getSimpleValueBinder().setVersion(true);
        if (xProperty.isAnnotationPresent(Source.class)) {
            Source source = xProperty.getAnnotation(Source.class);
            propertyBinder.getSimpleValueBinder().setTimestampVersionType(source.value().typeName());
        }
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData propertyData, SimpleValue simpleValue, HashMap<String, IdGenerator> hashMap, boolean bl, Mappings mappings) {
        String string;
        if (bl) {
            throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId properties: " + BinderHelper.getPath(propertyHolder, propertyData));
        }
        XClass xClass = propertyData.getClassOrElement();
        XProperty xProperty = propertyData.getProperty();
        HashMap hashMap2 = (HashMap)hashMap.clone();
        hashMap2.putAll(AnnotationBinder.buildLocalGenerators(xProperty, mappings));
        boolean bl2 = xClass.isAnnotationPresent(Embeddable.class) || xProperty.isAnnotationPresent(EmbeddedId.class);
        GeneratedValue generatedValue = xProperty.getAnnotation(GeneratedValue.class);
        String string2 = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy(), mappings) : "assigned";
        String string3 = string = generatedValue != null ? generatedValue.generator() : "";
        if (bl2) {
            string2 = "assigned";
        }
        BinderHelper.makeIdGenerator(simpleValue, string2, string, mappings, hashMap2);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Bind {0} on {1}", (Object)(bl2 ? "@EmbeddedId" : "@Id"), (Object)propertyData.getPropertyName());
        }
    }

    private static void bindJoinedTableAssociation(XProperty xProperty, Mappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData propertyData, String string) {
        JoinColumn[] joinColumnArray;
        JoinColumn[] joinColumnArray2;
        Ejb3JoinColumn[] ejb3JoinColumnArray;
        Ejb3JoinColumn[] ejb3JoinColumnArray2;
        TableBinder tableBinder = new TableBinder();
        JoinTable joinTable = propertyHolder.getJoinTable(xProperty);
        CollectionTable collectionTable = xProperty.getAnnotation(CollectionTable.class);
        if (joinTable != null || collectionTable != null) {
            JoinColumn[] joinColumnArray3;
            JoinColumn[] joinColumnArray4;
            UniqueConstraint[] uniqueConstraintArray;
            String string2;
            if (collectionTable != null) {
                ejb3JoinColumnArray2 = collectionTable.catalog();
                ejb3JoinColumnArray = collectionTable.schema();
                string2 = collectionTable.name();
                uniqueConstraintArray = collectionTable.uniqueConstraints();
                joinColumnArray4 = collectionTable.joinColumns();
                joinColumnArray3 = null;
            } else {
                ejb3JoinColumnArray2 = joinTable.catalog();
                ejb3JoinColumnArray = joinTable.schema();
                string2 = joinTable.name();
                uniqueConstraintArray = joinTable.uniqueConstraints();
                joinColumnArray4 = joinTable.joinColumns();
                joinColumnArray3 = joinTable.inverseJoinColumns();
            }
            collectionBinder.setExplicitAssociationTable(true);
            if (!BinderHelper.isEmptyAnnotationValue((String)ejb3JoinColumnArray)) {
                tableBinder.setSchema((String)ejb3JoinColumnArray);
            }
            if (!BinderHelper.isEmptyAnnotationValue((String)ejb3JoinColumnArray2)) {
                tableBinder.setCatalog((String)ejb3JoinColumnArray2);
            }
            if (!BinderHelper.isEmptyAnnotationValue(string2)) {
                tableBinder.setName(string2);
            }
            tableBinder.setUniqueConstraints(uniqueConstraintArray);
            joinColumnArray2 = joinColumnArray4.length == 0 ? null : joinColumnArray4;
            joinColumnArray = joinColumnArray3 == null || joinColumnArray3.length == 0 ? null : joinColumnArray3;
        } else {
            joinColumnArray2 = null;
            joinColumnArray = null;
        }
        ejb3JoinColumnArray2 = Ejb3JoinColumn.buildJoinTableJoinColumns(joinColumnArray2, entityBinder.getSecondaryTables(), propertyHolder, propertyData.getPropertyName(), string, mappings);
        ejb3JoinColumnArray = Ejb3JoinColumn.buildJoinTableJoinColumns(joinColumnArray, entityBinder.getSecondaryTables(), propertyHolder, propertyData.getPropertyName(), string, mappings);
        tableBinder.setMappings(mappings);
        collectionBinder.setTableBinder(tableBinder);
        collectionBinder.setJoinColumns(ejb3JoinColumnArray2);
        collectionBinder.setInverseJoinColumns(ejb3JoinColumnArray);
    }

    private static PropertyBinder bindComponent(PropertyData propertyData, PropertyHolder propertyHolder, AccessType accessType, EntityBinder entityBinder, boolean bl, Mappings mappings, boolean bl2, boolean bl3, Map<XClass, InheritanceState> map, String string, Ejb3JoinColumn[] ejb3JoinColumnArray) {
        Object object;
        Component component;
        if (string != null) {
            component = AnnotationBinder.createComponent(propertyHolder, propertyData, bl2, bl, mappings);
            object = new CopyIdentifierComponentSecondPass(component, string, ejb3JoinColumnArray, mappings);
            mappings.addSecondPass((SecondPass)object);
        } else {
            component = AnnotationBinder.fillComponent(propertyHolder, propertyData, accessType, !bl3, entityBinder, bl2, bl, false, mappings, map);
        }
        if (bl3) {
            component.setKey(true);
            if (propertyHolder.getPersistentClass().getIdentifier() != null) {
                throw new AnnotationException(component.getComponentClassName() + " must not have @Id properties when used as an @EmbeddedId: " + BinderHelper.getPath(propertyHolder, propertyData));
            }
            if (string == null && component.getPropertySpan() == 0) {
                throw new AnnotationException(component.getComponentClassName() + " has no persistent id property: " + BinderHelper.getPath(propertyHolder, propertyData));
            }
        }
        object = propertyData.getProperty();
        AnnotationBinder.setupComponentTuplizer((XProperty)object, component);
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(propertyData.getPropertyName());
        propertyBinder.setValue(component);
        propertyBinder.setProperty(propertyData.getProperty());
        propertyBinder.setAccessType(propertyData.getDefaultAccess());
        propertyBinder.setEmbedded(bl2);
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setId(bl3);
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(map);
        propertyBinder.setMappings(mappings);
        propertyBinder.makePropertyAndBind();
        return propertyBinder;
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData propertyData, AccessType accessType, boolean bl, EntityBinder entityBinder, boolean bl2, boolean bl3, boolean bl4, Mappings mappings, Map<XClass, InheritanceState> map) {
        return AnnotationBinder.fillComponent(propertyHolder, propertyData, null, accessType, bl, entityBinder, bl2, bl3, bl4, mappings, map);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData propertyData, PropertyData propertyData2, AccessType accessType, boolean bl, EntityBinder entityBinder, boolean bl2, boolean bl3, boolean bl4, Mappings mappings, Map<XClass, InheritanceState> map) {
        Object object;
        Object object2;
        PropertyContainer propertyContainer;
        Component component = AnnotationBinder.createComponent(propertyHolder, propertyData, bl2, bl3, mappings);
        String string = BinderHelper.getPath(propertyHolder, propertyData);
        LOG.tracev("Binding component with path: {0}", (Object)string);
        PropertyHolder propertyHolder2 = PropertyHolderBuilder.buildPropertyHolder(component, string, propertyData, propertyHolder, mappings);
        XClass xClass = propertyData.getPropertyClass();
        ArrayList<PropertyData> arrayList = new ArrayList<PropertyData>();
        XClass xClass2 = propertyData.getClassOrElement();
        ArrayList<PropertyData> arrayList2 = null;
        HashMap<String, PropertyData> hashMap = new HashMap<String, PropertyData>();
        if (propertyData2 != null) {
            arrayList2 = new ArrayList<PropertyData>();
            XClass xClass3 = propertyData2.getClassOrElement();
            AnnotationBinder.bindTypeDefs(xClass3, mappings);
            propertyContainer = new PropertyContainer(xClass3, xClass);
            AnnotationBinder.addElementsOfClass(arrayList2, accessType, propertyContainer, mappings);
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                PropertyData propertyData3 = (PropertyData)object2.next();
                hashMap.put(propertyData3.getPropertyName(), propertyData3);
            }
        }
        AnnotationBinder.bindTypeDefs(xClass2, mappings);
        propertyContainer = new PropertyContainer(xClass2, xClass);
        AnnotationBinder.addElementsOfClass(arrayList, accessType, propertyContainer, mappings);
        for (object2 = xClass.getSuperclass(); object2 != null && object2.isAnnotationPresent(MappedSuperclass.class); object2 = object2.getSuperclass()) {
            propertyContainer = new PropertyContainer((XClass)object2, xClass);
            AnnotationBinder.addElementsOfClass(arrayList, accessType, propertyContainer, mappings);
        }
        if (arrayList2 != null && !AnnotationBinder.hasAnnotationsOnIdClass(xClass)) {
            for (int i = 0; i < arrayList.size(); ++i) {
                PropertyData propertyData4 = (PropertyData)arrayList.get(i);
                object = (PropertyData)hashMap.get(propertyData4.getPropertyName());
                if (propertyHolder.isInIdClass()) {
                    boolean bl5;
                    if (object == null) {
                        throw new AnnotationException("Property of @IdClass not found in entity " + propertyData2.getPropertyClass().getName() + ": " + propertyData4.getPropertyName());
                    }
                    boolean bl6 = object.getProperty().isAnnotationPresent(ManyToOne.class) || object.getProperty().isAnnotationPresent(OneToOne.class);
                    boolean bl7 = bl5 = !object.getClassOrElement().equals(propertyData4.getClassOrElement());
                    if (bl6 && bl5) continue;
                    arrayList.set(i, (PropertyData)object);
                    continue;
                }
                arrayList.set(i, (PropertyData)object);
            }
        }
        for (PropertyData propertyData4 : arrayList) {
            AnnotationBinder.processElementAnnotations(propertyHolder2, bl ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyData4, new HashMap<String, IdGenerator>(), entityBinder, bl3, bl2, bl4, mappings, map);
            object = propertyData4.getProperty();
            if (!object.isAnnotationPresent(GeneratedValue.class) || !object.isAnnotationPresent(Id.class)) continue;
            HashMap<String, IdGenerator> hashMap2 = new HashMap<String, IdGenerator>();
            hashMap2.putAll(AnnotationBinder.buildLocalGenerators((XAnnotatedElement)object, mappings));
            GeneratedValue generatedValue = object.getAnnotation(GeneratedValue.class);
            String string2 = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy(), mappings) : "assigned";
            String string3 = generatedValue != null ? generatedValue.generator() : "";
            BinderHelper.makeIdGenerator((SimpleValue)component.getProperty(object.getName()).getValue(), string2, string3, mappings, hashMap2);
        }
        return component;
    }

    public static Component createComponent(PropertyHolder propertyHolder, PropertyData propertyData, boolean bl, boolean bl2, Mappings mappings) {
        Component component = new Component(mappings, propertyHolder.getPersistentClass());
        component.setEmbedded(bl);
        component.setTable(propertyHolder.getTable());
        if (bl2 || bl && propertyData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
        } else {
            component.setComponentClassName(propertyData.getClassOrElementName());
        }
        component.setNodeName(propertyData.getPropertyName());
        return component;
    }

    private static void bindIdClass(String string, String string2, PropertyData propertyData, PropertyData propertyData2, Ejb3Column[] ejb3ColumnArray, PropertyHolder propertyHolder, boolean bl, AccessType accessType, EntityBinder entityBinder, boolean bl2, boolean bl3, Mappings mappings, Map<XClass, InheritanceState> map) {
        Object object;
        Object object2;
        SimpleValue simpleValue;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String string3 = rootClass.getClassName();
        String string4 = propertyData.getPropertyName();
        HashMap<String, IdGenerator> hashMap = new HashMap<String, IdGenerator>();
        if (bl) {
            simpleValue = AnnotationBinder.fillComponent(propertyHolder, propertyData, propertyData2, accessType, false, entityBinder, bl2, bl3, false, mappings, map);
            object2 = simpleValue;
            ((Component)object2).setKey(true);
            if (rootClass.getIdentifier() != null) {
                throw new AnnotationException(((Component)object2).getComponentClassName() + " must not have @Id properties when used as an @EmbeddedId");
            }
            if (((Component)object2).getPropertySpan() == 0) {
                throw new AnnotationException(((Component)object2).getComponentClassName() + " has no persistent id property");
            }
            object = propertyData.getProperty();
            AnnotationBinder.setupComponentTuplizer((XProperty)object, (Component)object2);
        } else {
            for (Ejb3Column ejb3Column : ejb3ColumnArray) {
                ejb3Column.forceNotNull();
            }
            object2 = new SimpleValueBinder();
            ((SimpleValueBinder)object2).setPropertyName(string4);
            ((SimpleValueBinder)object2).setReturnedClassName(propertyData.getTypeName());
            ((SimpleValueBinder)object2).setColumns(ejb3ColumnArray);
            ((SimpleValueBinder)object2).setPersistentClassName(string3);
            ((SimpleValueBinder)object2).setMappings(mappings);
            ((SimpleValueBinder)object2).setType(propertyData.getProperty(), propertyData.getClassOrElement(), string3);
            ((SimpleValueBinder)object2).setAccessType(accessType);
            simpleValue = ((SimpleValueBinder)object2).make();
        }
        rootClass.setIdentifier(simpleValue);
        BinderHelper.makeIdGenerator(simpleValue, string, string2, mappings, hashMap);
        if (bl2) {
            rootClass.setEmbeddedIdentifier(propertyData.getPropertyClass() == null);
        } else {
            object2 = new PropertyBinder();
            ((PropertyBinder)object2).setName(string4);
            ((PropertyBinder)object2).setValue(simpleValue);
            ((PropertyBinder)object2).setAccessType(propertyData.getDefaultAccess());
            ((PropertyBinder)object2).setProperty(propertyData.getProperty());
            object = ((PropertyBinder)object2).makeProperty();
            rootClass.setIdentifierProperty((Property)object);
            org.hibernate.mapping.MappedSuperclass mappedSuperclass = BinderHelper.getMappedSuperclassOrNull(propertyData.getDeclaringClass(), map, mappings);
            if (mappedSuperclass != null) {
                mappedSuperclass.setDeclaredIdentifierProperty((Property)object);
            } else {
                rootClass.setDeclaredIdentifierProperty((Property)object);
            }
        }
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData propertyData, PropertyData propertyData2, AccessType accessType, Mappings mappings) {
        ArrayList<PropertyData> arrayList = new ArrayList<PropertyData>();
        XClass xClass = propertyData2.getClassOrElement();
        PropertyContainer propertyContainer = new PropertyContainer(xClass, propertyData.getPropertyClass());
        AnnotationBinder.addElementsOfClass(arrayList, accessType, propertyContainer, mappings);
        return (PropertyData)arrayList.get(0);
    }

    private static void setupComponentTuplizer(XProperty xProperty, Component component) {
        if (xProperty == null) {
            return;
        }
        if (xProperty.isAnnotationPresent(Tuplizers.class)) {
            for (Tuplizer tuplizer : xProperty.getAnnotation(Tuplizers.class).value()) {
                EntityMode entityMode = EntityMode.parse(tuplizer.entityMode());
                component.addTuplizer(entityMode, tuplizer.impl().getName());
            }
        }
        if (xProperty.isAnnotationPresent(Tuplizer.class)) {
            Tuplizer tuplizer = xProperty.getAnnotation(Tuplizer.class);
            EntityMode entityMode = EntityMode.parse(tuplizer.entityMode());
            component.addTuplizer(entityMode, tuplizer.impl().getName());
        }
    }

    private static void bindManyToOne(String string, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, boolean bl2, boolean bl3, XClass xClass, PropertyHolder propertyHolder, PropertyData propertyData, boolean bl4, boolean bl5, boolean bl6, PropertyBinder propertyBinder, Mappings mappings) {
        String string2;
        Object object;
        org.hibernate.mapping.ManyToOne manyToOne = new org.hibernate.mapping.ManyToOne(mappings, ejb3JoinColumnArray[0].getTable());
        if (bl4) {
            manyToOne.markAsLogicalOneToOne();
        }
        manyToOne.setReferencedEntityName(ToOneBinder.getReferenceEntityName(propertyData, xClass, mappings));
        XProperty xProperty = propertyData.getProperty();
        AnnotationBinder.defineFetchingStrategy(manyToOne, xProperty);
        manyToOne.setIgnoreNotFound(bl2);
        manyToOne.setCascadeDeleteEnabled(bl3);
        if (!bl) {
            for (Ejb3JoinColumn object22 : ejb3JoinColumnArray) {
                object22.setNullable(false);
            }
        }
        if (xProperty.isAnnotationPresent(MapsId.class)) {
            for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                ejb3JoinColumn.setInsertable(false);
                ejb3JoinColumn.setUpdatable(false);
            }
        }
        boolean bl7 = false;
        if (mappings.isSpecjProprietarySyntaxEnabled()) {
            String string22 = "";
            for (XProperty xProperty2 : propertyData.getDeclaringClass().getDeclaredProperties(AccessType.FIELD.getType())) {
                if (xProperty2.isAnnotationPresent(Id.class) && xProperty2.isAnnotationPresent(javax.persistence.Column.class)) {
                    string22 = xProperty2.getAnnotation(javax.persistence.Column.class).name();
                }
                object = xProperty.getAnnotation(JoinColumn.class);
                if (!xProperty.isAnnotationPresent(ManyToOne.class) || object == null || BinderHelper.isEmptyAnnotationValue(object.name()) || !object.name().equals(string22) || xProperty.isAnnotationPresent(MapsId.class)) continue;
                bl7 = true;
                for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                    ejb3JoinColumn.setInsertable(false);
                    ejb3JoinColumn.setUpdatable(false);
                }
            }
        }
        manyToOne.setTypeName(propertyData.getClassOrElementName());
        String string3 = propertyData.getPropertyName();
        manyToOne.setTypeUsingReflection(propertyHolder.getClassName(), string3);
        ForeignKey foreignKey = xProperty.getAnnotation(ForeignKey.class);
        String string4 = string2 = foreignKey != null ? foreignKey.name() : "";
        if (!BinderHelper.isEmptyAnnotationValue(string2)) {
            manyToOne.setForeignKeyName(string2);
        }
        object = propertyHolder.getPath() + "." + string3;
        ToOneFkSecondPass toOneFkSecondPass = new ToOneFkSecondPass(manyToOne, ejb3JoinColumnArray, !bl && bl4, propertyHolder.getEntityOwnerClassName(), (String)object, mappings);
        if (bl6) {
            toOneFkSecondPass.doSecondPass(mappings.getClasses());
        } else {
            mappings.addSecondPass(toOneFkSecondPass);
        }
        Ejb3Column.checkPropertyConsistency(ejb3JoinColumnArray, propertyHolder.getEntityName() + string3);
        propertyBinder.setName(string3);
        propertyBinder.setValue(manyToOne);
        if (bl5) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else if (bl7) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else {
            propertyBinder.setInsertable(ejb3JoinColumnArray[0].isInsertable());
            propertyBinder.setUpdatable(ejb3JoinColumnArray[0].isUpdatable());
        }
        propertyBinder.setColumns(ejb3JoinColumnArray);
        propertyBinder.setAccessType(propertyData.getDefaultAccess());
        propertyBinder.setCascade(string);
        propertyBinder.setProperty(xProperty);
        propertyBinder.setXToMany(true);
        propertyBinder.makePropertyAndBind();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void defineFetchingStrategy(ToOne toOne, XProperty xProperty) {
        FetchType fetchType;
        LazyToOne lazyToOne = xProperty.getAnnotation(LazyToOne.class);
        Fetch fetch = xProperty.getAnnotation(Fetch.class);
        ManyToOne manyToOne = xProperty.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = xProperty.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            fetchType = manyToOne.fetch();
        } else {
            if (oneToOne == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
            fetchType = oneToOne.fetch();
        }
        if (lazyToOne != null) {
            toOne.setLazy(lazyToOne.value() != LazyToOneOption.FALSE);
            toOne.setUnwrapProxy(lazyToOne.value() == LazyToOneOption.NO_PROXY);
        } else {
            toOne.setLazy(fetchType == FetchType.LAZY);
            toOne.setUnwrapProxy(false);
        }
        if (fetch == null) {
            toOne.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
            toOne.setFetchMode(FetchMode.JOIN);
            toOne.setLazy(false);
            toOne.setUnwrapProxy(false);
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
            toOne.setFetchMode(FetchMode.SELECT);
            return;
        }
        if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
        throw new AnnotationException("Use of FetchMode.SUBSELECT not allowed on ToOne associations");
    }

    private static void bindOneToOne(String string, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, FetchMode fetchMode, boolean bl2, boolean bl3, XClass xClass, PropertyHolder propertyHolder, PropertyData propertyData, String string2, boolean bl4, boolean bl5, boolean bl6, PropertyBinder propertyBinder, Mappings mappings) {
        Serializable serializable;
        String string3 = propertyData.getPropertyName();
        LOG.tracev("Fetching {0} with {1}", (Object)string3, (Object)fetchMode);
        boolean bl7 = true;
        if (!bl4) {
            serializable = propertyHolder.getIdentifier();
            if (serializable == null) {
                bl7 = false;
            } else {
                Iterator iterator = serializable.getColumnIterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (serializable.getColumnSpan() != ejb3JoinColumnArray.length) {
                    bl7 = false;
                } else {
                    while (iterator.hasNext()) {
                        Column column = (Column)iterator.next();
                        arrayList.add(column.getName());
                    }
                    for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                        if (arrayList.contains(ejb3JoinColumn.getMappingColumn().getName())) continue;
                        bl7 = false;
                        break;
                    }
                }
            }
        }
        if (bl4 || bl7 || !BinderHelper.isEmptyAnnotationValue(string2)) {
            serializable = new OneToOneSecondPass(string2, propertyHolder.getEntityName(), string3, propertyHolder, propertyData, xClass, bl2, bl3, bl, string, ejb3JoinColumnArray, mappings);
            if (bl6) {
                ((OneToOneSecondPass)serializable).doSecondPass(mappings.getClasses());
            } else {
                mappings.addSecondPass((SecondPass)serializable, BinderHelper.isEmptyAnnotationValue(string2));
            }
        } else {
            AnnotationBinder.bindManyToOne(string, ejb3JoinColumnArray, bl, bl2, bl3, xClass, propertyHolder, propertyData, true, bl5, bl6, propertyBinder, mappings);
        }
    }

    private static void bindAny(String string, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, Nullability nullability, PropertyHolder propertyHolder, PropertyData propertyData, EntityBinder entityBinder, boolean bl2, Mappings mappings) {
        Any any = propertyData.getProperty().getAnnotation(Any.class);
        if (any == null) {
            throw new AssertionFailure("Missing @Any annotation: " + BinderHelper.getPath(propertyHolder, propertyData));
        }
        org.hibernate.mapping.Any any2 = BinderHelper.buildAnyValue(any.metaDef(), ejb3JoinColumnArray, any.metaColumn(), propertyData, bl, nullability, propertyHolder, entityBinder, any.optional(), mappings);
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(propertyData.getPropertyName());
        propertyBinder.setValue(any2);
        propertyBinder.setLazy(any.fetch() == FetchType.LAZY);
        if (bl2) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else {
            propertyBinder.setInsertable(ejb3JoinColumnArray[0].isInsertable());
            propertyBinder.setUpdatable(ejb3JoinColumnArray[0].isUpdatable());
        }
        propertyBinder.setAccessType(propertyData.getDefaultAccess());
        propertyBinder.setCascade(string);
        Property property = propertyBinder.makeProperty();
        propertyHolder.addProperty(property, ejb3JoinColumnArray, propertyData.getDeclaringClass());
    }

    private static String generatorType(GenerationType generationType, Mappings mappings) {
        boolean bl = mappings.useNewGeneratorMappings();
        switch (generationType) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return bl ? SequenceStyleGenerator.class.getName() : "native";
            }
            case TABLE: {
                return bl ? TableGenerator.class.getName() : MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return bl ? SequenceStyleGenerator.class.getName() : "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + (Object)((Object)generationType));
    }

    private static EnumSet<CascadeType> convertToHibernateCascadeType(javax.persistence.CascadeType[] cascadeTypeArray) {
        EnumSet<CascadeType> enumSet = EnumSet.noneOf(CascadeType.class);
        if (cascadeTypeArray != null && cascadeTypeArray.length > 0) {
            block8: for (javax.persistence.CascadeType cascadeType : cascadeTypeArray) {
                switch (cascadeType) {
                    case ALL: {
                        enumSet.add(CascadeType.ALL);
                        continue block8;
                    }
                    case PERSIST: {
                        enumSet.add(CascadeType.PERSIST);
                        continue block8;
                    }
                    case MERGE: {
                        enumSet.add(CascadeType.MERGE);
                        continue block8;
                    }
                    case REMOVE: {
                        enumSet.add(CascadeType.REMOVE);
                        continue block8;
                    }
                    case REFRESH: {
                        enumSet.add(CascadeType.REFRESH);
                        continue block8;
                    }
                    case DETACH: {
                        enumSet.add(CascadeType.DETACH);
                    }
                }
            }
        }
        return enumSet;
    }

    private static String getCascadeStrategy(javax.persistence.CascadeType[] cascadeTypeArray, Cascade cascade, boolean bl, boolean bl2) {
        CascadeType[] cascadeTypeArray2;
        EnumSet<CascadeType> enumSet = AnnotationBinder.convertToHibernateCascadeType(cascadeTypeArray);
        CascadeType[] cascadeTypeArray3 = cascadeTypeArray2 = cascade == null ? null : cascade.value();
        if (cascadeTypeArray2 != null && cascadeTypeArray2.length > 0) {
            enumSet.addAll(Arrays.asList(cascadeTypeArray2));
        }
        if (bl) {
            enumSet.add(CascadeType.DELETE_ORPHAN);
            enumSet.add(CascadeType.REMOVE);
        }
        if (bl2) {
            enumSet.add(CascadeType.PERSIST);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CascadeType cascadeType : enumSet) {
            switch (cascadeType) {
                case ALL: {
                    stringBuilder.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    stringBuilder.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    stringBuilder.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    stringBuilder.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    stringBuilder.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    stringBuilder.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    stringBuilder.append(",").append("replicate");
                    break;
                }
                case EVICT: 
                case DETACH: {
                    stringBuilder.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    stringBuilder.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    stringBuilder.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    stringBuilder.append(",").append("delete");
                }
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.substring(1) : "none";
    }

    public static FetchMode getFetchMode(FetchType fetchType) {
        if (fetchType == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        IdGenerator idGenerator;
        HashMap<String, IdGenerator> hashMap = new HashMap<String, IdGenerator>();
        javax.persistence.TableGenerator tableGenerator = xAnnotatedElement.getAnnotation(javax.persistence.TableGenerator.class);
        SequenceGenerator sequenceGenerator = xAnnotatedElement.getAnnotation(SequenceGenerator.class);
        GenericGenerator genericGenerator = xAnnotatedElement.getAnnotation(GenericGenerator.class);
        if (tableGenerator != null) {
            idGenerator = AnnotationBinder.buildIdGenerator(tableGenerator, mappings);
            hashMap.put(idGenerator.getName(), idGenerator);
        }
        if (sequenceGenerator != null) {
            idGenerator = AnnotationBinder.buildIdGenerator(sequenceGenerator, mappings);
            hashMap.put(idGenerator.getName(), idGenerator);
        }
        if (genericGenerator != null) {
            idGenerator = AnnotationBinder.buildIdGenerator(genericGenerator, mappings);
            hashMap.put(idGenerator.getName(), idGenerator);
        }
        return hashMap;
    }

    public static boolean isDefault(XClass xClass, Mappings mappings) {
        return mappings.getReflectionManager().equals(xClass, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> list, Mappings mappings) {
        ReflectionManager reflectionManager = mappings.getReflectionManager();
        HashMap<XClass, InheritanceState> hashMap = new HashMap<XClass, InheritanceState>(list.size());
        for (XClass xClass : list) {
            InheritanceState inheritanceState = InheritanceState.getSuperclassInheritanceState(xClass, hashMap);
            InheritanceState inheritanceState2 = new InheritanceState(xClass, hashMap, mappings);
            if (inheritanceState != null) {
                boolean bl;
                inheritanceState.setHasSiblings(true);
                InheritanceState inheritanceState3 = InheritanceState.getInheritanceStateOfSuperEntity(xClass, hashMap);
                inheritanceState2.setHasParents(inheritanceState3 != null);
                boolean bl2 = bl = inheritanceState2.getType() != null && !InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState2.getType());
                if (inheritanceState.getType() != null) {
                    boolean bl3;
                    boolean bl4 = bl3 = inheritanceState2.getType() != null && !inheritanceState2.getType().equals((Object)inheritanceState.getType());
                    if (bl && bl3) {
                        LOG.invalidSubStrategy(xClass.getName());
                    }
                    inheritanceState2.setType(inheritanceState.getType());
                }
            }
            hashMap.put(xClass, inheritanceState2);
        }
        return hashMap;
    }

    private static boolean hasAnnotationsOnIdClass(XClass xClass) {
        List<XProperty> list = xClass.getDeclaredProperties("field");
        for (XProperty object2 : list) {
            if (!object2.isAnnotationPresent(javax.persistence.Column.class) && !object2.isAnnotationPresent(OneToMany.class) && !object2.isAnnotationPresent(ManyToOne.class) && !object2.isAnnotationPresent(Id.class) && !object2.isAnnotationPresent(GeneratedValue.class) && !object2.isAnnotationPresent(OneToOne.class) && !object2.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        List<XMethod> list2 = xClass.getDeclaredMethods();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            XMethod xMethod = (XMethod)iterator.next();
            if (!xMethod.isAnnotationPresent(javax.persistence.Column.class) && !xMethod.isAnnotationPresent(OneToMany.class) && !xMethod.isAnnotationPresent(ManyToOne.class) && !xMethod.isAnnotationPresent(Id.class) && !xMethod.isAnnotationPresent(GeneratedValue.class) && !xMethod.isAnnotationPresent(OneToOne.class) && !xMethod.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalCacheAnnotationImpl
    implements Cache {
        private final String region;
        private final CacheConcurrencyStrategy usage;

        private LocalCacheAnnotationImpl(String string, CacheConcurrencyStrategy cacheConcurrencyStrategy) {
            this.region = string;
            this.usage = cacheConcurrencyStrategy;
        }

        @Override
        public CacheConcurrencyStrategy usage() {
            return this.usage;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public String include() {
            return "all";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Cache.class;
        }
    }
}

