/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MappedSuperclass;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.internal.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyHolder
implements PropertyHolder {
    protected AbstractPropertyHolder parent;
    private Map<String, Column[]> holderColumnOverride;
    private Map<String, Column[]> currentPropertyColumnOverride;
    private Map<String, JoinColumn[]> holderJoinColumnOverride;
    private Map<String, JoinColumn[]> currentPropertyJoinColumnOverride;
    private Map<String, JoinTable> holderJoinTableOverride;
    private Map<String, JoinTable> currentPropertyJoinTableOverride;
    private String path;
    private Mappings mappings;
    private Boolean isInIdClass;

    public AbstractPropertyHolder(String string, PropertyHolder propertyHolder, XClass xClass, Mappings mappings) {
        this.path = string;
        this.parent = (AbstractPropertyHolder)propertyHolder;
        this.mappings = mappings;
        this.buildHierarchyColumnOverride(xClass);
    }

    @Override
    public boolean isInIdClass() {
        return this.isInIdClass != null ? this.isInIdClass : (this.parent != null ? this.parent.isInIdClass() : false);
    }

    @Override
    public void setInIdClass(Boolean bl) {
        this.isInIdClass = bl;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected Mappings getMappings() {
        return this.mappings;
    }

    protected void setCurrentProperty(XProperty xProperty) {
        if (xProperty == null) {
            this.currentPropertyColumnOverride = null;
            this.currentPropertyJoinColumnOverride = null;
            this.currentPropertyJoinTableOverride = null;
        } else {
            this.currentPropertyColumnOverride = AbstractPropertyHolder.buildColumnOverride(xProperty, this.getPath());
            if (this.currentPropertyColumnOverride.size() == 0) {
                this.currentPropertyColumnOverride = null;
            }
            this.currentPropertyJoinColumnOverride = AbstractPropertyHolder.buildJoinColumnOverride(xProperty, this.getPath());
            if (this.currentPropertyJoinColumnOverride.size() == 0) {
                this.currentPropertyJoinColumnOverride = null;
            }
            this.currentPropertyJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride(xProperty, this.getPath());
            if (this.currentPropertyJoinTableOverride.size() == 0) {
                this.currentPropertyJoinTableOverride = null;
            }
        }
    }

    @Override
    public Column[] getOverriddenColumn(String string) {
        Column[] columnArray = this.getExactOverriddenColumn(string);
        if (columnArray == null && columnArray == null && string.contains(".collection&&element.")) {
            columnArray = this.getExactOverriddenColumn(string.replace(".collection&&element.", "."));
        }
        return columnArray;
    }

    private Column[] getExactOverriddenColumn(String string) {
        Column[] columnArray = null;
        if (this.parent != null) {
            columnArray = this.parent.getExactOverriddenColumn(string);
        }
        if (columnArray == null && this.currentPropertyColumnOverride != null) {
            columnArray = this.currentPropertyColumnOverride.get(string);
        }
        if (columnArray == null && this.holderColumnOverride != null) {
            columnArray = this.holderColumnOverride.get(string);
        }
        return columnArray;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String string) {
        JoinColumn[] joinColumnArray = this.getExactOverriddenJoinColumn(string);
        if (joinColumnArray == null && string.contains(".collection&&element.")) {
            joinColumnArray = this.getExactOverriddenJoinColumn(string.replace(".collection&&element.", "."));
        }
        return joinColumnArray;
    }

    private JoinColumn[] getExactOverriddenJoinColumn(String string) {
        JoinColumn[] joinColumnArray = null;
        if (this.parent != null) {
            joinColumnArray = this.parent.getExactOverriddenJoinColumn(string);
        }
        if (joinColumnArray == null && this.currentPropertyJoinColumnOverride != null) {
            joinColumnArray = this.currentPropertyJoinColumnOverride.get(string);
        }
        if (joinColumnArray == null && this.holderJoinColumnOverride != null) {
            joinColumnArray = this.holderJoinColumnOverride.get(string);
        }
        return joinColumnArray;
    }

    @Override
    public JoinTable getJoinTable(XProperty xProperty) {
        String string = StringHelper.qualify(this.getPath(), xProperty.getName());
        JoinTable joinTable = this.getOverriddenJoinTable(string);
        if (joinTable == null) {
            joinTable = xProperty.getAnnotation(JoinTable.class);
        }
        return joinTable;
    }

    public JoinTable getOverriddenJoinTable(String string) {
        JoinTable joinTable = this.getExactOverriddenJoinTable(string);
        if (joinTable == null && string.contains(".collection&&element.")) {
            joinTable = this.getExactOverriddenJoinTable(string.replace(".collection&&element.", "."));
        }
        return joinTable;
    }

    private JoinTable getExactOverriddenJoinTable(String string) {
        JoinTable joinTable = null;
        if (this.parent != null) {
            joinTable = this.parent.getExactOverriddenJoinTable(string);
        }
        if (joinTable == null && this.currentPropertyJoinTableOverride != null) {
            joinTable = this.currentPropertyJoinTableOverride.get(string);
        }
        if (joinTable == null && this.holderJoinTableOverride != null) {
            joinTable = this.holderJoinTableOverride.get(string);
        }
        return joinTable;
    }

    private void buildHierarchyColumnOverride(XClass xClass) {
        Map<String, Column[]> map = new HashMap<String, Column[]>();
        Map<String, JoinColumn[]> map2 = new HashMap<String, JoinColumn[]>();
        Map<String, JoinTable> map3 = new HashMap<String, JoinTable>();
        for (XClass xClass2 = xClass; xClass2 != null && !this.mappings.getReflectionManager().toXClass(Object.class).equals(xClass2); xClass2 = xClass2.getSuperclass()) {
            if (!xClass2.isAnnotationPresent(Entity.class) && !xClass2.isAnnotationPresent(MappedSuperclass.class) && !xClass2.isAnnotationPresent(Embeddable.class)) continue;
            Map<String, Column[]> map4 = AbstractPropertyHolder.buildColumnOverride(xClass2, this.getPath());
            Map<String, JoinColumn[]> map5 = AbstractPropertyHolder.buildJoinColumnOverride(xClass2, this.getPath());
            Map<String, JoinTable> map6 = AbstractPropertyHolder.buildJoinTableOverride(xClass2, this.getPath());
            map4.putAll(map);
            map5.putAll(map2);
            map6.putAll(map3);
            map = map4;
            map2 = map5;
            map3 = map6;
        }
        this.holderColumnOverride = map.size() > 0 ? map : null;
        this.holderJoinColumnOverride = map2.size() > 0 ? map2 : null;
        this.holderJoinTableOverride = map3.size() > 0 ? map3 : null;
    }

    private static Map<String, Column[]> buildColumnOverride(XAnnotatedElement xAnnotatedElement, String string) {
        HashMap<String, Column[]> hashMap = new HashMap<String, Column[]>();
        if (xAnnotatedElement == null) {
            return hashMap;
        }
        AttributeOverride attributeOverride = xAnnotatedElement.getAnnotation(AttributeOverride.class);
        AttributeOverrides attributeOverrides = xAnnotatedElement.getAnnotation(AttributeOverrides.class);
        AttributeOverride[] attributeOverrideArray = attributeOverride != null ? new AttributeOverride[]{attributeOverride} : (attributeOverrides != null ? attributeOverrides.value() : null);
        if (attributeOverrideArray != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrideArray) {
                hashMap.put(StringHelper.qualify(string, attributeOverride2.name()), new Column[]{attributeOverride2.column()});
            }
        }
        return hashMap;
    }

    private static Map<String, JoinColumn[]> buildJoinColumnOverride(XAnnotatedElement xAnnotatedElement, String string) {
        HashMap<String, JoinColumn[]> hashMap = new HashMap<String, JoinColumn[]>();
        if (xAnnotatedElement == null) {
            return hashMap;
        }
        AssociationOverride associationOverride = xAnnotatedElement.getAnnotation(AssociationOverride.class);
        AssociationOverrides associationOverrides = xAnnotatedElement.getAnnotation(AssociationOverrides.class);
        AssociationOverride[] associationOverrideArray = associationOverride != null ? new AssociationOverride[]{associationOverride} : (associationOverrides != null ? associationOverrides.value() : null);
        if (associationOverrideArray != null) {
            for (AssociationOverride associationOverride2 : associationOverrideArray) {
                hashMap.put(StringHelper.qualify(string, associationOverride2.name()), associationOverride2.joinColumns());
            }
        }
        return hashMap;
    }

    private static Map<String, JoinTable> buildJoinTableOverride(XAnnotatedElement xAnnotatedElement, String string) {
        HashMap<String, JoinTable> hashMap = new HashMap<String, JoinTable>();
        if (xAnnotatedElement == null) {
            return hashMap;
        }
        AssociationOverride associationOverride = xAnnotatedElement.getAnnotation(AssociationOverride.class);
        AssociationOverrides associationOverrides = xAnnotatedElement.getAnnotation(AssociationOverrides.class);
        AssociationOverride[] associationOverrideArray = associationOverride != null ? new AssociationOverride[]{associationOverride} : (associationOverrides != null ? associationOverrides.value() : null);
        if (associationOverrideArray != null) {
            for (AssociationOverride associationOverride2 : associationOverrideArray) {
                if (associationOverride2.joinColumns().length != 0) continue;
                hashMap.put(StringHelper.qualify(string, associationOverride2.name()), associationOverride2.joinTable());
            }
        }
        return hashMap;
    }

    @Override
    public void setParentProperty(String string) {
        throw new AssertionFailure("Setting the parent property to a non component");
    }
}

