/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.entry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class StructuredCacheEntry
implements CacheEntryStructure {
    private EntityPersister persister;

    public StructuredCacheEntry(EntityPersister entityPersister) {
        this.persister = entityPersister;
    }

    public Object destructure(Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Map map = (Map)object;
        boolean bl = (Boolean)map.get("_lazyPropertiesUnfetched");
        String string = (String)map.get("_subclass");
        Object v = map.get("_version");
        EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(string);
        String[] stringArray = entityPersister.getPropertyNames();
        Serializable[] serializableArray = new Serializable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            serializableArray[i] = (Serializable)map.get(stringArray[i]);
        }
        return new StandardCacheEntryImpl(serializableArray, string, bl, v);
    }

    public Object structure(Object object) {
        CacheEntry cacheEntry = (CacheEntry)object;
        String[] stringArray = this.persister.getPropertyNames();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringArray.length + 2);
        hashMap.put("_subclass", cacheEntry.getSubclass());
        hashMap.put("_version", cacheEntry.getVersion());
        hashMap.put("_lazyPropertiesUnfetched", cacheEntry.areLazyPropertiesUnfetched());
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], cacheEntry.getDisassembledState()[i]);
        }
        return hashMap;
    }
}

