/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.entry;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeHelper;

public class StandardCacheEntryImpl
implements CacheEntry {
    private final Serializable[] disassembledState;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;
    private final Object version;

    public boolean isReferenceEntry() {
        return false;
    }

    public Serializable[] getDisassembledState() {
        return this.disassembledState;
    }

    public String getSubclass() {
        return this.subclass;
    }

    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    public Object getVersion() {
        return this.version;
    }

    public StandardCacheEntryImpl(Object[] objectArray, EntityPersister entityPersister, boolean bl, Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        this.disassembledState = TypeHelper.disassemble(objectArray, entityPersister.getPropertyTypes(), entityPersister.isLazyPropertiesCacheable() ? null : entityPersister.getPropertyLaziness(), sessionImplementor, object2);
        this.subclass = entityPersister.getEntityName();
        this.lazyPropertiesAreUnfetched = bl || !entityPersister.isLazyPropertiesCacheable();
        this.version = object;
    }

    StandardCacheEntryImpl(Serializable[] serializableArray, String string, boolean bl, Object object) {
        this.disassembledState = serializableArray;
        this.subclass = string;
        this.lazyPropertiesAreUnfetched = bl;
        this.version = object;
    }

    public boolean isDeepCopyNeeded() {
        return true;
    }

    public Object[] assemble(Object object, Serializable serializable, EntityPersister entityPersister, Interceptor interceptor, EventSource eventSource) throws HibernateException {
        if (!entityPersister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return StandardCacheEntryImpl.assemble(this.disassembledState, object, serializable, entityPersister, interceptor, eventSource);
    }

    private static Object[] assemble(Serializable[] serializableArray, Object object, Serializable serializable, EntityPersister entityPersister, Interceptor interceptor, EventSource eventSource) throws HibernateException {
        Object[] objectArray = TypeHelper.assemble(serializableArray, entityPersister.getPropertyTypes(), eventSource, object);
        PreLoadEvent preLoadEvent = new PreLoadEvent(eventSource).setEntity(object).setState(objectArray).setId(serializable).setPersister(entityPersister);
        EventListenerGroup<PreLoadEventListener> eventListenerGroup = eventSource.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
        for (PreLoadEventListener preLoadEventListener : eventListenerGroup.listeners()) {
            preLoadEventListener.onPreLoad(preLoadEvent);
        }
        entityPersister.setPropertyValues(object, objectArray);
        return objectArray;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.disassembledState);
    }
}

