/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi.access;

import org.hibernate.cache.spi.access.UnknownAccessTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AccessType {
    READ_ONLY("read-only"),
    READ_WRITE("read-write"),
    NONSTRICT_READ_WRITE("nonstrict-read-write"),
    TRANSACTIONAL("transactional");

    private final String externalName;

    private AccessType(String string2) {
        this.externalName = string2;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String toString() {
        return "AccessType[" + this.externalName + "]";
    }

    public static AccessType fromExternalName(String string) {
        if (string == null) {
            return null;
        }
        for (AccessType accessType : AccessType.values()) {
            if (!accessType.getExternalName().equals(string)) continue;
            return accessType;
        }
        throw new UnknownAccessTypeException(string);
    }
}

