/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, UpdateTimestampsCache.class.getName());
    private final SessionFactoryImplementor factory;
    private final TimestampsRegion region;

    public UpdateTimestampsCache(Settings settings, Properties properties, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        this.factory = sessionFactoryImplementor;
        String string = settings.getCacheRegionPrefix();
        String string2 = string == null ? REGION_NAME : string + '.' + REGION_NAME;
        LOG.startingUpdateTimestampsCache(string2);
        this.region = settings.getRegionFactory().buildTimestampsRegion(string2, properties);
    }

    public UpdateTimestampsCache(Settings settings, Properties properties) throws HibernateException {
        this(settings, properties, null);
    }

    public void preinvalidate(Serializable[] serializableArray) throws CacheException {
        boolean bl = LOG.isDebugEnabled();
        boolean bl2 = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long l = this.region.nextTimestamp() + (long)this.region.getTimeout();
        for (Serializable serializable : serializableArray) {
            if (bl) {
                LOG.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)serializable, (Object)l);
            }
            this.region.put(serializable, l);
            if (!bl2) continue;
            this.factory.getStatisticsImplementor().updateTimestampsCachePut();
        }
    }

    public void invalidate(Serializable[] serializableArray) throws CacheException {
        boolean bl = LOG.isDebugEnabled();
        boolean bl2 = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long l = this.region.nextTimestamp();
        for (Serializable serializable : serializableArray) {
            if (bl) {
                LOG.debugf("Invalidating space [%s], timestamp: %s", (Object)serializable, (Object)l);
            }
            this.region.put(serializable, l);
            if (!bl2) continue;
            this.factory.getStatisticsImplementor().updateTimestampsCachePut();
        }
    }

    public boolean isUpToDate(Set set, Long l) throws HibernateException {
        boolean bl = LOG.isDebugEnabled();
        boolean bl2 = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        for (Serializable serializable : set) {
            Long l2 = (Long)this.region.get(serializable);
            if (l2 == null) {
                if (!bl2) continue;
                this.factory.getStatisticsImplementor().updateTimestampsCacheMiss();
                continue;
            }
            if (bl) {
                LOG.debugf("[%s] last update timestamp: %s", (Object)serializable, (Object)(l2 + ", result set timestamp: " + l));
            }
            if (bl2) {
                this.factory.getStatisticsImplementor().updateTimestampsCacheHit();
            }
            if (l2 < l) continue;
            return false;
        }
        return true;
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception exception) {
            LOG.unableToDestroyUpdateTimestampsCache(this.region.getName(), exception.getMessage());
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampsCache";
    }
}

