/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.transform.CacheableResultTransformer;
import org.hibernate.type.Type;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] positionalParameterTypes;
    private final Object[] positionalParameterValues;
    private final Map namedParameters;
    private final Integer firstRow;
    private final Integer maxRows;
    private final String tenantIdentifier;
    private final Set filterKeys;
    private final CacheableResultTransformer customTransformer;
    private transient int hashCode;

    /*
     * WARNING - void declaration
     */
    public static QueryKey generateQueryKey(String string, QueryParameters queryParameters, Set set, SessionImplementor sessionImplementor, CacheableResultTransformer cacheableResultTransformer) {
        void var10_14;
        Integer n;
        Map map;
        int n2 = queryParameters.getPositionalParameterTypes().length;
        Type[] typeArray = new Type[n2];
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            typeArray[i] = queryParameters.getPositionalParameterTypes()[i];
            objectArray[i] = typeArray[i].disassemble(queryParameters.getPositionalParameterValues()[i], sessionImplementor, null);
        }
        if (queryParameters.getNamedParameters() == null) {
            map = null;
        } else {
            map = CollectionHelper.mapOfSize(queryParameters.getNamedParameters().size());
            for (Map.Entry object2 : queryParameters.getNamedParameters().entrySet()) {
                map.put(object2.getKey(), new TypedValue(((TypedValue)object2.getValue()).getType(), ((TypedValue)object2.getValue()).getType().disassemble(((TypedValue)object2.getValue()).getValue(), sessionImplementor, null)));
            }
        }
        RowSelection rowSelection = queryParameters.getRowSelection();
        if (rowSelection != null) {
            Integer n3 = rowSelection.getFirstRow();
            n = rowSelection.getMaxRows();
        } else {
            Object var10_13 = null;
            n = null;
        }
        return new QueryKey(string, typeArray, objectArray, map, (Integer)var10_14, n, set, sessionImplementor.getTenantIdentifier(), cacheableResultTransformer);
    }

    QueryKey(String string, Type[] typeArray, Object[] objectArray, Map map, Integer n, Integer n2, Set set, String string2, CacheableResultTransformer cacheableResultTransformer) {
        this.sqlQueryString = string;
        this.positionalParameterTypes = typeArray;
        this.positionalParameterValues = objectArray;
        this.namedParameters = map;
        this.firstRow = n;
        this.maxRows = n2;
        this.tenantIdentifier = string2;
        this.filterKeys = set;
        this.customTransformer = cacheableResultTransformer;
        this.hashCode = this.generateHashCode();
    }

    public CacheableResultTransformer getResultTransformer() {
        return this.customTransformer;
    }

    public Map getNamedParameters() {
        return Collections.unmodifiableMap(this.namedParameters);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int n = 13;
        n = 37 * n + (this.firstRow == null ? 0 : this.firstRow.hashCode());
        n = 37 * n + (this.maxRows == null ? 0 : this.maxRows.hashCode());
        for (int i = 0; i < this.positionalParameterValues.length; ++i) {
            n = 37 * n + (this.positionalParameterValues[i] == null ? 0 : this.positionalParameterTypes[i].getHashCode(this.positionalParameterValues[i]));
        }
        n = 37 * n + (this.namedParameters == null ? 0 : this.namedParameters.hashCode());
        n = 37 * n + (this.filterKeys == null ? 0 : this.filterKeys.hashCode());
        n = 37 * n + (this.customTransformer == null ? 0 : this.customTransformer.hashCode());
        n = 37 * n + (this.tenantIdentifier == null ? 0 : this.tenantIdentifier.hashCode());
        n = 37 * n + this.sqlQueryString.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryKey)) {
            return false;
        }
        QueryKey queryKey = (QueryKey)object;
        if (!this.sqlQueryString.equals(queryKey.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, queryKey.firstRow) || !EqualsHelper.equals(this.maxRows, queryKey.maxRows)) {
            return false;
        }
        if (!EqualsHelper.equals(this.customTransformer, queryKey.customTransformer)) {
            return false;
        }
        if (this.positionalParameterTypes == null) {
            if (queryKey.positionalParameterTypes != null) {
                return false;
            }
        } else {
            if (queryKey.positionalParameterTypes == null) {
                return false;
            }
            if (this.positionalParameterTypes.length != queryKey.positionalParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.positionalParameterTypes.length; ++i) {
                if (this.positionalParameterTypes[i].getReturnedClass() != queryKey.positionalParameterTypes[i].getReturnedClass()) {
                    return false;
                }
                if (this.positionalParameterTypes[i].isEqual(this.positionalParameterValues[i], queryKey.positionalParameterValues[i])) continue;
                return false;
            }
        }
        return EqualsHelper.equals(this.filterKeys, queryKey.filterKeys) && EqualsHelper.equals(this.namedParameters, queryKey.namedParameters) && EqualsHelper.equals(this.tenantIdentifier, queryKey.tenantIdentifier);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("sql: ").append(this.sqlQueryString);
        if (this.positionalParameterValues != null) {
            stringBuilder.append("; parameters: ");
            for (Object object : this.positionalParameterValues) {
                stringBuilder.append(object).append(", ");
            }
        }
        if (this.namedParameters != null) {
            stringBuilder.append("; named parameters: ").append(this.namedParameters);
        }
        if (this.filterKeys != null) {
            stringBuilder.append("; filterKeys: ").append(this.filterKeys);
        }
        if (this.firstRow != null) {
            stringBuilder.append("; first row: ").append(this.firstRow);
        }
        if (this.maxRows != null) {
            stringBuilder.append("; max rows: ").append(this.maxRows);
        }
        if (this.customTransformer != null) {
            stringBuilder.append("; transformer: ").append(this.customTransformer);
        }
        return stringBuilder.toString();
    }
}

