/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class NaturalIdCacheKey
implements Serializable {
    private final Serializable[] naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private transient ValueHolder<String> toString;

    public NaturalIdCacheKey(Object[] objectArray, EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        this.entityName = entityPersister.getRootEntityName();
        this.tenantId = sessionImplementor.getTenantIdentifier();
        this.naturalIdValues = new Serializable[objectArray.length];
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        Type[] typeArray = entityPersister.getPropertyTypes();
        int n = 1;
        n = 31 * n + (this.entityName == null ? 0 : this.entityName.hashCode());
        n = 31 * n + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = nArray[i];
            Type type = typeArray[n2];
            Object object = objectArray[i];
            n = 31 * n + (object != null ? type.getHashCode(object, sessionFactoryImplementor) : 0);
            this.naturalIdValues[i] = type.disassemble(object, sessionImplementor, null);
        }
        this.hashCode = n;
        this.initTransients();
    }

    private void initTransients() {
        this.toString = new ValueHolder<1>(new ValueHolder.DeferredInitializer<String>(){

            @Override
            public String initialize() {
                StringBuilder stringBuilder = new StringBuilder(NaturalIdCacheKey.this.entityName).append("##NaturalId[");
                for (int i = 0; i < NaturalIdCacheKey.this.naturalIdValues.length; ++i) {
                    stringBuilder.append(NaturalIdCacheKey.this.naturalIdValues[i]);
                    if (i + 1 >= NaturalIdCacheKey.this.naturalIdValues.length) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        });
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.hashCode != object.hashCode() || !(object instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey naturalIdCacheKey = (NaturalIdCacheKey)object;
        return EqualsHelper.equals(this.entityName, naturalIdCacheKey.entityName) && EqualsHelper.equals(this.tenantId, naturalIdCacheKey.tenantId) && Arrays.deepEquals(this.naturalIdValues, naturalIdCacheKey.naturalIdValues);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initTransients();
    }
}

