/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Filter;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.FilterImpl;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterKey
implements Serializable {
    private String filterName;
    private Map<String, TypedValue> filterParameters = new HashMap<String, TypedValue>();

    public FilterKey(String string, Map<String, ?> map, Map<String, Type> map2) {
        this.filterName = string;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Type type = map2.get(entry.getKey());
            this.filterParameters.put(entry.getKey(), new TypedValue(type, entry.getValue()));
        }
    }

    public int hashCode() {
        int n = 13;
        n = 37 * n + this.filterName.hashCode();
        n = 37 * n + this.filterParameters.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterKey)) {
            return false;
        }
        FilterKey filterKey = (FilterKey)object;
        if (!filterKey.filterName.equals(this.filterName)) {
            return false;
        }
        return filterKey.filterParameters.equals(this.filterParameters);
    }

    public String toString() {
        return "FilterKey[" + this.filterName + this.filterParameters + ']';
    }

    public static Set<FilterKey> createFilterKeys(Map<String, Filter> map) {
        if (map.size() == 0) {
            return null;
        }
        HashSet<FilterKey> hashSet = new HashSet<FilterKey>();
        for (Filter filter : map.values()) {
            FilterKey filterKey = new FilterKey(filter.getName(), ((FilterImpl)filter).getParameters(), filter.getFilterDefinition().getParameterTypes());
            hashSet.add(filterKey);
        }
        return hashSet;
    }
}

