/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.type.Type;

public class CacheKey
implements Serializable {
    private final Serializable key;
    private final Type type;
    private final String entityOrRoleName;
    private final String tenantId;
    private final int hashCode;

    public CacheKey(Serializable serializable, Type type, String string, String string2, SessionFactoryImplementor sessionFactoryImplementor) {
        this.key = serializable;
        this.type = type;
        this.entityOrRoleName = string;
        this.tenantId = string2;
        this.hashCode = this.calculateHashCode(type, sessionFactoryImplementor);
    }

    private int calculateHashCode(Type type, SessionFactoryImplementor sessionFactoryImplementor) {
        int n = type.getHashCode(this.key, sessionFactoryImplementor);
        n = 31 * n + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return n;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getEntityOrRoleName() {
        return this.entityOrRoleName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.hashCode != object.hashCode() || !(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        return EqualsHelper.equals(this.entityOrRoleName, cacheKey.entityOrRoleName) && this.type.isEqual(this.key, cacheKey.key) && EqualsHelper.equals(this.tenantId, cacheKey.tenantId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.entityOrRoleName + '#' + this.key.toString();
    }
}

