/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class StandardQueryCache
implements QueryCache {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StandardQueryCache.class.getName());
    private static final boolean DEBUGGING = LOG.isDebugEnabled();
    private static final boolean TRACING = LOG.isTraceEnabled();
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    public StandardQueryCache(Settings settings, Properties properties, UpdateTimestampsCache updateTimestampsCache, String string) throws HibernateException {
        String string2;
        if (string == null) {
            string = StandardQueryCache.class.getName();
        }
        if ((string2 = settings.getCacheRegionPrefix()) != null) {
            string = string2 + '.' + string;
        }
        LOG.startingQueryCache(string);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(string, properties);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    public boolean put(QueryKey queryKey, Type[] typeArray, List list, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (bl && list.isEmpty()) {
            return false;
        }
        long l = this.cacheRegion.nextTimestamp();
        if (DEBUGGING) {
            LOG.debugf("Caching query results in region: %s; timestamp=%s", (Object)this.cacheRegion.getName(), (Object)l);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
        StandardQueryCache.logCachedResultDetails(queryKey, null, typeArray, arrayList);
        arrayList.add(l);
        boolean bl2 = typeArray.length == 1;
        for (Object e : list) {
            Serializable[] serializableArray = bl2 ? typeArray[0].disassemble(e, sessionImplementor, null) : TypeHelper.disassemble((Object[])e, typeArray, null, sessionImplementor, null);
            arrayList.add(serializableArray);
            StandardQueryCache.logCachedResultRowDetails(typeArray, e);
        }
        this.cacheRegion.put(queryKey, arrayList);
        return true;
    }

    public List get(QueryKey queryKey, Type[] typeArray, boolean bl, Set set, SessionImplementor sessionImplementor) throws HibernateException {
        if (DEBUGGING) {
            LOG.debugf("Checking cached query results in region: %s", (Object)this.cacheRegion.getName());
        }
        List list = (List)this.cacheRegion.get(queryKey);
        StandardQueryCache.logCachedResultDetails(queryKey, set, typeArray, list);
        if (list == null) {
            if (DEBUGGING) {
                LOG.debug("Query results were not found in cache");
            }
            return null;
        }
        Long l = (Long)list.get(0);
        if (!bl && !this.isUpToDate(set, l)) {
            if (DEBUGGING) {
                LOG.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (DEBUGGING) {
            LOG.debug("Returning cached query results");
        }
        boolean bl2 = typeArray.length == 1;
        for (int i = 1; i < list.size(); ++i) {
            if (bl2) {
                typeArray[0].beforeAssemble((Serializable)list.get(i), sessionImplementor);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])list.get(i), typeArray, sessionImplementor);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() - 1);
        for (int i = 1; i < list.size(); ++i) {
            try {
                if (bl2) {
                    arrayList.add(typeArray[0].assemble((Serializable)list.get(i), sessionImplementor, null));
                } else {
                    arrayList.add(TypeHelper.assemble((Serializable[])list.get(i), typeArray, sessionImplementor, null));
                }
                StandardQueryCache.logCachedResultRowDetails(typeArray, arrayList.get(i - 1));
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (bl && (UnresolvableObjectException.class.isInstance(runtimeException) || EntityNotFoundException.class.isInstance(runtimeException))) {
                    if (DEBUGGING) {
                        LOG.debug("Unable to reassemble cached result set");
                    }
                    this.cacheRegion.evict(queryKey);
                    return null;
                }
                throw runtimeException;
            }
        }
        return arrayList;
    }

    protected boolean isUpToDate(Set set, Long l) {
        if (DEBUGGING) {
            LOG.debugf("Checking query spaces are up-to-date: %s", (Object)set);
        }
        return this.updateTimestampsCache.isUpToDate(set, l);
    }

    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception exception) {
            LOG.unableToDestroyQueryCache(this.cacheRegion.getName(), exception.getMessage());
        }
    }

    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }

    private static void logCachedResultDetails(QueryKey queryKey, Set set, Type[] typeArray, List list) {
        if (!TRACING) {
            return;
        }
        LOG.trace("key.hashCode=" + queryKey.hashCode());
        LOG.trace("querySpaces=" + set);
        if (typeArray == null || typeArray.length == 0) {
            LOG.trace("Unexpected returnTypes is " + (typeArray == null ? "null" : "empty") + "! result" + (list == null ? " is null" : ".size()=" + list.size()));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < typeArray.length; ++i) {
                stringBuilder.append("typename=").append(typeArray[i].getName()).append(" class=").append(typeArray[i].getReturnedClass().getName()).append(' ');
            }
            LOG.trace("unexpected returnTypes is " + stringBuilder.toString() + "! result");
        }
    }

    private static void logCachedResultRowDetails(Type[] typeArray, Object object) {
        Object[] objectArray;
        if (!TRACING) {
            return;
        }
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        StandardQueryCache.logCachedResultRowDetails(typeArray, objectArray);
    }

    private static void logCachedResultRowDetails(Type[] typeArray, Object[] objectArray) {
        if (!TRACING) {
            return;
        }
        if (objectArray == null) {
            LOG.trace(" tuple is null; returnTypes is " + typeArray == null ? "null" : "Type[" + typeArray.length + "]");
            if (typeArray != null && typeArray.length > 1) {
                LOG.trace("Unexpected result tuple! tuple is null; should be Object[" + typeArray.length + "]!");
            }
        } else {
            if (typeArray == null || typeArray.length == 0) {
                LOG.trace("Unexpected result tuple! tuple is null; returnTypes is " + (typeArray == null ? "null" : "empty"));
            }
            LOG.trace(" tuple is Object[" + objectArray.length + "]; returnTypes is Type[" + typeArray.length + "]");
            if (objectArray.length != typeArray.length) {
                LOG.trace("Unexpected tuple length! transformer= expected=" + typeArray.length + " got=" + objectArray.length);
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || typeArray[i].getReturnedClass().isInstance(objectArray[i])) continue;
                    LOG.trace("Unexpected tuple value type! transformer= expected=" + typeArray[i].getReturnedClass().getName() + " got=" + objectArray[i].getClass().getName());
                }
            }
        }
    }
}

