/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Map;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionFactoryInitiator
implements BasicServiceInitiator<RegionFactory> {
    public static final RegionFactoryInitiator INSTANCE = new RegionFactoryInitiator();
    public static final String IMPL_NAME = "hibernate.cache.region.factory_class";

    @Override
    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    @Override
    public RegionFactory initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = map.get(IMPL_NAME);
        if (v == null) {
            return new NoCachingRegionFactory();
        }
        if (this.getServiceInitiated().isInstance(v)) {
            return (RegionFactory)v;
        }
        Class clazz = null;
        clazz = Class.class.isInstance(v) ? (Class)v : serviceRegistryImplementor.getService(ClassLoaderService.class).classForName(RegionFactoryInitiator.mapLegacyNames(v.toString()));
        try {
            return (RegionFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Could not initialize custom RegionFactory impl [" + clazz.getName() + "]", exception);
        }
    }

    public static String mapLegacyNames(String string) {
        if ("org.hibernate.cache.EhCacheRegionFactory".equals(string)) {
            return "org.hibernate.cache.ehcache.EhCacheRegionFactory";
        }
        if ("org.hibernate.cache.SingletonEhCacheRegionFactory".equals(string)) {
            return "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory";
        }
        return string;
    }
}

