/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Comparator;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.VersionType;

public class CacheDataDescriptionImpl
implements CacheDataDescription {
    private final boolean mutable;
    private final boolean versioned;
    private final Comparator versionComparator;

    public CacheDataDescriptionImpl(boolean bl, boolean bl2, Comparator comparator) {
        this.mutable = bl;
        this.versioned = bl2;
        this.versionComparator = comparator;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public Comparator getVersionComparator() {
        return this.versionComparator;
    }

    public static CacheDataDescriptionImpl decode(PersistentClass persistentClass) {
        return new CacheDataDescriptionImpl(persistentClass.isMutable(), persistentClass.isVersioned(), persistentClass.isVersioned() ? ((VersionType)persistentClass.getVersion().getType()).getComparator() : null);
    }

    public static CacheDataDescriptionImpl decode(EntityBinding entityBinding) {
        return new CacheDataDescriptionImpl(entityBinding.isMutable(), entityBinding.isVersioned(), CacheDataDescriptionImpl.getVersionComparator(entityBinding));
    }

    public static CacheDataDescriptionImpl decode(Collection collection) {
        return new CacheDataDescriptionImpl(collection.isMutable(), collection.getOwner().isVersioned(), collection.getOwner().isVersioned() ? ((VersionType)collection.getOwner().getVersion().getType()).getComparator() : null);
    }

    public static CacheDataDescriptionImpl decode(PluralAttributeBinding pluralAttributeBinding) {
        return new CacheDataDescriptionImpl(pluralAttributeBinding.isMutable(), pluralAttributeBinding.getContainer().seekEntityBinding().isVersioned(), CacheDataDescriptionImpl.getVersionComparator(pluralAttributeBinding.getContainer().seekEntityBinding()));
    }

    public static CacheDataDescriptionImpl decode(EntityPersister entityPersister) {
        return new CacheDataDescriptionImpl(!entityPersister.getEntityMetamodel().hasImmutableNaturalId(), false, null);
    }

    private static Comparator getVersionComparator(EntityBinding entityBinding) {
        Comparator comparator = null;
        if (entityBinding.isVersioned()) {
            comparator = ((VersionType)entityBinding.getHierarchyDetails().getVersioningAttributeBinding().getHibernateTypeDescriptor().getResolvedTypeMapping()).getComparator();
        }
        return comparator;
    }
}

