/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.hibernate.HibernateException;

public class TransformingClassLoader
extends ClassLoader {
    private ClassLoader parent;
    private ClassPool classPool;

    TransformingClassLoader(ClassLoader classLoader, String[] stringArray) {
        this.parent = classLoader;
        this.classPool = new ClassPool(true);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.classPool.appendClassPath(stringArray[i]);
                continue;
            }
            catch (NotFoundException notFoundException) {
                throw new HibernateException("Unable to resolve requested classpath for transformation [" + stringArray[i] + "] : " + notFoundException.getMessage());
            }
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            CtClass ctClass = this.classPool.get(string);
            byte[] byArray = ctClass.toBytecode();
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (NotFoundException notFoundException) {
            throw new ClassNotFoundException();
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException();
        }
        catch (CannotCompileException cannotCompileException) {
            throw new ClassNotFoundException();
        }
    }

    public void release() {
        this.classPool = null;
        this.parent = null;
    }
}

