/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.bytecode.ClassFile;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;
import org.hibernate.bytecode.internal.javassist.FieldFilter;
import org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.hibernate.bytecode.internal.javassist.FieldTransformer;
import org.hibernate.bytecode.spi.AbstractClassTransformerImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JavassistClassTransformer.class.getName());

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.buildtime.spi.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        ClassFile classFile;
        try {
            classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (IOException iOException) {
            LOG.unableToBuildEnhancementMetamodel(string);
            return byArray;
        }
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        classPool.appendClassPath((ClassPath)new ClassClassPath(classFile.getClass()));
        try {
            classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        FieldTransformer fieldTransformer = this.getFieldTransformer(classFile, classPool);
        if (fieldTransformer != null) {
            LOG.debugf("Enhancing %s", (Object)string);
            FilterOutputStream filterOutputStream = null;
            try {
                fieldTransformer.transform(classFile);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                classFile.write((DataOutputStream)filterOutputStream);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            catch (Exception exception) {
                LOG.unableToTransformClass(exception.getMessage());
                throw new HibernateException("Unable to transform class: " + exception.getMessage());
            }
            finally {
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classFile, ClassPool classPool) {
        if (this.alreadyInstrumented(classFile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleWrite(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleReadAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }

            public boolean handleWriteAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }
        }, classPool);
    }

    private boolean alreadyInstrumented(ClassFile classFile) {
        String[] stringArray = classFile.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!FieldHandled.class.getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

