/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class FastClass
implements Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Class type;

    private FastClass() {
    }

    private FastClass(Class clazz) {
        this.type = clazz;
    }

    public Object invoke(String string, Class[] classArray, Object object, Object[] objectArray) throws InvocationTargetException {
        return this.invoke(this.getIndex(string, classArray), object, objectArray);
    }

    public Object invoke(int n, Object object, Object[] objectArray) throws InvocationTargetException {
        Method[] methodArray = this.type.getMethods();
        try {
            return methodArray[n].invoke(object, objectArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] classArray, Object[] objectArray) throws InvocationTargetException {
        return this.newInstance(this.getIndex(classArray), objectArray);
    }

    public Object newInstance(int n, Object[] objectArray) throws InvocationTargetException {
        Constructor<?>[] constructorArray = this.type.getConstructors();
        try {
            return constructorArray[n].newInstance(objectArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new InvocationTargetException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public int getIndex(String string, Class[] classArray) {
        Method[] methodArray = this.type.getMethods();
        boolean bl = true;
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray2;
            if (!Modifier.isPublic(methodArray[i].getModifiers()) || !methodArray[i].getName().equals(string) || (classArray2 = methodArray[i].getParameterTypes()).length != classArray.length) continue;
            bl = true;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j].equals(classArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(Class[] classArray) {
        Constructor<?>[] constructorArray = this.type.getConstructors();
        boolean bl = true;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray2;
            if (!Modifier.isPublic(constructorArray[i].getModifiers()) || (classArray2 = constructorArray[i].getParameterTypes()).length != classArray.length) continue;
            bl = true;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j].equals(classArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int getMaxIndex() {
        Method[] methodArray = this.type.getMethods();
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isPublic(methodArray[i].getModifiers())) continue;
            ++n;
        }
        return n;
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastClass)) {
            return false;
        }
        return this.type.equals(((FastClass)object).type);
    }

    public static FastClass create(Class clazz) {
        FastClass fastClass = new FastClass(clazz);
        return fastClass;
    }
}

