/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.lang.reflect.Modifier;
import java.util.Set;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;
import org.hibernate.bytecode.buildtime.spi.FieldFilter;
import org.hibernate.bytecode.instrumentation.internal.javassist.JavassistHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.internal.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;
import org.hibernate.bytecode.internal.javassist.FastClass;
import org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.hibernate.bytecode.internal.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.JavassistClassTransformer;
import org.hibernate.bytecode.internal.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.bytecode.spi.EntityInstrumentationMetadata;
import org.hibernate.bytecode.spi.NotInstrumentedException;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BytecodeProviderImpl.class.getName());

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        block8: {
            try {
                fastClass = FastClass.create(clazz);
                bulkAccessor = BulkAccessor.create(clazz, stringArray, stringArray2, classArray);
                if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                    if (fastClass == null) {
                        bulkAccessor = null;
                    } else {
                        Object object = fastClass.newInstance();
                        bulkAccessor.setPropertyValues(object, bulkAccessor.getPropertyValues(object));
                    }
                }
            }
            catch (Throwable throwable) {
                fastClass = null;
                bulkAccessor = null;
                if (!LOG.isDebugEnabled()) break block8;
                int n = 0;
                if (throwable instanceof BulkAccessorException) {
                    n = ((BulkAccessorException)throwable).getIndex();
                }
                if (n >= 0) {
                    LOG.debugf("Reflection optimizer disabled for: %s [%s: %s (property %s)", clazz.getName(), StringHelper.unqualify(throwable.getClass().getName()), throwable.getMessage(), stringArray2[n]);
                }
                LOG.debugf("Reflection optimizer disabled for: %s [%s: %s", (Object)clazz.getName(), (Object)StringHelper.unqualify(throwable.getClass().getName()), (Object)throwable.getMessage());
            }
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }

    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new JavassistClassTransformer(classFilter, fieldFilter);
    }

    public EntityInstrumentationMetadata getEntityInstrumentationMetadata(Class clazz) {
        return new EntityInstrumentationMetadataImpl(clazz);
    }

    private class EntityInstrumentationMetadataImpl
    implements EntityInstrumentationMetadata {
        private final Class entityClass;
        private final boolean isInstrumented;

        private EntityInstrumentationMetadataImpl(Class clazz) {
            this.entityClass = clazz;
            this.isInstrumented = FieldHandled.class.isAssignableFrom(clazz);
        }

        public String getEntityName() {
            return this.entityClass.getName();
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public FieldInterceptor extractInterceptor(Object object) throws NotInstrumentedException {
            if (!this.entityClass.isInstance(object)) {
                throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", object, this.getEntityName()));
            }
            if (!this.isInstrumented()) {
                throw new NotInstrumentedException(String.format("Entity class [%s] is not instrumented", this.getEntityName()));
            }
            return JavassistHelper.extractFieldInterceptor(object);
        }

        public FieldInterceptor injectInterceptor(Object object, String string, Set set, SessionImplementor sessionImplementor) throws NotInstrumentedException {
            if (!this.entityClass.isInstance(object)) {
                throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", object, this.getEntityName()));
            }
            if (!this.isInstrumented()) {
                throw new NotInstrumentedException(String.format("Entity class [%s] is not instrumented", this.getEntityName()));
            }
            return JavassistHelper.injectFieldInterceptor(object, string, set, sessionImplementor);
        }
    }
}

