/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.Serializable;
import org.hibernate.PropertyAccessException;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;
import org.hibernate.bytecode.spi.ReflectionOptimizer;

public class AccessOptimizerAdapter
implements ReflectionOptimizer.AccessOptimizer,
Serializable {
    public static final String PROPERTY_GET_EXCEPTION = "exception getting property value with Javassist (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    public static final String PROPERTY_SET_EXCEPTION = "exception setting property value with Javassist (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    private final BulkAccessor bulkAccessor;
    private final Class mappedClass;

    public AccessOptimizerAdapter(BulkAccessor bulkAccessor, Class clazz) {
        this.bulkAccessor = bulkAccessor;
        this.mappedClass = clazz;
    }

    public String[] getPropertyNames() {
        return this.bulkAccessor.getGetters();
    }

    public Object[] getPropertyValues(Object object) {
        try {
            return this.bulkAccessor.getPropertyValues(object);
        }
        catch (Throwable throwable) {
            throw new PropertyAccessException(throwable, PROPERTY_GET_EXCEPTION, false, this.mappedClass, AccessOptimizerAdapter.getterName(throwable, this.bulkAccessor));
        }
    }

    public void setPropertyValues(Object object, Object[] objectArray) {
        try {
            this.bulkAccessor.setPropertyValues(object, objectArray);
        }
        catch (Throwable throwable) {
            throw new PropertyAccessException(throwable, PROPERTY_SET_EXCEPTION, true, this.mappedClass, AccessOptimizerAdapter.setterName(throwable, this.bulkAccessor));
        }
    }

    private static String setterName(Throwable throwable, BulkAccessor bulkAccessor) {
        if (throwable instanceof BulkAccessorException) {
            return bulkAccessor.getSetters()[((BulkAccessorException)throwable).getIndex()];
        }
        return "?";
    }

    private static String getterName(Throwable throwable, BulkAccessor bulkAccessor) {
        if (throwable instanceof BulkAccessorException) {
            return bulkAccessor.getGetters()[((BulkAccessorException)throwable).getIndex()];
        }
        return "?";
    }
}

