/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.instrumentation.spi;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.LazyInitializationException;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractFieldInterceptor
implements FieldInterceptor,
Serializable {
    private transient SessionImplementor session;
    private Set uninitializedFields;
    private final String entityName;
    private transient boolean initializing;
    private boolean dirty;

    protected AbstractFieldInterceptor(SessionImplementor sessionImplementor, Set set, String string) {
        this.session = sessionImplementor;
        this.uninitializedFields = set;
        this.entityName = string;
    }

    public final void setSession(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
    }

    public final boolean isInitialized() {
        return this.uninitializedFields == null || this.uninitializedFields.size() == 0;
    }

    public final boolean isInitialized(String string) {
        return this.uninitializedFields == null || !this.uninitializedFields.contains(string);
    }

    public final void dirty() {
        this.dirty = true;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object intercept(Object object, String string, Object object2) {
        if (this.initializing) {
            return object2;
        }
        if (this.uninitializedFields != null && this.uninitializedFields.contains(string)) {
            Object object3;
            if (this.session == null) {
                throw new LazyInitializationException("entity with lazy properties is not associated with a session");
            }
            if (!this.session.isOpen() || !this.session.isConnected()) {
                throw new LazyInitializationException("session is not connected");
            }
            this.initializing = true;
            try {
                object3 = ((LazyPropertyInitializer)((Object)this.session.getFactory().getEntityPersister(this.entityName))).initializeLazyProperty(string, object, this.session);
            }
            finally {
                this.initializing = false;
            }
            this.uninitializedFields = null;
            return object3;
        }
        return object2;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final Set getUninitializedFields() {
        return this.uninitializedFields;
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final boolean isInitializing() {
        return this.initializing;
    }
}

