/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.instrumentation.internal.javassist;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.bytecode.instrumentation.spi.AbstractFieldInterceptor;
import org.hibernate.bytecode.internal.javassist.FieldHandler;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class FieldInterceptorImpl
extends AbstractFieldInterceptor
implements FieldHandler,
Serializable {
    FieldInterceptorImpl(SessionImplementor sessionImplementor, Set set, String string) {
        super(sessionImplementor, set, string);
    }

    public boolean readBoolean(Object object, String string, boolean bl) {
        return (Boolean)this.intercept(object, string, bl);
    }

    public byte readByte(Object object, String string, byte by) {
        return (Byte)this.intercept(object, string, by);
    }

    public char readChar(Object object, String string, char c) {
        return ((Character)this.intercept(object, string, Character.valueOf(c))).charValue();
    }

    public double readDouble(Object object, String string, double d) {
        return (Double)this.intercept(object, string, d);
    }

    public float readFloat(Object object, String string, float f) {
        return ((Float)this.intercept(object, string, Float.valueOf(f))).floatValue();
    }

    public int readInt(Object object, String string, int n) {
        return (Integer)this.intercept(object, string, n);
    }

    public long readLong(Object object, String string, long l) {
        return (Long)this.intercept(object, string, l);
    }

    public short readShort(Object object, String string, short s) {
        return (Short)this.intercept(object, string, s);
    }

    public Object readObject(Object object, String string, Object object2) {
        LazyInitializer lazyInitializer;
        Object object3 = this.intercept(object, string, object2);
        if (object3 instanceof HibernateProxy && (lazyInitializer = ((HibernateProxy)object3).getHibernateLazyInitializer()).isUnwrap()) {
            object3 = lazyInitializer.getImplementation();
        }
        return object3;
    }

    public boolean writeBoolean(Object object, String string, boolean bl, boolean bl2) {
        this.dirty();
        this.intercept(object, string, bl);
        return bl2;
    }

    public byte writeByte(Object object, String string, byte by, byte by2) {
        this.dirty();
        this.intercept(object, string, by);
        return by2;
    }

    public char writeChar(Object object, String string, char c, char c2) {
        this.dirty();
        this.intercept(object, string, Character.valueOf(c));
        return c2;
    }

    public double writeDouble(Object object, String string, double d, double d2) {
        this.dirty();
        this.intercept(object, string, d);
        return d2;
    }

    public float writeFloat(Object object, String string, float f, float f2) {
        this.dirty();
        this.intercept(object, string, Float.valueOf(f));
        return f2;
    }

    public int writeInt(Object object, String string, int n, int n2) {
        this.dirty();
        this.intercept(object, string, n);
        return n2;
    }

    public long writeLong(Object object, String string, long l, long l2) {
        this.dirty();
        this.intercept(object, string, l);
        return l2;
    }

    public short writeShort(Object object, String string, short s, short s2) {
        this.dirty();
        this.intercept(object, string, s);
        return s2;
    }

    public Object writeObject(Object object, String string, Object object2, Object object3) {
        this.dirty();
        this.intercept(object, string, object2);
        return object3;
    }

    public String toString() {
        return "FieldInterceptorImpl(entityName=" + this.getEntityName() + ",dirty=" + this.isDirty() + ",uninitializedFields=" + this.getUninitializedFields() + ')';
    }
}

