/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.instrumentation.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.bytecode.instrumentation.internal.javassist.JavassistHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.spi.SessionImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInterceptionHelper {
    private static final Set<Delegate> INSTRUMENTATION_DELEGATES = FieldInterceptionHelper.buildInstrumentationDelegates();

    private static Set<Delegate> buildInstrumentationDelegates() {
        HashSet<Delegate> hashSet = new HashSet<Delegate>();
        hashSet.add(JavassistDelegate.INSTANCE);
        return hashSet;
    }

    private FieldInterceptionHelper() {
    }

    public static boolean isInstrumented(Class clazz) {
        for (Delegate delegate : INSTRUMENTATION_DELEGATES) {
            if (!delegate.isInstrumented(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstrumented(Object object) {
        return object != null && FieldInterceptionHelper.isInstrumented(object.getClass());
    }

    public static FieldInterceptor extractFieldInterceptor(Object object) {
        Delegate delegate;
        if (object == null) {
            return null;
        }
        FieldInterceptor fieldInterceptor = null;
        Iterator<Delegate> iterator = INSTRUMENTATION_DELEGATES.iterator();
        while (iterator.hasNext() && (fieldInterceptor = (delegate = iterator.next()).extractInterceptor(object)) == null) {
        }
        return fieldInterceptor;
    }

    public static FieldInterceptor injectFieldInterceptor(Object object, String string, Set set, SessionImplementor sessionImplementor) {
        Delegate delegate;
        if (object == null) {
            return null;
        }
        FieldInterceptor fieldInterceptor = null;
        Iterator<Delegate> iterator = INSTRUMENTATION_DELEGATES.iterator();
        while (iterator.hasNext() && (fieldInterceptor = (delegate = iterator.next()).injectInterceptor(object, string, set, sessionImplementor)) == null) {
        }
        return fieldInterceptor;
    }

    private static class JavassistDelegate
    implements Delegate {
        public static final JavassistDelegate INSTANCE = new JavassistDelegate();
        public static final String MARKER = "org.hibernate.bytecode.internal.javassist.FieldHandled";

        private JavassistDelegate() {
        }

        public boolean isInstrumented(Class clazz) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!MARKER.equals(clazz2.getName())) continue;
                return true;
            }
            return false;
        }

        public FieldInterceptor extractInterceptor(Object object) {
            for (Class<?> clazz : object.getClass().getInterfaces()) {
                if (!MARKER.equals(clazz.getName())) continue;
                return JavassistHelper.extractFieldInterceptor(object);
            }
            return null;
        }

        public FieldInterceptor injectInterceptor(Object object, String string, Set set, SessionImplementor sessionImplementor) {
            for (Class<?> clazz : object.getClass().getInterfaces()) {
                if (!MARKER.equals(clazz.getName())) continue;
                return JavassistHelper.injectFieldInterceptor(object, string, set, sessionImplementor);
            }
            return null;
        }
    }

    private static interface Delegate {
        public boolean isInstrumented(Class var1);

        public FieldInterceptor extractInterceptor(Object var1);

        public FieldInterceptor injectInterceptor(Object var1, String var2, Set var3, SessionImplementor var4);
    }
}

