/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.Transient;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enhancer {
    private static final CoreMessageLogger log = Logger.getMessageLogger(CoreMessageLogger.class, Enhancer.class.getName());
    public static final String PERSISTENT_FIELD_READER_PREFIX = "$$_hibernate_read_";
    public static final String PERSISTENT_FIELD_WRITER_PREFIX = "$$_hibernate_write_";
    public static final String ENTITY_INSTANCE_GETTER_NAME = "$$_hibernate_getEntityInstance";
    public static final String ENTITY_ENTRY_FIELD_NAME = "$$_hibernate_entityEntryHolder";
    public static final String ENTITY_ENTRY_GETTER_NAME = "$$_hibernate_getEntityEntry";
    public static final String ENTITY_ENTRY_SETTER_NAME = "$$_hibernate_setEntityEntry";
    public static final String PREVIOUS_FIELD_NAME = "$$_hibernate_previousManagedEntity";
    public static final String PREVIOUS_GETTER_NAME = "$$_hibernate_getPreviousManagedEntity";
    public static final String PREVIOUS_SETTER_NAME = "$$_hibernate_setPreviousManagedEntity";
    public static final String NEXT_FIELD_NAME = "$$_hibernate_nextManagedEntity";
    public static final String NEXT_GETTER_NAME = "$$_hibernate_getNextManagedEntity";
    public static final String NEXT_SETTER_NAME = "$$_hibernate_setNextManagedEntity";
    public static final String INTERCEPTOR_FIELD_NAME = "$$_hibernate_attributeInterceptor";
    public static final String INTERCEPTOR_GETTER_NAME = "$$_hibernate_getInterceptor";
    public static final String INTERCEPTOR_SETTER_NAME = "$$_hibernate_setInterceptor";
    private final EnhancementContext enhancementContext;
    private final ClassPool classPool;
    private final CtClass managedEntityCtClass;
    private final CtClass managedCompositeCtClass;
    private final CtClass attributeInterceptorCtClass;
    private final CtClass attributeInterceptableCtClass;
    private final CtClass entityEntryCtClass;
    private final CtClass objectCtClass;
    private static final AttributeTypeDescriptor BOOLEAN_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readBoolean(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("boolean localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeBoolean(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor BYTE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readByte(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("byte localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeByte(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor CHAR_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readChar(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("char localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeChar(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor SHORT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readShort(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("short localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeShort(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor INT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readInt(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("int localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeInt(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor LONG_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readLong(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("long localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeLong(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor DOUBLE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readDouble(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("double localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeDouble(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };
    private static final AttributeTypeDescriptor FLOAT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readFloat(this, \"%1$s\", this.%1$s); }", string);
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("float localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeFloat(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string);
        }
    };

    public Enhancer(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
        try {
            this.managedEntityCtClass = this.classPool.makeClass(ManagedEntity.class.getClassLoader().getResourceAsStream(ManagedEntity.class.getName().replace('.', '/') + ".class"));
            this.managedCompositeCtClass = this.classPool.makeClass(ManagedComposite.class.getClassLoader().getResourceAsStream(ManagedComposite.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptableCtClass = this.classPool.makeClass(PersistentAttributeInterceptable.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptable.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptorCtClass = this.classPool.makeClass(PersistentAttributeInterceptor.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptor.class.getName().replace('.', '/') + ".class"));
            this.entityEntryCtClass = this.classPool.makeClass(EntityEntry.class.getName());
        }
        catch (IOException iOException) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", iOException);
        }
        try {
            this.objectCtClass = this.classPool.getCtClass(Object.class.getName());
        }
        catch (NotFoundException notFoundException) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", notFoundException);
        }
    }

    private ClassPool buildClassPool(EnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false);
        ClassLoader classLoader = enhancementContext.getLoadingClassLoader();
        if (classLoader != null) {
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        }
        return classPool;
    }

    public byte[] enhance(String string, byte[] byArray) throws EnhancementException {
        CtClass ctClass;
        try {
            ctClass = this.classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            log.unableToBuildEnhancementMetamodel(string);
            return byArray;
        }
        this.enhance(ctClass);
        FilterOutputStream filterOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ctClass.toBytecode((DataOutputStream)filterOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (Exception exception) {
            log.unableToTransformClass(exception.getMessage());
            throw new HibernateException("Unable to transform class: " + exception.getMessage());
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void enhance(CtClass ctClass) {
        String[] stringArray;
        String string = ctClass.getName();
        log.debugf("Enhancing %s", (Object)string);
        if (ctClass.isInterface()) {
            log.debug("skipping enhancement : interface");
            return;
        }
        for (String string2 : stringArray = ctClass.getClassFile2().getInterfaces()) {
            if (!ManagedEntity.class.getName().equals(string2) && !ManagedComposite.class.getName().equals(string2)) continue;
            log.debug("skipping enhancement : already enhanced");
            return;
        }
        if (this.enhancementContext.isEntityClass(ctClass)) {
            this.enhanceAsEntity(ctClass);
        } else if (this.enhancementContext.isCompositeClass(ctClass)) {
            this.enhanceAsComposite(ctClass);
        } else {
            log.debug("skipping enhancement : not entity or composite");
        }
    }

    private void enhanceAsEntity(CtClass ctClass) {
        ctClass.addInterface(this.managedEntityCtClass);
        this.enhancePersistentAttributes(ctClass);
        this.addEntityInstanceHandling(ctClass);
        this.addEntityEntryHandling(ctClass);
        this.addLinkedPreviousHandling(ctClass);
        this.addLinkedNextHandling(ctClass);
    }

    private void enhanceAsComposite(CtClass ctClass) {
        this.enhancePersistentAttributes(ctClass);
    }

    private void addEntityInstanceHandling(CtClass ctClass) {
        try {
            ctClass.addMethod(CtNewMethod.make((CtClass)this.objectCtClass, (String)ENTITY_INSTANCE_GETTER_NAME, (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)"{ return this; }", (CtClass)ctClass));
        }
        catch (CannotCompileException cannotCompileException) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add EntityEntry getter", ctClass.getName()), cannotCompileException);
        }
    }

    private void addEntityEntryHandling(CtClass ctClass) {
        this.addFieldWithGetterAndSetter(ctClass, this.entityEntryCtClass, ENTITY_ENTRY_FIELD_NAME, ENTITY_ENTRY_GETTER_NAME, ENTITY_ENTRY_SETTER_NAME);
    }

    private void addLinkedPreviousHandling(CtClass ctClass) {
        this.addFieldWithGetterAndSetter(ctClass, this.managedEntityCtClass, PREVIOUS_FIELD_NAME, PREVIOUS_GETTER_NAME, PREVIOUS_SETTER_NAME);
    }

    private void addLinkedNextHandling(CtClass ctClass) {
        this.addFieldWithGetterAndSetter(ctClass, this.managedEntityCtClass, NEXT_FIELD_NAME, NEXT_GETTER_NAME, NEXT_SETTER_NAME);
    }

    private AnnotationsAttribute getVisibleAnnotations(FieldInfo fieldInfo) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
            fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    private void enhancePersistentAttributes(CtClass ctClass) {
        this.addInterceptorHandling(ctClass);
        if (this.enhancementContext.doDirtyCheckingInline(ctClass)) {
            this.addInLineDirtyHandling(ctClass);
        }
        IdentityHashMap<String, PersistentAttributeDescriptor> identityHashMap = new IdentityHashMap<String, PersistentAttributeDescriptor>();
        for (CtField ctField : this.collectPersistentFields(ctClass)) {
            identityHashMap.put(ctField.getName(), this.enhancePersistentAttribute(ctClass, ctField));
        }
        this.transformFieldAccessesIntoReadsAndWrites(ctClass, identityHashMap);
    }

    private PersistentAttributeDescriptor enhancePersistentAttribute(CtClass ctClass, CtField ctField) {
        try {
            AttributeTypeDescriptor attributeTypeDescriptor = this.resolveAttributeTypeDescriptor(ctField);
            return new PersistentAttributeDescriptor(ctField, this.generateFieldReader(ctClass, ctField, attributeTypeDescriptor), this.generateFieldWriter(ctClass, ctField, attributeTypeDescriptor), attributeTypeDescriptor);
        }
        catch (Exception exception) {
            throw new EnhancementException(String.format("Unable to enhance persistent attribute [%s:%s]", ctClass.getName(), ctField.getName()), exception);
        }
    }

    private CtField[] collectPersistentFields(CtClass ctClass) {
        ArrayList<CtField> arrayList = new ArrayList<CtField>();
        for (CtField ctField : ctClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith("$") || !this.enhancementContext.isPersistentField(ctField)) continue;
            arrayList.add(ctField);
        }
        return this.enhancementContext.order(arrayList.toArray(new CtField[arrayList.size()]));
    }

    private void addInterceptorHandling(CtClass ctClass) {
        if (this.enhancementContext.doDirtyCheckingInline(ctClass) && !this.enhancementContext.hasLazyLoadableAttributes(ctClass)) {
            return;
        }
        log.debug("Weaving in PersistentAttributeInterceptable implementation");
        ctClass.addInterface(this.attributeInterceptableCtClass);
        this.addFieldWithGetterAndSetter(ctClass, this.attributeInterceptorCtClass, INTERCEPTOR_FIELD_NAME, INTERCEPTOR_GETTER_NAME, INTERCEPTOR_SETTER_NAME);
    }

    private void addInLineDirtyHandling(CtClass ctClass) {
    }

    private void addFieldWithGetterAndSetter(CtClass ctClass, CtClass ctClass2, String string, String string2, String string3) {
        CtField ctField = this.addField(ctClass, ctClass2, string, true);
        this.addGetter(ctClass, ctField, string2);
        this.addSetter(ctClass, ctField, string3);
    }

    private CtField addField(CtClass ctClass, CtClass ctClass2, String string, boolean bl) {
        CtField ctField;
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        try {
            ctField = new CtField(ctClass2, string, ctClass);
            ctClass.addField(ctField);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new EnhancementException(String.format("Could not enhance class [%s] to add field [%s]", ctClass.getName(), string), cannotCompileException);
        }
        if (bl) {
            ctField.setModifiers(ctField.getModifiers() | 0x80);
        }
        ctField.setModifiers(Modifier.setPrivate((int)ctField.getModifiers()));
        AnnotationsAttribute annotationsAttribute = this.getVisibleAnnotations(ctField.getFieldInfo());
        annotationsAttribute.addAnnotation(new Annotation(Transient.class.getName(), constPool));
        return ctField;
    }

    private void addGetter(CtClass ctClass, CtField ctField, String string) {
        try {
            ctClass.addMethod(CtNewMethod.getter((String)string, (CtField)ctField));
        }
        catch (CannotCompileException cannotCompileException) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add getter method [%s]", ctClass.getName(), string), cannotCompileException);
        }
    }

    private void addSetter(CtClass ctClass, CtField ctField, String string) {
        try {
            ctClass.addMethod(CtNewMethod.setter((String)string, (CtField)ctField));
        }
        catch (CannotCompileException cannotCompileException) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add setter method [%s]", ctClass.getName(), string), cannotCompileException);
        }
    }

    private CtMethod generateFieldReader(CtClass ctClass, CtField ctField, AttributeTypeDescriptor attributeTypeDescriptor) throws BadBytecode, CannotCompileException {
        FieldInfo fieldInfo = ctField.getFieldInfo();
        String string = fieldInfo.getName();
        String string2 = PERSISTENT_FIELD_READER_PREFIX + string;
        if (!this.enhancementContext.isLazyLoadable(ctField)) {
            try {
                CtMethod ctMethod = CtNewMethod.getter((String)string2, (CtField)ctField);
                ctClass.addMethod(ctMethod);
                return ctMethod;
            }
            catch (CannotCompileException cannotCompileException) {
                throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", ctClass.getName(), string2), cannotCompileException);
            }
        }
        String string3 = attributeTypeDescriptor.buildReadInterceptionBodyFragment(string) + " return this." + string + ";";
        try {
            CtMethod ctMethod = CtNewMethod.make((int)2, (CtClass)ctField.getType(), (String)string2, null, null, (String)("{" + string3 + "}"), (CtClass)ctClass);
            ctClass.addMethod(ctMethod);
            return ctMethod;
        }
        catch (Exception exception) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", ctClass.getName(), string2), exception);
        }
    }

    private CtMethod generateFieldWriter(CtClass ctClass, CtField ctField, AttributeTypeDescriptor attributeTypeDescriptor) {
        FieldInfo fieldInfo = ctField.getFieldInfo();
        String string = fieldInfo.getName();
        String string2 = PERSISTENT_FIELD_WRITER_PREFIX + string;
        try {
            CtMethod ctMethod;
            if (!this.enhancementContext.isLazyLoadable(ctField)) {
                ctMethod = CtNewMethod.setter((String)string2, (CtField)ctField);
            } else {
                String string3 = attributeTypeDescriptor.buildWriteInterceptionBodyFragment(string);
                ctMethod = CtNewMethod.make((int)2, (CtClass)CtClass.voidType, (String)string2, (CtClass[])new CtClass[]{ctField.getType()}, null, (String)("{" + string3 + "}"), (CtClass)ctClass);
            }
            if (this.enhancementContext.doDirtyCheckingInline(ctClass)) {
                ctMethod.insertBefore(attributeTypeDescriptor.buildInLineDirtyCheckingBodyFragment(string));
            }
            ctClass.addMethod(ctMethod);
            return ctMethod;
        }
        catch (Exception exception) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field writer method [%s]", ctClass.getName(), string2), exception);
        }
    }

    private void transformFieldAccessesIntoReadsAndWrites(CtClass ctClass, IdentityHashMap<String, PersistentAttributeDescriptor> identityHashMap) {
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        for (Object e : ctClass.getClassFile().getMethods()) {
            CodeAttribute codeAttribute;
            MethodInfo methodInfo = (MethodInfo)e;
            String string = methodInfo.getName();
            if (string.startsWith(PERSISTENT_FIELD_READER_PREFIX) || string.startsWith(PERSISTENT_FIELD_WRITER_PREFIX) || string.equals(ENTITY_INSTANCE_GETTER_NAME) || string.equals(ENTITY_ENTRY_GETTER_NAME) || string.equals(ENTITY_ENTRY_SETTER_NAME) || string.equals(PREVIOUS_GETTER_NAME) || string.equals(PREVIOUS_SETTER_NAME) || string.equals(NEXT_GETTER_NAME) || string.equals(NEXT_SETTER_NAME) || (codeAttribute = methodInfo.getCodeAttribute()) == null) continue;
            try {
                CodeIterator codeIterator = codeAttribute.iterator();
                while (codeIterator.hasNext()) {
                    int n;
                    int n2;
                    String string2;
                    PersistentAttributeDescriptor persistentAttributeDescriptor;
                    int n3 = codeIterator.next();
                    int n4 = codeIterator.byteAt(n3);
                    if (n4 != 181 && n4 != 180 || (persistentAttributeDescriptor = identityHashMap.get(string2 = constPool.getFieldrefName(n2 = codeIterator.u16bitAt(n3 + 1)))) == null) continue;
                    log.tracef("Transforming access to field [%s] from method [%s]", (Object)string2, (Object)string);
                    if (n4 == 180) {
                        n = constPool.addMethodrefInfo(constPool.getThisClassInfo(), persistentAttributeDescriptor.getReader().getName(), persistentAttributeDescriptor.getReader().getSignature());
                        codeIterator.writeByte(183, n3);
                        codeIterator.write16bit(n, n3 + 1);
                        continue;
                    }
                    n = constPool.addMethodrefInfo(constPool.getThisClassInfo(), persistentAttributeDescriptor.getWriter().getName(), persistentAttributeDescriptor.getWriter().getSignature());
                    codeIterator.writeByte(183, n3);
                    codeIterator.write16bit(n, n3 + 1);
                }
                StackMapTable stackMapTable = MapMaker.make((ClassPool)this.classPool, (MethodInfo)methodInfo);
                methodInfo.getCodeAttribute().setAttribute(stackMapTable);
            }
            catch (BadBytecode badBytecode) {
                throw new EnhancementException("Unable to perform field access transformation in method : " + string, badBytecode);
            }
        }
    }

    private AttributeTypeDescriptor resolveAttributeTypeDescriptor(CtField ctField) throws NotFoundException {
        if (ctField.getType() == CtClass.booleanType) {
            return BOOLEAN_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.byteType) {
            return BYTE_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.charType) {
            return CHAR_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.shortType) {
            return SHORT_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.intType) {
            return INT_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.longType) {
            return LONG_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.doubleType) {
            return DOUBLE_DESCRIPTOR;
        }
        if (ctField.getType() == CtClass.floatType) {
            return FLOAT_DESCRIPTOR;
        }
        return new ObjectAttributeTypeDescriptor(ctField.getType());
    }

    private static class ObjectAttributeTypeDescriptor
    extends AbstractAttributeTypeDescriptor {
        private final CtClass concreteType;

        private ObjectAttributeTypeDescriptor(CtClass ctClass) {
            this.concreteType = ctClass;
        }

        public String buildReadInterceptionBodyFragment(String string) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = (%2$s) $$_hibernate_getInterceptor().readObject(this, \"%1$s\", this.%1$s); }", string, this.concreteType.getName());
        }

        public String buildWriteInterceptionBodyFragment(String string) {
            return String.format("%2$s localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = (%2$s) $$_hibernate_getInterceptor().writeObject(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", string, this.concreteType.getName());
        }
    }

    private static abstract class AbstractAttributeTypeDescriptor
    implements AttributeTypeDescriptor {
        private AbstractAttributeTypeDescriptor() {
        }

        public String buildInLineDirtyCheckingBodyFragment(String string) {
            return String.format("System.out.println( \"DIRTY CHECK (%1$s) : \" + this.%1$s + \" -> \" + $1 + \" (dirty=\" + (this.%1$s != $1) +\")\" );", string);
        }
    }

    private static interface AttributeTypeDescriptor {
        public String buildReadInterceptionBodyFragment(String var1);

        public String buildWriteInterceptionBodyFragment(String var1);

        public String buildInLineDirtyCheckingBodyFragment(String var1);
    }

    private static class PersistentAttributeDescriptor {
        private final CtField field;
        private final CtMethod reader;
        private final CtMethod writer;
        private final AttributeTypeDescriptor typeDescriptor;

        private PersistentAttributeDescriptor(CtField ctField, CtMethod ctMethod, CtMethod ctMethod2, AttributeTypeDescriptor attributeTypeDescriptor) {
            this.field = ctField;
            this.reader = ctMethod;
            this.writer = ctMethod2;
            this.typeDescriptor = attributeTypeDescriptor;
        }

        public CtField getField() {
            return this.field;
        }

        public CtMethod getReader() {
            return this.reader;
        }

        public CtMethod getWriter() {
            return this.writer;
        }

        public AttributeTypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }
    }
}

