/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;

public class BasicClassFilter
implements ClassFilter {
    private final String[] includedPackages;
    private final Set<String> includedClassNames = new HashSet<String>();
    private final boolean isAllEmpty;

    public BasicClassFilter() {
        this(null, null);
    }

    public BasicClassFilter(String[] stringArray, String[] stringArray2) {
        this.includedPackages = stringArray;
        if (stringArray2 != null) {
            this.includedClassNames.addAll(Arrays.asList(stringArray2));
        }
        this.isAllEmpty = (this.includedPackages == null || this.includedPackages.length == 0) && this.includedClassNames.isEmpty();
    }

    public boolean shouldInstrumentClass(String string) {
        return this.isAllEmpty || this.includedClassNames.contains(string) || this.isInIncludedPackage(string);
    }

    private boolean isInIncludedPackage(String string) {
        if (this.includedPackages != null) {
            for (String string2 : this.includedPackages) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

