/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.hibernate.bytecode.buildtime.spi.AbstractInstrumenter;
import org.hibernate.bytecode.buildtime.spi.BasicClassFilter;
import org.hibernate.bytecode.buildtime.spi.ClassDescriptor;
import org.hibernate.bytecode.buildtime.spi.Instrumenter;
import org.hibernate.bytecode.buildtime.spi.Logger;
import org.hibernate.bytecode.internal.javassist.BytecodeProviderImpl;
import org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.hibernate.bytecode.spi.ClassTransformer;

public class JavassistInstrumenter
extends AbstractInstrumenter {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();

    public JavassistInstrumenter(Logger logger2, Instrumenter.Options options) {
        super(logger2, options);
    }

    protected ClassDescriptor getClassDescriptor(byte[] byArray) throws IOException {
        return new CustomClassDescriptor(byArray);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor classDescriptor, Set set) {
        if (classDescriptor.isInstrumented()) {
            this.logger.debug("class [" + classDescriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new AbstractInstrumenter.CustomFieldFilter(this, classDescriptor, set));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytes;
        private final ClassFile classFile;

        public CustomClassDescriptor(byte[] byArray) throws IOException {
            this.bytes = byArray;
            this.classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
        }

        public String getName() {
            return this.classFile.getName();
        }

        public boolean isInstrumented() {
            String[] stringArray;
            for (String string : stringArray = this.classFile.getInterfaces()) {
                if (!FieldHandled.class.getName().equals(string)) continue;
                return true;
            }
            return false;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

