/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.spi.access.AccessType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheConcurrencyStrategy {
    NONE(null),
    READ_ONLY(AccessType.READ_ONLY),
    NONSTRICT_READ_WRITE(AccessType.NONSTRICT_READ_WRITE),
    READ_WRITE(AccessType.READ_WRITE),
    TRANSACTIONAL(AccessType.TRANSACTIONAL);

    private final AccessType accessType;

    private CacheConcurrencyStrategy(AccessType accessType) {
        this.accessType = accessType;
    }

    private boolean isMatch(String string) {
        return this.accessType != null && this.accessType.getExternalName().equalsIgnoreCase(string) || this.name().equalsIgnoreCase(string);
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        if (null == accessType) {
            return NONE;
        }
        switch (accessType) {
            case READ_ONLY: {
                return READ_ONLY;
            }
            case READ_WRITE: {
                return READ_WRITE;
            }
            case NONSTRICT_READ_WRITE: {
                return NONSTRICT_READ_WRITE;
            }
            case TRANSACTIONAL: {
                return TRANSACTIONAL;
            }
        }
        return NONE;
    }

    public static CacheConcurrencyStrategy parse(String string) {
        if (READ_ONLY.isMatch(string)) {
            return READ_ONLY;
        }
        if (READ_WRITE.isMatch(string)) {
            return READ_WRITE;
        }
        if (NONSTRICT_READ_WRITE.isMatch(string)) {
            return NONSTRICT_READ_WRITE;
        }
        if (TRANSACTIONAL.isMatch(string)) {
            return TRANSACTIONAL;
        }
        if (NONE.isMatch(string)) {
            return NONE;
        }
        return null;
    }

    public AccessType toAccessType() {
        return this.accessType;
    }
}

