/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.PropertyValueException;
import org.hibernate.TransientPropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedEntityInsertActions {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, UnresolvedEntityInsertActions.class.getName());
    private static final int INIT_SIZE = 5;
    private final Map<AbstractEntityInsertAction, NonNullableTransientDependencies> dependenciesByAction = new IdentityHashMap<AbstractEntityInsertAction, NonNullableTransientDependencies>(5);
    private final Map<Object, Set<AbstractEntityInsertAction>> dependentActionsByTransientEntity = new IdentityHashMap<Object, Set<AbstractEntityInsertAction>>(5);

    public void addUnresolvedEntityInsertAction(AbstractEntityInsertAction abstractEntityInsertAction, NonNullableTransientDependencies nonNullableTransientDependencies) {
        if (nonNullableTransientDependencies == null || nonNullableTransientDependencies.isEmpty()) {
            throw new IllegalArgumentException("Attempt to add an unresolved insert action that has no non-nullable transient entities.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", (Object)abstractEntityInsertAction, (Object)nonNullableTransientDependencies.toLoggableString(abstractEntityInsertAction.getSession()));
        }
        this.dependenciesByAction.put(abstractEntityInsertAction, nonNullableTransientDependencies);
        this.addDependenciesByTransientEntity(abstractEntityInsertAction, nonNullableTransientDependencies);
    }

    public Iterable<AbstractEntityInsertAction> getDependentEntityInsertActions() {
        return this.dependenciesByAction.keySet();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        if (!this.isEmpty()) {
            AbstractEntityInsertAction abstractEntityInsertAction = this.dependenciesByAction.keySet().iterator().next();
            this.logCannotResolveNonNullableTransientDependencies(abstractEntityInsertAction.getSession());
            NonNullableTransientDependencies nonNullableTransientDependencies = this.dependenciesByAction.get(abstractEntityInsertAction);
            Object object = nonNullableTransientDependencies.getNonNullableTransientEntities().iterator().next();
            String string = nonNullableTransientDependencies.getNonNullableTransientPropertyPaths(object).iterator().next();
            throw new TransientPropertyValueException("Not-null property references a transient value - transient instance must be saved before current operation", abstractEntityInsertAction.getSession().guessEntityName(object), abstractEntityInsertAction.getEntityName(), string);
        }
        LOG.trace("No entity insert actions have non-nullable, transient entity dependencies.");
    }

    private void logCannotResolveNonNullableTransientDependencies(SessionImplementor sessionImplementor) {
        for (Map.Entry<Object, Set<AbstractEntityInsertAction>> entry : this.dependentActionsByTransientEntity.entrySet()) {
            Object object = entry.getKey();
            String string = sessionImplementor.guessEntityName(object);
            Serializable serializable = sessionImplementor.getFactory().getEntityPersister(string).getIdentifier(object, sessionImplementor);
            String string2 = MessageHelper.infoString(string, serializable);
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (AbstractEntityInsertAction abstractEntityInsertAction : entry.getValue()) {
                treeSet.add(MessageHelper.infoString(abstractEntityInsertAction.getEntityName(), abstractEntityInsertAction.getId()));
                for (String string3 : this.dependenciesByAction.get(abstractEntityInsertAction).getNonNullableTransientPropertyPaths(object)) {
                    String string4 = new StringBuilder(abstractEntityInsertAction.getEntityName().length() + string3.length() + 1).append(abstractEntityInsertAction.getEntityName()).append('.').append(string3).toString();
                    treeSet2.add(string4);
                }
            }
            LOG.cannotResolveNonNullableTransientDependencies(string2, treeSet, treeSet2);
        }
    }

    public boolean isEmpty() {
        return this.dependenciesByAction.isEmpty();
    }

    private void addDependenciesByTransientEntity(AbstractEntityInsertAction abstractEntityInsertAction, NonNullableTransientDependencies nonNullableTransientDependencies) {
        for (Object object : nonNullableTransientDependencies.getNonNullableTransientEntities()) {
            IdentitySet identitySet = this.dependentActionsByTransientEntity.get(object);
            if (identitySet == null) {
                identitySet = new IdentitySet();
                this.dependentActionsByTransientEntity.put(object, identitySet);
            }
            identitySet.add((AbstractEntityInsertAction)abstractEntityInsertAction);
        }
    }

    public Set<AbstractEntityInsertAction> resolveDependentActions(Object object, SessionImplementor sessionImplementor) {
        EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object);
        if (entityEntry.getStatus() != Status.MANAGED && entityEntry.getStatus() != Status.READ_ONLY) {
            throw new IllegalArgumentException("EntityEntry did not have status MANAGED or READ_ONLY: " + entityEntry);
        }
        boolean bl = LOG.isTraceEnabled();
        Set<AbstractEntityInsertAction> set = this.dependentActionsByTransientEntity.remove(object);
        if (set == null) {
            if (bl) {
                LOG.tracev("No unresolved entity inserts that depended on [{0}]", (Object)MessageHelper.infoString(entityEntry.getEntityName(), entityEntry.getId()));
            }
            return Collections.emptySet();
        }
        IdentitySet identitySet = new IdentitySet();
        if (bl) {
            LOG.tracev("Unresolved inserts before resolving [{0}]: [{1}]", (Object)MessageHelper.infoString(entityEntry.getEntityName(), entityEntry.getId()), (Object)this.toString());
        }
        for (AbstractEntityInsertAction abstractEntityInsertAction : set) {
            if (bl) {
                LOG.tracev("Resolving insert [{0}] dependency on [{1}]", (Object)MessageHelper.infoString(abstractEntityInsertAction.getEntityName(), abstractEntityInsertAction.getId()), (Object)MessageHelper.infoString(entityEntry.getEntityName(), entityEntry.getId()));
            }
            NonNullableTransientDependencies nonNullableTransientDependencies = this.dependenciesByAction.get(abstractEntityInsertAction);
            nonNullableTransientDependencies.resolveNonNullableTransientEntity(object);
            if (!nonNullableTransientDependencies.isEmpty()) continue;
            if (bl) {
                LOG.tracev("Resolving insert [{0}] (only depended on [{1}])", (Object)abstractEntityInsertAction, (Object)MessageHelper.infoString(entityEntry.getEntityName(), entityEntry.getId()));
            }
            this.dependenciesByAction.remove(abstractEntityInsertAction);
            identitySet.add(abstractEntityInsertAction);
        }
        if (bl) {
            LOG.tracev("Unresolved inserts after resolving [{0}]: [{1}]", (Object)MessageHelper.infoString(entityEntry.getEntityName(), entityEntry.getId()), (Object)this.toString());
        }
        return identitySet;
    }

    public void clear() {
        this.dependenciesByAction.clear();
        this.dependentActionsByTransientEntity.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        for (Map.Entry<AbstractEntityInsertAction, NonNullableTransientDependencies> entry : this.dependenciesByAction.entrySet()) {
            AbstractEntityInsertAction abstractEntityInsertAction = entry.getKey();
            NonNullableTransientDependencies nonNullableTransientDependencies = entry.getValue();
            stringBuilder.append("[insert=").append(abstractEntityInsertAction).append(" dependencies=[").append(nonNullableTransientDependencies.toLoggableString(abstractEntityInsertAction.getSession())).append("]");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.dependenciesByAction.size();
        LOG.tracev("Starting serialization of [{0}] unresolved insert entries", (Object)n);
        objectOutputStream.writeInt(n);
        for (AbstractEntityInsertAction abstractEntityInsertAction : this.dependenciesByAction.keySet()) {
            objectOutputStream.writeObject(abstractEntityInsertAction);
        }
    }

    public static UnresolvedEntityInsertActions deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        UnresolvedEntityInsertActions unresolvedEntityInsertActions = new UnresolvedEntityInsertActions();
        int n = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] unresolved insert entries", (Object)n);
        for (int i = 0; i < n; ++i) {
            AbstractEntityInsertAction abstractEntityInsertAction = (AbstractEntityInsertAction)objectInputStream.readObject();
            abstractEntityInsertAction.afterDeserialize(sessionImplementor);
            unresolvedEntityInsertActions.addUnresolvedEntityInsertAction(abstractEntityInsertAction, abstractEntityInsertAction.findNonNullableTransientEntities());
        }
        return unresolvedEntityInsertActions;
    }
}

