/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.OptimisticLockException;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class EntityVerifyVersionProcess
implements BeforeTransactionCompletionProcess {
    private final Object object;
    private final EntityEntry entry;

    public EntityVerifyVersionProcess(Object object, EntityEntry entityEntry) {
        this.object = object;
        this.entry = entityEntry;
    }

    public void doBeforeTransactionCompletion(SessionImplementor sessionImplementor) {
        EntityPersister entityPersister = this.entry.getPersister();
        Object object = entityPersister.getCurrentVersion(this.entry.getId(), sessionImplementor);
        if (!this.entry.getVersion().equals(object)) {
            throw new OptimisticLockException(this.object, "Newer version [" + object + "] of entity [" + MessageHelper.infoString(this.entry.getEntityName(), this.entry.getId()) + "] found in database");
        }
    }
}

