/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeHelper;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private final Object[] previousNaturalIdValues;
    private Object nextVersion;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Serializable serializable, Object[] objectArray, int[] nArray, boolean bl, Object[] objectArray2, Object object, Object object2, Object object3, Object object4, EntityPersister entityPersister, SessionImplementor sessionImplementor) throws HibernateException {
        super(sessionImplementor, serializable, object3, entityPersister);
        this.state = objectArray;
        this.previousState = objectArray2;
        this.previousVersion = object;
        this.nextVersion = object2;
        this.dirtyFields = nArray;
        this.hasDirtyCollection = bl;
        this.rowId = object4;
        this.previousNaturalIdValues = this.determinePreviousNaturalIdValues(entityPersister, objectArray2, sessionImplementor, serializable);
        sessionImplementor.getPersistenceContext().getNaturalIdHelper().manageLocalNaturalIdCrossReference(entityPersister, serializable, objectArray, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
    }

    private Object[] determinePreviousNaturalIdValues(EntityPersister entityPersister, Object[] objectArray, SessionImplementor sessionImplementor, Serializable serializable) {
        if (!entityPersister.hasNaturalIdentifier()) {
            return null;
        }
        if (objectArray != null) {
            return sessionImplementor.getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(objectArray, entityPersister);
        }
        return sessionImplementor.getPersistenceContext().getNaturalIdSnapshot(serializable, entityPersister);
    }

    public void execute() throws HibernateException {
        EntityEntry entityEntry;
        CacheKey cacheKey;
        Serializable serializable = this.getId();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preUpdate();
        SessionFactoryImplementor sessionFactoryImplementor = this.getSession().getFactory();
        Object object2 = this.previousVersion;
        if (entityPersister.isVersionPropertyGenerated()) {
            object2 = entityPersister.getVersion(object);
        }
        if (entityPersister.hasCache()) {
            cacheKey = sessionImplementor.generateCacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            this.lock = entityPersister.getCacheAccessStrategy().lockItem(cacheKey, object2);
        } else {
            cacheKey = null;
        }
        if (!bl) {
            entityPersister.update(serializable, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, object2, object, this.rowId, sessionImplementor);
        }
        if ((entityEntry = this.getSession().getPersistenceContext().getEntry(object)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        if (entityEntry.getStatus() == Status.MANAGED || entityPersister.isVersionPropertyGenerated()) {
            TypeHelper.deepCopy(this.state, entityPersister.getPropertyTypes(), entityPersister.getPropertyCheckability(), this.state, sessionImplementor);
            if (entityPersister.hasUpdateGeneratedProperties()) {
                entityPersister.processUpdateGeneratedProperties(serializable, object, this.state, sessionImplementor);
                if (entityPersister.isVersionPropertyGenerated()) {
                    this.nextVersion = Versioning.getVersion(this.state, entityPersister);
                }
            }
            entityEntry.postUpdate(object, this.state, this.nextVersion);
        }
        if (entityPersister.hasCache()) {
            if (entityPersister.isCacheInvalidationRequired() || entityEntry.getStatus() != Status.MANAGED) {
                entityPersister.getCacheAccessStrategy().remove(cacheKey);
            } else {
                CacheEntry cacheEntry = entityPersister.buildCacheEntry(object, this.state, this.nextVersion, this.getSession());
                this.cacheEntry = entityPersister.getCacheEntryStructure().structure(cacheEntry);
                boolean bl2 = entityPersister.getCacheAccessStrategy().update(cacheKey, this.cacheEntry, this.nextVersion, object2);
                if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        sessionImplementor.getPersistenceContext().getNaturalIdHelper().manageSharedNaturalIdCrossReference(entityPersister, serializable, this.state, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
        this.postUpdate();
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled() && !bl) {
            sessionFactoryImplementor.getStatisticsImplementor().updateEntity(this.getPersister().getEntityName());
        }
    }

    private boolean preUpdate() {
        boolean bl = false;
        EventListenerGroup<PreUpdateEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_UPDATE);
        if (eventListenerGroup.isEmpty()) {
            return bl;
        }
        PreUpdateEvent preUpdateEvent = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), this.eventSource());
        for (PreUpdateEventListener preUpdateEventListener : eventListenerGroup.listeners()) {
            bl |= preUpdateEventListener.onPreUpdate(preUpdateEvent);
        }
        return bl;
    }

    private void postUpdate() {
        EventListenerGroup<PostUpdateEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_UPDATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent postUpdateEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
        for (PostUpdateEventListener postUpdateEventListener : eventListenerGroup.listeners()) {
            postUpdateEventListener.onPostUpdate(postUpdateEvent);
        }
    }

    private void postCommitUpdate() {
        EventListenerGroup<PostUpdateEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COMMIT_UPDATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent postUpdateEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getPersister(), this.eventSource());
        for (PostUpdateEventListener postUpdateEventListener : eventListenerGroup.listeners()) {
            postUpdateEventListener.onPostUpdate(postUpdateEvent);
        }
    }

    protected boolean hasPostCommitEventListeners() {
        return !this.listenerGroup(EventType.POST_COMMIT_UPDATE).isEmpty();
    }

    public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) throws CacheException {
        EntityPersister entityPersister = this.getPersister();
        if (entityPersister.hasCache()) {
            CacheKey cacheKey = this.getSession().generateCacheKey(this.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            if (bl && this.cacheEntry != null) {
                boolean bl2 = entityPersister.getCacheAccessStrategy().afterUpdate(cacheKey, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
                if (bl2 && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            } else {
                entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, this.lock);
            }
        }
        this.postCommitUpdate();
    }
}

