/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends AbstractEntityInsertAction {
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable serializable, Object[] objectArray, Object object, Object object2, EntityPersister entityPersister, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        super(serializable, objectArray, object, bl, entityPersister, sessionImplementor);
        this.version = object2;
    }

    public boolean isEarlyInsert() {
        return false;
    }

    protected EntityKey getEntityKey() {
        return this.getSession().generateEntityKey(this.getId(), this.getPersister());
    }

    public void execute() throws HibernateException {
        Serializable serializable;
        this.nullifyTransientReferencesIfNotAlready();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        Serializable serializable2 = this.getId();
        boolean bl = this.preInsert();
        if (!bl) {
            entityPersister.insert(serializable2, this.getState(), object, sessionImplementor);
            serializable = sessionImplementor.getPersistenceContext().getEntry(object);
            if (serializable == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            ((EntityEntry)serializable).postInsert(this.getState());
            if (entityPersister.hasInsertGeneratedProperties()) {
                entityPersister.processInsertGeneratedProperties(serializable2, object, this.getState(), sessionImplementor);
                if (entityPersister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.getState(), entityPersister);
                }
                ((EntityEntry)serializable).postUpdate(object, this.getState(), this.version);
            }
            this.getSession().getPersistenceContext().registerInsertedKey(this.getPersister(), this.getId());
        }
        serializable = this.getSession().getFactory();
        if (this.isCachePutEnabled(entityPersister, sessionImplementor)) {
            CacheEntry cacheEntry = entityPersister.buildCacheEntry(object, this.getState(), this.version, sessionImplementor);
            this.cacheEntry = entityPersister.getCacheEntryStructure().structure(cacheEntry);
            CacheKey cacheKey = sessionImplementor.generateCacheKey(serializable2, entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            boolean bl2 = entityPersister.getCacheAccessStrategy().insert(cacheKey, this.cacheEntry, this.version);
            if (bl2 && serializable.getStatistics().isStatisticsEnabled()) {
                serializable.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
            }
        }
        this.handleNaturalIdPostSaveNotifications(serializable2);
        this.postInsert();
        if (serializable.getStatistics().isStatisticsEnabled() && !bl) {
            serializable.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_INSERT);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener postInsertEventListener : eventListenerGroup.listeners()) {
            postInsertEventListener.onPostInsert(postInsertEvent);
        }
    }

    private void postCommitInsert() {
        EventListenerGroup<PostInsertEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener postInsertEventListener : eventListenerGroup.listeners()) {
            postInsertEventListener.onPostInsert(postInsertEvent);
        }
    }

    private boolean preInsert() {
        boolean bl = false;
        EventListenerGroup<PreInsertEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (eventListenerGroup.isEmpty()) {
            return bl;
        }
        PreInsertEvent preInsertEvent = new PreInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PreInsertEventListener preInsertEventListener : eventListenerGroup.listeners()) {
            bl |= preInsertEventListener.onPreInsert(preInsertEvent);
        }
        return bl;
    }

    public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        EntityPersister entityPersister = this.getPersister();
        if (bl && this.isCachePutEnabled(entityPersister, this.getSession())) {
            CacheKey cacheKey = this.getSession().generateCacheKey(this.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            boolean bl2 = entityPersister.getCacheAccessStrategy().afterInsert(cacheKey, this.cacheEntry, this.version);
            if (bl2 && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
            }
        }
        this.postCommitInsert();
    }

    protected boolean hasPostCommitEventListeners() {
        return !this.listenerGroup(EventType.POST_COMMIT_INSERT).isEmpty();
    }

    private boolean isCachePutEnabled(EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        return entityPersister.hasCache() && !entityPersister.isCacheInvalidationRequired() && sessionImplementor.getCacheMode().isPutEnabled();
    }
}

