/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends AbstractEntityInsertAction {
    private final boolean isDelayed;
    private final EntityKey delayedEntityKey;
    private EntityKey entityKey;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] objectArray, Object object, EntityPersister entityPersister, boolean bl, SessionImplementor sessionImplementor, boolean bl2) throws HibernateException {
        super(bl2 ? EntityIdentityInsertAction.generateDelayedPostInsertIdentifier() : null, objectArray, object, bl, entityPersister, sessionImplementor);
        this.isDelayed = bl2;
        this.delayedEntityKey = bl2 ? this.generateDelayedEntityKey() : null;
    }

    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preInsert();
        if (!bl) {
            this.generatedId = entityPersister.insert(this.getState(), object, sessionImplementor);
            if (entityPersister.hasInsertGeneratedProperties()) {
                entityPersister.processInsertGeneratedProperties(this.generatedId, object, this.getState(), sessionImplementor);
            }
            entityPersister.setIdentifier(object, this.generatedId, sessionImplementor);
            sessionImplementor.getPersistenceContext().registerInsertedKey(this.getPersister(), this.generatedId);
            this.entityKey = sessionImplementor.generateEntityKey(this.generatedId, entityPersister);
            sessionImplementor.getPersistenceContext().checkUniqueness(this.entityKey, this.getInstance());
        }
        this.postInsert();
        if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled() && !bl) {
            sessionImplementor.getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    public boolean needsAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    protected boolean hasPostCommitEventListeners() {
        return !this.listenerGroup(EventType.POST_COMMIT_INSERT).isEmpty();
    }

    public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
        this.postCommitInsert();
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> eventListenerGroup;
        if (this.isDelayed) {
            this.getSession().getPersistenceContext().replaceDelayedEntityIdentityInsertKeys(this.delayedEntityKey, this.generatedId);
        }
        if ((eventListenerGroup = this.listenerGroup(EventType.POST_INSERT)).isEmpty()) {
            return;
        }
        PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener postInsertEventListener : eventListenerGroup.listeners()) {
            postInsertEventListener.onPostInsert(postInsertEvent);
        }
    }

    private void postCommitInsert() {
        EventListenerGroup<PostInsertEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener postInsertEventListener : eventListenerGroup.listeners()) {
            postInsertEventListener.onPostInsert(postInsertEvent);
        }
    }

    private boolean preInsert() {
        EventListenerGroup<PreInsertEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (eventListenerGroup.isEmpty()) {
            return false;
        }
        boolean bl = false;
        PreInsertEvent preInsertEvent = new PreInsertEvent(this.getInstance(), null, this.getState(), this.getPersister(), this.eventSource());
        for (PreInsertEventListener preInsertEventListener : eventListenerGroup.listeners()) {
            bl |= preInsertEventListener.onPreInsert(preInsertEvent);
        }
        return bl;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }

    public EntityKey getDelayedEntityKey() {
        return this.delayedEntityKey;
    }

    public boolean isEarlyInsert() {
        return !this.isDelayed;
    }

    protected EntityKey getEntityKey() {
        return this.entityKey != null ? this.entityKey : this.delayedEntityKey;
    }

    private static synchronized DelayedPostInsertIdentifier generateDelayedPostInsertIdentifier() {
        return new DelayedPostInsertIdentifier();
    }

    private EntityKey generateDelayedEntityKey() {
        if (!this.isDelayed) {
            throw new AssertionFailure("cannot request delayed entity-key for early-insert post-insert-id generation");
        }
        return this.getSession().generateEntityKey(this.getDelayedId(), this.getPersister());
    }
}

