/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityDeleteAction
extends EntityAction {
    private final Object version;
    private final boolean isCascadeDeleteEnabled;
    private final Object[] state;
    private SoftLock lock;
    private Object[] naturalIdValues;

    public EntityDeleteAction(Serializable serializable, Object[] objectArray, Object object, Object object2, EntityPersister entityPersister, boolean bl, SessionImplementor sessionImplementor) {
        super(sessionImplementor, serializable, object2, entityPersister);
        this.version = object;
        this.isCascadeDeleteEnabled = bl;
        this.state = objectArray;
        this.naturalIdValues = sessionImplementor.getPersistenceContext().getNaturalIdHelper().removeLocalNaturalIdCrossReference(this.getPersister(), this.getId(), objectArray);
    }

    public void execute() throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entityEntry;
        CacheKey cacheKey;
        Serializable serializable = this.getId();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preDelete();
        Object object2 = this.version;
        if (entityPersister.isVersionPropertyGenerated()) {
            object2 = entityPersister.getVersion(object);
        }
        if (entityPersister.hasCache()) {
            cacheKey = sessionImplementor.generateCacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            this.lock = entityPersister.getCacheAccessStrategy().lockItem(cacheKey, object2);
        } else {
            cacheKey = null;
        }
        if (!this.isCascadeDeleteEnabled && !bl) {
            entityPersister.delete(serializable, object2, object, sessionImplementor);
        }
        if ((entityEntry = (persistenceContext = sessionImplementor.getPersistenceContext()).removeEntry(object)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entityEntry.postDelete();
        persistenceContext.removeEntity(entityEntry.getEntityKey());
        persistenceContext.removeProxy(entityEntry.getEntityKey());
        if (entityPersister.hasCache()) {
            entityPersister.getCacheAccessStrategy().remove(cacheKey);
        }
        persistenceContext.getNaturalIdHelper().removeSharedNaturalIdCrossReference(entityPersister, serializable, this.naturalIdValues);
        this.postDelete();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled() && !bl) {
            this.getSession().getFactory().getStatisticsImplementor().deleteEntity(this.getPersister().getEntityName());
        }
    }

    private boolean preDelete() {
        boolean bl = false;
        EventListenerGroup<PreDeleteEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_DELETE);
        if (eventListenerGroup.isEmpty()) {
            return bl;
        }
        PreDeleteEvent preDeleteEvent = new PreDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PreDeleteEventListener preDeleteEventListener : eventListenerGroup.listeners()) {
            bl |= preDeleteEventListener.onPreDelete(preDeleteEvent);
        }
        return bl;
    }

    private void postDelete() {
        EventListenerGroup<PostDeleteEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_DELETE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostDeleteEvent postDeleteEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PostDeleteEventListener postDeleteEventListener : eventListenerGroup.listeners()) {
            postDeleteEventListener.onPostDelete(postDeleteEvent);
        }
    }

    private void postCommitDelete() {
        EventListenerGroup<PostDeleteEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COMMIT_DELETE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostDeleteEvent postDeleteEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PostDeleteEventListener postDeleteEventListener : eventListenerGroup.listeners()) {
            postDeleteEventListener.onPostDelete(postDeleteEvent);
        }
    }

    public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.getPersister().hasCache()) {
            CacheKey cacheKey = this.getSession().generateCacheKey(this.getId(), this.getPersister().getIdentifierType(), this.getPersister().getRootEntityName());
            this.getPersister().getCacheAccessStrategy().unlockItem(cacheKey, this.lock);
        }
        this.postCommitDelete();
    }

    protected boolean hasPostCommitEventListeners() {
        return !this.listenerGroup(EventType.POST_COMMIT_DELETE).isEmpty();
    }
}

