/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
        this.emptySnapshot = bl;
    }

    public void execute() throws HibernateException {
        Serializable serializable = this.getKey();
        SessionImplementor sessionImplementor = this.getSession();
        CollectionPersister collectionPersister = this.getPersister();
        PersistentCollection persistentCollection = this.getCollection();
        boolean bl = collectionPersister.isAffectedByEnabledFilters(sessionImplementor);
        this.preUpdate();
        if (!persistentCollection.wasInitialized()) {
            if (!persistentCollection.hasQueuedOperations()) {
                throw new AssertionFailure("no queued adds");
            }
        } else if (!bl && persistentCollection.empty()) {
            if (!this.emptySnapshot) {
                collectionPersister.remove(serializable, sessionImplementor);
            }
        } else if (persistentCollection.needsRecreate(collectionPersister)) {
            if (bl) {
                throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(collectionPersister, persistentCollection, serializable, sessionImplementor));
            }
            if (!this.emptySnapshot) {
                collectionPersister.remove(serializable, sessionImplementor);
            }
            collectionPersister.recreate(persistentCollection, serializable, sessionImplementor);
        } else {
            collectionPersister.deleteRows(persistentCollection, serializable, sessionImplementor);
            collectionPersister.updateRows(persistentCollection, serializable, sessionImplementor);
            collectionPersister.insertRows(persistentCollection, serializable, sessionImplementor);
        }
        this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        this.evict();
        this.postUpdate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().updateCollection(this.getPersister().getRole());
        }
    }

    private void preUpdate() {
        EventListenerGroup<PreCollectionUpdateEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_UPDATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PreCollectionUpdateEvent preCollectionUpdateEvent = new PreCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionUpdateEventListener preCollectionUpdateEventListener : eventListenerGroup.listeners()) {
            preCollectionUpdateEventListener.onPreUpdateCollection(preCollectionUpdateEvent);
        }
    }

    private void postUpdate() {
        EventListenerGroup<PostCollectionUpdateEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COLLECTION_UPDATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostCollectionUpdateEvent postCollectionUpdateEvent = new PostCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionUpdateEventListener postCollectionUpdateEventListener : eventListenerGroup.listeners()) {
            postCollectionUpdateEventListener.onPostUpdateCollection(postCollectionUpdateEvent);
        }
    }
}

