/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEvent;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRemoveAction
extends CollectionAction {
    private boolean emptySnapshot;
    private final Object affectedOwner;

    public CollectionRemoveAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
        if (persistentCollection == null) {
            throw new AssertionFailure("collection == null");
        }
        this.emptySnapshot = bl;
        this.affectedOwner = sessionImplementor.getPersistenceContext().getLoadedCollectionOwnerOrNull(persistentCollection);
    }

    public CollectionRemoveAction(Object object, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) {
        super(collectionPersister, null, serializable, sessionImplementor);
        if (object == null) {
            throw new AssertionFailure("affectedOwner == null");
        }
        this.emptySnapshot = bl;
        this.affectedOwner = object;
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection;
        this.preRemove();
        if (!this.emptySnapshot) {
            this.getPersister().remove(this.getKey(), this.getSession());
        }
        if ((persistentCollection = this.getCollection()) != null) {
            this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        }
        this.evict();
        this.postRemove();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().removeCollection(this.getPersister().getRole());
        }
    }

    private void preRemove() {
        EventListenerGroup<PreCollectionRemoveEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_REMOVE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRemoveEvent preCollectionRemoveEvent = new PreCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
        for (PreCollectionRemoveEventListener preCollectionRemoveEventListener : eventListenerGroup.listeners()) {
            preCollectionRemoveEventListener.onPreRemoveCollection(preCollectionRemoveEvent);
        }
    }

    private void postRemove() {
        EventListenerGroup<PostCollectionRemoveEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COLLECTION_REMOVE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRemoveEvent postCollectionRemoveEvent = new PostCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
        for (PostCollectionRemoveEventListener postCollectionRemoveEventListener : eventListenerGroup.listeners()) {
            postCollectionRemoveEventListener.onPostRemoveCollection(postCollectionRemoveEvent);
        }
    }
}

