/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection = this.getCollection();
        this.preRecreate();
        this.getPersister().recreate(persistentCollection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        this.evict();
        this.postRecreate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().recreateCollection(this.getPersister().getRole());
        }
    }

    private void preRecreate() {
        EventListenerGroup<PreCollectionRecreateEventListener> eventListenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent preCollectionRecreateEvent = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener preCollectionRecreateEventListener : eventListenerGroup.listeners()) {
            preCollectionRecreateEventListener.onPreRecreateCollection(preCollectionRecreateEvent);
        }
    }

    private void postRecreate() {
        EventListenerGroup<PostCollectionRecreateEventListener> eventListenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (eventListenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent postCollectionRecreateEvent = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener postCollectionRecreateEventListener : eventListenerGroup.listeners()) {
            postCollectionRecreateEventListener.onPostRecreateCollection(postCollectionRecreateEvent);
        }
    }
}

