/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private transient SessionImplementor session;
    private final PersistentCollection collection;
    private final Serializable key;
    private final String collectionRole;
    private AfterTransactionCompletionProcess afterTransactionProcess;

    public CollectionAction(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) {
        this.persister = collectionPersister;
        this.session = sessionImplementor;
        this.key = serializable;
        this.collectionRole = collectionPersister.getRole();
        this.collection = persistentCollection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    public void afterDeserialize(SessionImplementor sessionImplementor) {
        if (this.session != null || this.persister != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (sessionImplementor != null) {
            this.session = sessionImplementor;
            this.persister = sessionImplementor.getFactory().getCollectionPersister(this.collectionRole);
        }
    }

    @Override
    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = this.session.generateCacheKey(this.key, this.persister.getKeyType(), this.persister.getRole());
            SoftLock softLock = this.persister.getCacheAccessStrategy().lockItem(cacheKey, null);
            this.afterTransactionProcess = new CacheCleanupProcess(this.key, this.persister, softLock);
        }
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.afterTransactionProcess;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        Serializable serializable = this.key;
        if (!(this.key instanceof DelayedPostInsertIdentifier) || (serializable = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId()) == this.key) {
            // empty if block
        }
        return serializable;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = this.session.generateCacheKey(this.key, this.persister.getKeyType(), this.persister.getRole());
            this.persister.getCacheAccessStrategy().remove(cacheKey);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object object) {
        CollectionAction collectionAction = (CollectionAction)object;
        int n = this.collectionRole.compareTo(collectionAction.collectionRole);
        if (n != 0) {
            return n;
        }
        return this.persister.getKeyType().compare(this.key, collectionAction.key);
    }

    protected <T> EventListenerGroup<T> listenerGroup(EventType<T> eventType) {
        return this.getSession().getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(eventType);
    }

    protected EventSource eventSource() {
        return (EventSource)this.getSession();
    }

    private static class CacheCleanupProcess
    implements AfterTransactionCompletionProcess {
        private final Serializable key;
        private final CollectionPersister persister;
        private final SoftLock lock;

        private CacheCleanupProcess(Serializable serializable, CollectionPersister collectionPersister, SoftLock softLock) {
            this.key = serializable;
            this.persister = collectionPersister;
            this.lock = softLock;
        }

        public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
            CacheKey cacheKey = sessionImplementor.generateCacheKey(this.key, this.persister.getKeyType(), this.persister.getRole());
            this.persister.getCacheAccessStrategy().unlockItem(cacheKey, this.lock);
        }
    }
}

