/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.AssertionFailure;
import org.hibernate.type.VersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReplicationMode {
    EXCEPTION{

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            throw new AssertionFailure("should not be called");
        }
    }
    ,
    IGNORE{

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            return false;
        }
    }
    ,
    OVERWRITE{

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            return true;
        }
    }
    ,
    LATEST_VERSION{

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            if (versionType == null) {
                return true;
            }
            return versionType.getComparator().compare(object2, object3) <= 0;
        }
    };


    public abstract boolean shouldOverwriteCurrentVersion(Object var1, Object var2, Object var3, VersionType var4);
}

