/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MultiTenancyStrategy {
    DISCRIMINATOR,
    SCHEMA,
    DATABASE,
    NONE;

    private static final CoreMessageLogger LOG;

    public boolean requiresMultiTenantConnectionProvider() {
        return this == DATABASE || this == SCHEMA;
    }

    public static MultiTenancyStrategy determineMultiTenancyStrategy(Map map) {
        Object v = map.get("hibernate.multiTenancy");
        if (v == null) {
            return NONE;
        }
        if (MultiTenancyStrategy.class.isInstance(v)) {
            return (MultiTenancyStrategy)((Object)v);
        }
        String string = v.toString();
        try {
            return MultiTenancyStrategy.valueOf(string.toUpperCase());
        }
        catch (RuntimeException runtimeException) {
            LOG.warn("Unknown multi tenancy strategy [ " + string + " ], using MultiTenancyStrategy.NONE.");
            return NONE;
        }
    }

    static {
        LOG = Logger.getMessageLogger(CoreMessageLogger.class, MultiTenancyStrategy.class.getName());
    }
}

