/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;

public class LockOptions
implements Serializable {
    public static final LockOptions NONE = new LockOptions(LockMode.NONE);
    public static final LockOptions READ = new LockOptions(LockMode.READ);
    public static final LockOptions UPGRADE = new LockOptions(LockMode.UPGRADE);
    public static final int NO_WAIT = 0;
    public static final int WAIT_FOREVER = -1;
    private LockMode lockMode = LockMode.NONE;
    private int timeout = -1;
    private Map<String, LockMode> aliasSpecificLockModes = null;
    private boolean scope = false;

    public LockOptions() {
    }

    public LockOptions(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public LockOptions setAliasSpecificLockMode(String string, LockMode lockMode) {
        if (this.aliasSpecificLockModes == null) {
            this.aliasSpecificLockModes = new HashMap<String, LockMode>();
        }
        this.aliasSpecificLockModes.put(string, lockMode);
        return this;
    }

    public LockMode getAliasSpecificLockMode(String string) {
        if (this.aliasSpecificLockModes == null) {
            return null;
        }
        return this.aliasSpecificLockModes.get(string);
    }

    public LockMode getEffectiveLockMode(String string) {
        LockMode lockMode = this.getAliasSpecificLockMode(string);
        if (lockMode == null) {
            lockMode = this.lockMode;
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    public boolean hasAliasSpecificLockModes() {
        return this.aliasSpecificLockModes != null && !this.aliasSpecificLockModes.isEmpty();
    }

    public int getAliasLockCount() {
        if (this.aliasSpecificLockModes == null) {
            return 0;
        }
        return this.aliasSpecificLockModes.size();
    }

    public Iterator getAliasLockIterator() {
        if (this.aliasSpecificLockModes == null) {
            return Collections.emptyList().iterator();
        }
        return this.aliasSpecificLockModes.entrySet().iterator();
    }

    public LockMode findGreatestLockMode() {
        LockMode lockMode = this.getLockMode();
        if (lockMode == null) {
            lockMode = LockMode.NONE;
        }
        if (this.aliasSpecificLockModes == null) {
            return lockMode;
        }
        for (LockMode lockMode2 : this.aliasSpecificLockModes.values()) {
            if (!lockMode2.greaterThan(lockMode)) continue;
            lockMode = lockMode2;
        }
        return lockMode;
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int n) {
        this.timeout = n;
        return this;
    }

    public boolean getScope() {
        return this.scope;
    }

    public LockOptions setScope(boolean bl) {
        this.scope = bl;
        return this;
    }

    public static LockOptions copy(LockOptions lockOptions, LockOptions lockOptions2) {
        lockOptions2.setLockMode(lockOptions.getLockMode());
        lockOptions2.setScope(lockOptions.getScope());
        lockOptions2.setTimeOut(lockOptions.getTimeOut());
        if (lockOptions.aliasSpecificLockModes != null) {
            lockOptions2.aliasSpecificLockModes = new HashMap<String, LockMode>(lockOptions.aliasSpecificLockModes);
        }
        return lockOptions2;
    }

    public LockOptions makeCopy() {
        LockOptions lockOptions = new LockOptions();
        LockOptions.copy(this, lockOptions);
        return lockOptions;
    }
}

