/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;

public final class Hibernate {
    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(Object object) throws HibernateException {
        if (object == null) {
            return;
        }
        if (object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().initialize();
        } else if (object instanceof PersistentCollection) {
            ((PersistentCollection)object).forceInitialization();
        }
    }

    public static boolean isInitialized(Object object) {
        if (object instanceof HibernateProxy) {
            return !((HibernateProxy)object).getHibernateLazyInitializer().isUninitialized();
        }
        if (object instanceof PersistentCollection) {
            return ((PersistentCollection)object).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object object) {
        if (object instanceof HibernateProxy) {
            return ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return object.getClass();
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)((Object)session));
    }

    public static LobCreator getLobCreator(SessionImplementor sessionImplementor) {
        return sessionImplementor.getFactory().getJdbcServices().getLobCreator(sessionImplementor);
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object object, String string) {
        Object object2;
        Object object3;
        if (object instanceof HibernateProxy) {
            object3 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object3.isUninitialized()) {
                return false;
            }
            object2 = object3.getImplementation();
        } else {
            object2 = object;
        }
        if (FieldInterceptionHelper.isInstrumented(object2)) {
            object3 = FieldInterceptionHelper.extractFieldInterceptor(object2);
            return object3 == null || object3.isInitialized(string);
        }
        return true;
    }
}

