/*
 * Decompiled with CFR 0.152.
 */
package com.vp.ant;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;

public abstract class VPUMLCommandLineTask
extends Task {
    private Java _java = new Java();
    private boolean _headless = false;

    public void setProject(Project project) {
        this._java.setProject(project);
        super.setProject(project);
    }

    public void setTaskName(String string) {
        this._java.setTaskName(string);
        super.setTaskName(string);
    }

    public void setTaskType(String string) {
        this._java.setTaskType(string);
        super.setTaskType(string);
    }

    public void setHeadless(boolean bl) {
        this._headless = bl;
    }

    public VPUMLCommandLineTask() {
        this._java.setFork(true);
        this._java.setClassname("com.vp.cmd." + this.getClassName());
    }

    public void setProduct(String string) {
        this.addArgument("-product");
        this.addArgument(string);
    }

    public void setWorkspace(File file) {
        this.addArgument("-workspace");
        this.addArgument(file);
    }

    protected void addArgument(String string) {
        this._java.createArg().setValue(string);
    }

    protected void addArgument(File file) {
        this._java.createArg().setFile(file);
    }

    protected abstract String getClassName();

    public void execute() throws BuildException {
        Object object;
        File file = this.getJarDir();
        File file2 = new File(file.getParentFile(), "lib");
        if (file2.exists()) {
            object = file2.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".jar");
                }
            });
            if (object != null) {
                for (int i = 0; i < ((File[])object).length; ++i) {
                    this._java.createClasspath().setLocation(object[i]);
                }
            }
            this._java.createClasspath().setLocation(new File(file2.getParent(), "ormlib/orm.jar"));
            this._java.createClasspath().setLocation(new File(file2.getParent(), "ormlib/orm-core.jar"));
        }
        this._java.setDir(new File(file2.getParentFile(), "bin"));
        object = "-Xms128m -Xmx1024m";
        if (this._headless) {
            object = (String)object + " -Djava.awt.headless=true";
        }
        this._java.createJvmarg().setLine((String)object);
        this._java.execute();
    }

    private File getJarDir() {
        String string = ((Object)((Object)this)).getClass().getResource("/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").toString();
        if (string.startsWith("jar:file:/")) {
            File file;
            int n;
            string = string.substring("jar:file:/".length());
            if (File.separatorChar == '/') {
                string = "/" + string;
            }
            if ((n = string.lastIndexOf("!")) > 0) {
                string = string.substring(0, n);
            }
            if ((file = new File(string = string.replace("%20", " "))).exists()) {
                return file.getParentFile();
            }
        }
        return new File(".");
    }
}

