/*
 * Decompiled with CFR 0.152.
 */
package com.vp.ant;

import com.vp.ant.Diagram;
import com.vp.ant.VPUMLCommandLineTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class ExportXML
extends VPUMLCommandLineTask {
    private List _diagrams = new ArrayList();

    public void setProject(File file) {
        this.addArgument("-project");
        this.addArgument(file);
    }

    public void setOut(File file) {
        this.addArgument("-out");
        this.addArgument(file);
    }

    public void setNoImage(boolean bl) {
        if (bl) {
            this.addArgument("-noimage");
        }
    }

    public void setRefModel(boolean bl) {
        this.addArgument("-refmodel");
        this.addArgument(String.valueOf(bl));
    }

    public void addDiagram(Diagram diagram) {
        this._diagrams.add(diagram);
    }

    public void execute() throws BuildException {
        if (this._diagrams.size() > 0) {
            this.addArgument("-diagram");
            try {
                File file = File.createTempFile("ExportDiagramImage", "");
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                for (Diagram diagram : this._diagrams) {
                    printWriter.println(diagram.getName());
                }
                printWriter.close();
                this.addArgument("@" + file.getAbsolutePath());
                file.deleteOnExit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        super.execute();
    }

    protected String getClassName() {
        return "ExportXML";
    }
}

