/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxdesktop.win32.registry;

import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.teamdev.jxdesktop.win32.o;
import com.teamdev.jxdesktop.win32.registry.RegistryEventListener;
import com.teamdev.jxdesktop.win32.registry.RegistryException;
import com.teamdev.jxdesktop.win32.registry.RegistryKeyValues;
import com.teamdev.jxdesktop.win32.registry.g;
import com.teamdev.jxdesktop.win32.registry.h;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryKey
extends o {
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647L, "HKEY_CURRENT_USER");
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646L, "HKEY_LOCAL_MACHINE");
    public static final RegistryKey USERS = new RegistryKey(-2147483645L, "HKEY_USERS");
    public static final RegistryKey PERFORMANCE_DATA = new RegistryKey(-2147483644L, "HKEY_PERFORMANCE_DATA");
    public static final RegistryKey CURRENT_CONFIG = new RegistryKey(-2147483643L, "HKEY_CURRENT_CONFIG");
    public static final RegistryKey DYN_DATA = new RegistryKey(-2147483642L, "HKEY_DYN_DATA");
    private static final Logger a = LoggerFactory.getLogger(RegistryKey.class);
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    private String b = "";
    private String c = "";
    private RegistryKey d;
    private int e = 0;
    private RegistryKeyValues f;
    private boolean g = false;
    private List h = new LinkedList();
    private RegistryAccessMode i = RegistryAccessMode.DEFAULT;

    private RegistryKey() {
    }

    private RegistryKey(long l2) {
        super(l2);
    }

    private RegistryKey(long l2, String string) {
        super(l2);
        this.c = string;
        this.d = new RegistryKey(this.getValue());
    }

    public RegistryAccessMode getRegistryAccessMode() {
        return this.i;
    }

    public String getName() {
        return this.c;
    }

    public String getPath() {
        return this.b;
    }

    public String getAbsolutePath() {
        String string = this.getPath();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0 && !string.endsWith("\\")) {
            stringBuffer.append('\\');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    protected void checkError() {
        if (this.e != 0) {
            throw new RegistryException(this.e);
        }
    }

    protected void checkError(long l2) {
        this.e = (int)l2;
        this.checkError();
    }

    public int getSubKeyCount() {
        UInt32 uInt32 = new UInt32();
        this.checkError(com.teamdev.jxdesktop.win32.registry.g.a(this, null, null, uInt32, null, null, null, null, null));
        return (int)uInt32.getValue();
    }

    public void close() {
        this.checkError(com.teamdev.jxdesktop.win32.registry.g.a(this));
    }

    public RegistryKey createSubKey(String string, boolean bl2) {
        return this.createSubKey(string, bl2, RegistryAccessMode.DEFAULT);
    }

    public RegistryKey createSubKey(String string, RegistryAccessMode registryAccessMode) {
        return this.createSubKey(string, false, registryAccessMode);
    }

    public RegistryKey createSubKey(String string, boolean bl2, RegistryAccessMode registryAccessMode) {
        RegistryKey registryKey = new RegistryKey();
        new RegistryKey().i = registryAccessMode;
        this.checkError(com.teamdev.jxdesktop.win32.registry.g.a((o)this, string, 0L, bl2 ? (long)(0x2001F | registryAccessMode.getValue()) : (long)(0x20019 | registryAccessMode.getValue()), registryKey));
        registryKey.b = this.getAbsolutePath();
        registryKey.c = string;
        registryKey.d = this.getRootKey();
        return registryKey;
    }

    public RegistryKey createSubKey(String string) {
        return this.createSubKey(string, false);
    }

    public void deleteSubKey(String string) {
        this.deleteSubKey(string, this.i);
    }

    public void deleteSubKey(String string, RegistryAccessMode registryAccessMode) {
        this.checkError(com.teamdev.jxdesktop.win32.registry.g.a(this, string, registryAccessMode.getValue()));
    }

    public void deleteSubTree(String string) {
        RegistryKey registryKey = this.openSubKey(string, true);
        int n2 = 0;
        Str str = new Str(260);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (com.teamdev.jxdesktop.win32.registry.g.a((o)registryKey, n2++, str, new UInt32(260L), null, null) == 0L) {
            linkedList.add(str.getValue());
        }
        for (n2 = 0; n2 < linkedList.size(); ++n2) {
            registryKey.deleteSubTree((String)linkedList.get(n2));
        }
        registryKey.close();
        this.deleteSubKey(string);
    }

    public void rename(String object) {
        Object object2 = this.getAbsolutePath();
        String string = "";
        try {
            string = ((String)object2).substring(((String)object2).indexOf("\\") + 1, ((String)object2).lastIndexOf("\\"));
        }
        catch (Exception exception) {}
        object2 = this.getRootKey();
        if (string.length() != 0) {
            object2 = ((RegistryKey)((Object)object2)).openSubKey(string);
        }
        object = this.copy((RegistryKey)((Object)object2), (String)object, false);
        string = this.getName().lastIndexOf("\\") != -1 ? this.getName().substring(this.getName().lastIndexOf("\\") + 1) : this.getName();
        ((RegistryKey)((Object)object2)).deleteSubTree(string);
        ((RegistryKey)((Object)object2)).close();
        this.setValue(object.getValue());
        this.b = ((RegistryKey)((Object)object)).b;
        this.c = ((RegistryKey)((Object)object)).c;
        this.d = ((RegistryKey)((Object)object)).getRootKey();
    }

    public RegistryKey getRootKey() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RegistryKey)) {
            return false;
        }
        object = (RegistryKey)((Object)object);
        return this.getValue() == object.getValue();
    }

    public int hashCode() {
        return (int)this.getValue();
    }

    public void flush() {
        this.checkError(com.teamdev.jxdesktop.win32.registry.g.b(this));
    }

    public List getSubKeyNames() {
        int n2 = this.getSubKeyCount();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        if (n2 > 0) {
            n2 = 0;
            int n3 = 0;
            while (n3 == 0) {
                Str str = new Str("", 260);
                n3 = (int)com.teamdev.jxdesktop.win32.registry.g.a((o)this, n2, str, new UInt32(260L), null, null);
                if (n3 == 0) {
                    arrayList.add(str.getValue());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    public RegistryKey openSubKey(String string) {
        return this.openSubKey(string, false, false);
    }

    public RegistryKey openSubKey(String string, boolean bl2) {
        return this.openSubKey(string, bl2, false);
    }

    public RegistryKey openSubKey(String string, boolean bl2, boolean bl3) {
        return this.openSubKey(string, bl2, bl3, RegistryAccessMode.DEFAULT);
    }

    public RegistryKey openSubKey(String string, boolean bl2, boolean bl3, RegistryAccessMode registryAccessMode) {
        RegistryKey registryKey = new RegistryKey();
        new RegistryKey().i = registryAccessMode;
        registryKey.e = (int)com.teamdev.jxdesktop.win32.registry.g.a((o)this, string.startsWith("\\\\") ? string.replaceFirst("\\\\+", "") : string, bl2 ? 0x2001F | registryAccessMode.getValue() : 0x20019 | registryAccessMode.getValue(), registryKey);
        registryKey.b = this.getAbsolutePath();
        registryKey.c = string;
        registryKey.d = this.getRootKey();
        if (!bl3) {
            registryKey.checkError();
        }
        return registryKey;
    }

    public RegistryKey openSubKey(String string, boolean bl2, RegistryAccessMode registryAccessMode) {
        return this.openSubKey(string, bl2, false, registryAccessMode);
    }

    public RegistryKey openSubKey(String string, RegistryAccessMode registryAccessMode) {
        return this.openSubKey(string, false, false, registryAccessMode);
    }

    public boolean exists(String string) {
        RegistryKey registryKey = new RegistryKey();
        this.e = (int)com.teamdev.jxdesktop.win32.registry.g.a((o)this, string, 0x20019 | this.i.getValue(), registryKey);
        boolean bl2 = this.e != 2;
        if (bl2) {
            registryKey.close();
        }
        return bl2;
    }

    public RegistryKey copy(RegistryKey object, String string, boolean bl2) {
        if (object == null) {
            throw new IllegalArgumentException("newBase parameter cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("newName parameter cannot be null.");
        }
        RegistryKey registryKey = new RegistryKey();
        UInt32 uInt32 = new UInt32();
        RegistryKey registryKey2 = object;
        ((RegistryKey)((Object)list)).checkError(com.teamdev.jxdesktop.win32.registry.g.a((o)registryKey2, string, 0L, 0x2001F | ((RegistryKey)((Object)list)).i.getValue(), registryKey, uInt32));
        registryKey.b = ((RegistryKey)((Object)list)).b;
        registryKey.c = string;
        registryKey.d = ((RegistryKey)((Object)list)).getRootKey();
        if (uInt32.getValue() == 2L && !bl2) {
            throw new RegistryException("The specified registry key already exists.");
        }
        int n2 = 0;
        Object object2 = new Str(260);
        while (com.teamdev.jxdesktop.win32.registry.g.a((o)((Object)list), n2++, (Str)object2, new UInt32(260L), null, null) == 0L) {
            ((RegistryKey)((Object)list)).openSubKey(object2.getValue()).copy((RegistryKey)((Object)object), registryKey.getName() + "\\" + object2.getValue(), true);
        }
        List list = ((RegistryKey)((Object)list)).values().getEntries();
        object = registryKey.values();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object2 = (RegistryKeyValues.RegistryValueEntry)list.get(n2);
            ((RegistryKeyValues)object).put(((RegistryKeyValues.RegistryValueEntry)object2).getKey(), ((RegistryKeyValues.RegistryValueEntry)object2).getValue(), ((RegistryKeyValues.RegistryValueEntry)object2).getType());
        }
        return registryKey;
    }

    public List getSubkeys() {
        Object object = this.getSubKeyNames();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            try {
                RegistryKey registryKey = this.openSubKey((String)object2);
                linkedList.add((Object)registryKey);
            }
            catch (RegistryException registryException) {
                a.error("Failed to read the registry key " + this.getAbsolutePath() + '\\' + object2, (Throwable)registryException);
                object2 = this.openSubKey((String)object2, false, true);
                linkedList.add(object2);
            }
        }
        return linkedList;
    }

    public RegistryKeyValues values() {
        RegistryKey registryKey = this;
        if (registryKey.isNull()) {
            registryKey.checkError(com.teamdev.jxdesktop.win32.registry.g.a(new o(registryKey.getValue()), "", 0x20019 | registryKey.i.getValue(), registryKey));
        }
        if (this.f == null) {
            this.f = new RegistryKeyValues(this);
        }
        return this.f;
    }

    public o getHandle() {
        return this;
    }

    public void addRegistryEventListener(RegistryEventListener registryEventListener) {
        if (!this.h.contains(registryEventListener)) {
            this.h.add(registryEventListener);
        }
    }

    public void removeRegistryEventListener(RegistryEventListener registryEventListener) {
        this.h.remove(registryEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistryEvent(EventObject eventObject) {
        Object object = linkedList;
        synchronized (object) {
            LinkedList linkedList = new LinkedList(((RegistryKey)((Object)linkedList)).h);
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            ((RegistryEventListener)object.next()).handle(eventObject);
        }
    }

    public void startChangeListening(boolean bl2, int n2) {
        new Thread(new h(this, bl2, n2)).start();
    }

    public void startChangeListening() {
        this.startChangeListening(true, 15);
    }

    public void stopChangeListening() {
        this.g = false;
        this.close();
    }

    static /* synthetic */ boolean a(RegistryKey registryKey) {
        registryKey.g = true;
        return true;
    }

    static /* synthetic */ boolean b(RegistryKey registryKey) {
        return registryKey.g;
    }

    public static class RegistryAccessMode
    extends EnumItem {
        public static final RegistryAccessMode DEFAULT = new RegistryAccessMode(0);
        public static final RegistryAccessMode WOW64 = new RegistryAccessMode(256);
        public static final RegistryAccessMode WOW32 = new RegistryAccessMode(512);

        private RegistryAccessMode(int n2) {
            super(n2);
        }
    }
}

